/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.work;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntry;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntryFactory;
import com.atlassian.greenhopper.web.rapid.work.ParentSwimlanesData;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ParentSwimlanesDataCallback
extends AbstractCompoundDataCallback {
    private final ApplicationUser user;
    private final TransitionEntryFactory transitionEntryFactory;
    String[] fields = new String[]{"issue_parenttask", "status"};
    Set<String> todoColumnIds;
    Set<String> doneColumnIds;
    Set<Long> possibleParentIds;
    Set<Long> parentIds;
    Map<Long, String> parentStatuses;
    Map<Long, SubCounts> subCountsPerParent;

    public ParentSwimlanesDataCallback(Collection<String> todoColumnIds, Collection<String> doneColumnIds, Set<Long> possibleParentIds, ApplicationUser user, TransitionEntryFactory transitionEntryFactory) {
        this.user = user;
        this.transitionEntryFactory = transitionEntryFactory;
        this.todoColumnIds = new HashSet<String>(todoColumnIds);
        this.doneColumnIds = new HashSet<String>(doneColumnIds);
        this.possibleParentIds = possibleParentIds;
        this.parentIds = new HashSet<Long>();
        this.parentStatuses = new HashMap<Long, String>();
        this.subCountsPerParent = new HashMap<Long, SubCounts>();
    }

    @Override
    public Set<String> getFields() {
        return new HashSet<String>(Arrays.asList(this.fields));
    }

    @Override
    protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
        String parentIdString = data.get("issue_parenttask");
        if (parentIdString == null) {
            String statusId = data.get("status");
            this.parentStatuses.put(issueId, statusId);
        } else {
            Long parentId = Long.valueOf(parentIdString);
            this.parentIds.add(parentId);
            String statusId = data.get("status");
            SubCounts subCounts = this.subCountsPerParent.get(parentId);
            if (subCounts == null) {
                subCounts = new SubCounts();
                this.subCountsPerParent.put(parentId, subCounts);
            }
            if (this.todoColumnIds.contains(statusId)) {
                ++subCounts.todo;
            } else if (this.doneColumnIds.contains(statusId)) {
                ++subCounts.done;
            } else {
                ++subCounts.inpro;
            }
        }
    }

    public ServiceOutcome<ParentSwimlanesData> getParentSwimlanesData() {
        HashSet<Long> realParents = new HashSet<Long>(this.possibleParentIds);
        realParents.retainAll(this.parentIds);
        HashSet<Long> inprogressCandidates = new HashSet<Long>();
        HashSet<Long> doneCandidates = new HashSet<Long>();
        for (Long parentId : realParents) {
            String parentStatus;
            SubCounts subCounts = this.subCountsPerParent.get(parentId);
            if (subCounts == null) continue;
            if (subCounts.todo == 0 && subCounts.inpro == 0) {
                ServiceOutcome<List<String>> availableStatuses = this.getAvailableTransitionStatuses(parentId);
                if (!availableStatuses.isValid()) {
                    return ServiceOutcomeImpl.error(availableStatuses);
                }
                String parentStatus2 = this.parentStatuses.get(parentId);
                if (!this.doneColumnIds.contains(parentStatus2) && CollectionUtils.containsAny(this.doneColumnIds, (Collection)availableStatuses.get())) {
                    doneCandidates.add(parentId);
                }
            }
            if (subCounts.inpro <= 0 && subCounts.done <= 0 || this.todoColumnIds.contains(parentStatus = this.parentStatuses.get(parentId))) continue;
            inprogressCandidates.add(parentId);
        }
        ParentSwimlanesData info = new ParentSwimlanesData();
        info.setParentIssueIds(realParents);
        info.setInprogressCandidates(inprogressCandidates);
        info.setDoneCandidates(doneCandidates);
        return ServiceOutcomeImpl.ok(info);
    }

    private ServiceOutcome<List<String>> getAvailableTransitionStatuses(Long issueid) {
        ServiceOutcome<IssueTransitions> issueTransitionsServiceOutcome = this.transitionEntryFactory.buildTransitions(this.user, issueid);
        if (issueTransitionsServiceOutcome.isValid()) {
            LinkedList<String> statusStrings = new LinkedList<String>();
            for (TransitionEntry e : issueTransitionsServiceOutcome.get().transitions) {
                statusStrings.add(e.targetStatus.toString());
            }
            return ServiceOutcomeImpl.ok(statusStrings);
        }
        return ServiceOutcomeImpl.error(issueTransitionsServiceOutcome);
    }

    static class SubCounts {
        int todo;
        int inpro;
        int done;

        SubCounts() {
        }
    }
}

