/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.welcome;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.welcome.SampleDataProjectNameGenerator;
import com.atlassian.greenhopper.web.rapid.welcome.SampleProjectKeyNamePair;
import com.atlassian.greenhopper.web.rapid.welcome.WelcomeCreateProjectRequest;
import com.atlassian.greenhopper.web.rapid.welcome.WelcomeCreateResponse;
import com.atlassian.greenhopper.web.rapid.welcome.WelcomeHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="welcome")
@Produces(value={"application/json"})
public class WelcomeResource
extends AbstractResource {
    private WelcomeHelper welcomeHelper;
    private SampleDataProjectNameGenerator sampleDataProjectNameGenerator;

    public WelcomeResource(WelcomeHelper welcomeHelper, SampleDataProjectNameGenerator sampleDataProjectNameGenerator) {
        this.welcomeHelper = welcomeHelper;
        this.sampleDataProjectNameGenerator = sampleDataProjectNameGenerator;
    }

    @GET
    @Path(value="/validateViewFind")
    @AnonymousAllowed
    public Response validateViewFind(final @QueryParam(value="id") String id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<Void> result = WelcomeResource.this.welcomeHelper.validateViewFind(WelcomeResource.this.getUser(), id);
                WelcomeResource.this.check(result);
                return WelcomeResource.this.createNoContentResponse();
            }
        });
    }

    @PUT
    @Path(value="/createProject")
    public Response createProject(final WelcomeCreateProjectRequest createProjectRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                WelcomeCreateResponse result = WelcomeResource.this.check(WelcomeResource.this.welcomeHelper.createProject(WelcomeResource.this.getUser(), createProjectRequest));
                return WelcomeResource.this.createOkResponse(result);
            }
        });
    }

    @GET
    @Path(value="/sampledataproject")
    public Response getNextSampleProject(final @QueryParam(value="preset") String preset) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                Option<SampleProjectKeyNamePair> nextSampleDataProjectName = WelcomeResource.this.sampleDataProjectNameGenerator.getNextSampleDataProjectName(preset);
                return (Response)nextSampleDataProjectName.map((java.util.function.Function)new Function<SampleProjectKeyNamePair, Response>(){

                    public Response apply(SampleProjectKeyNamePair sampleProjectKeyNamePair) {
                        return Response.ok((Object)sampleProjectKeyNamePair).build();
                    }
                }).getOrElse((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        });
    }
}

