/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.welcome;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.sampledata.SampleDataGenerator;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.project.ProjectService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.greenhopper.web.rapid.welcome.WelcomeCreateProjectRequest;
import com.atlassian.greenhopper.web.rapid.welcome.WelcomeCreateResponse;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WelcomeHelper {
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RapidViewHelper rapidViewHelper;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidViewPresetService rapidViewPresetService;
    @Autowired
    private SampleDataGenerator sampleDataGenerator;
    @Autowired
    private BoardAdminManager boardAdminManager;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    private final LoggerWrapper logger = LoggerWrapper.with(WelcomeHelper.class);

    public ServiceOutcome<Void> validateViewFind(ApplicationUser user, String idString) {
        Long viewId = null;
        try {
            viewId = Long.parseLong(idString);
        }
        catch (NumberFormatException e) {
            return ServiceOutcomeImpl.error("viewName", ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.welcome.view.error.invalid", new Object[0]);
        }
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, viewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<WelcomeCreateResponse> createProject(ApplicationUser user, WelcomeCreateProjectRequest createProjectRequest) {
        RapidView rapidView;
        Project project;
        ServiceResult validationOutcome = this.projectService.validateCreateProject(user, createProjectRequest.projectName, createProjectRequest.projectKey, createProjectRequest.projectLeadUserName);
        if (validationOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(validationOutcome);
        }
        Optional<RapidViewPreset> presetOpt = RapidViewPreset.get(createProjectRequest.preset);
        if (!presetOpt.isPresent()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.welcome.view.invalid.preset", new Object[0]);
        }
        RapidViewPreset preset = presetOpt.get();
        if (!RapidViewPreset.SCRUM.equals((Object)preset) && !RapidViewPreset.KANBAN.equals((Object)preset)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.welcome.view.invalid.preset", new Object[0]);
        }
        if (Boolean.TRUE.equals(createProjectRequest.sampleData)) {
            ServiceOutcome<Project> sampleDataOutput = null;
            if (preset.equals((Object)RapidViewPreset.KANBAN)) {
                sampleDataOutput = this.sampleDataGenerator.createSampleKanbanData(createProjectRequest.projectKey, createProjectRequest.projectName, (Option<String>)Option.option((Object)createProjectRequest.projectLeadUserName));
            } else if (preset.equals((Object)RapidViewPreset.SCRUM)) {
                sampleDataOutput = this.sampleDataGenerator.createSampleScrumData(createProjectRequest.projectKey, createProjectRequest.projectName, (Option<String>)Option.option((Object)createProjectRequest.projectLeadUserName));
            }
            if (!sampleDataOutput.isValid()) {
                return ServiceOutcomeImpl.error(sampleDataOutput);
            }
            project = (Project)sampleDataOutput.getValue();
            ServiceOutcome<RapidView> rapidViewOutcome = this.createRapidView(user, preset, project);
            if (!rapidViewOutcome.isValid()) {
                this.logger.info("deleting project: %d", project.getId());
                this.projectService.deleteProject(user, project);
                return ServiceOutcomeImpl.error(rapidViewOutcome);
            }
            rapidView = rapidViewOutcome.getValue();
            this.addProjectLeadAsBoardAdmin(project, rapidView);
            if (preset.equals((Object)RapidViewPreset.KANBAN)) {
                preset = RapidViewPreset.SAMPLE_KANBAN;
            }
            this.updateColumns(user, rapidView, preset);
        } else {
            ServiceOutcome<Project> projectOutcome = this.createProject(user, createProjectRequest.projectName, createProjectRequest.projectKey, createProjectRequest.projectLeadUserName, preset);
            if (!projectOutcome.isValid()) {
                return ServiceOutcomeImpl.error(projectOutcome);
            }
            project = projectOutcome.getValue();
            ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewHelper.getDefaultRapidViewForProject(user, project);
            if (rapidViewOutcome.isInvalid()) {
                return ServiceOutcomeImpl.from(rapidViewOutcome.getErrors());
            }
            rapidView = rapidViewOutcome.getValue();
        }
        return ServiceOutcomeImpl.ok(this.buildResponse(user, project, rapidView, preset));
    }

    private void addProjectLeadAsBoardAdmin(Project project, RapidView rapidView) {
        if (!this.jiraAuthenticationContext.getLoggedInUser().equals((Object)project.getProjectLead())) {
            BoardAdmin projectLead = BoardAdmin.builder().key(project.getProjectLead().getKey()).type(BoardAdmin.Type.USER).build();
            this.boardAdminManager.appendBoardAdmin(rapidView, Arrays.asList(projectLead));
        }
    }

    private WelcomeCreateResponse buildResponse(ApplicationUser user, Project project, RapidView rapidView, RapidViewPreset preset) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        WelcomeCreateResponse createResponse = new WelcomeCreateResponse();
        createResponse.project.id = project.getId();
        createResponse.project.key = project.getKey();
        createResponse.project.name = project.getName();
        createResponse.project.leadDisplayName = project.getProjectLead().getDisplayName();
        createResponse.project.leadUserName = project.getLeadUserName();
        createResponse.preset = preset.toString().toLowerCase();
        createResponse.rapidView.id = rapidView.getId();
        createResponse.rapidView.filterId = rapidView.getSavedFilterId();
        createResponse.rapidView.name = rapidView.getName();
        for (Column column : this.columnService.getVisibleColumns(rapidView)) {
            if (StringUtils.isBlank((CharSequence)column.getName())) continue;
            createResponse.rapidView.columnNames.add(i18n.getText(column.getName()));
        }
        return createResponse;
    }

    @Nonnull
    private ServiceOutcome<Project> createProject(ApplicationUser user, String projectName, String projectKey, String projectLeadUserName, RapidViewPreset preset) {
        ProjectType projectType = RapidViewPresetService.getAssociatedProjectType(preset);
        return this.projectService.createProject(user, projectName, projectKey, null, projectLeadUserName, null, 3L, null, projectType);
    }

    private ServiceResult updateColumns(ApplicationUser user, RapidView rapidView, RapidViewPreset preset) {
        List<Column> defaultColumns = this.rapidViewPresetService.createColumnsForSimplifiedWorkflow(preset);
        return this.columnService.updateColumns(user, rapidView, defaultColumns);
    }

    @VisibleForTesting
    ServiceOutcome<RapidView> createRapidView(ApplicationUser user, RapidViewPreset preset, Project project) {
        String boardName = this.rapidViewHelper.getDefaultBoardName(project, user);
        return this.rapidViewHelper.createRapidViewWithProjects(user, boardName, preset, Collections.singletonList(project));
    }
}

