/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.welcome;

import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.greenhopper.web.rapid.welcome.SampleProjectKeyNamePair;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Option;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleDataProjectNameGenerator {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private ProjectManager projectManager;

    public Option<SampleProjectKeyNamePair> getNextSampleDataProjectName(String presetName) {
        Optional<RapidViewPreset> preset = RapidViewPreset.get(presetName);
        if (!preset.isPresent()) {
            return Option.none();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        String defaultProjectName = this.i18nFactoryService.getI18n(user).getText("gh.sampledata.sample.project." + preset.get().name().toLowerCase() + ".name");
        String defaultProjectKey = this.getProjectKey(defaultProjectName);
        SampleProjectKeyNamePair project = new SampleProjectKeyNamePair(defaultProjectKey, defaultProjectName);
        if (!this.isProjectTaken(project)) {
            return Option.some((Object)project);
        }
        project = new SampleProjectKeyNamePair(defaultProjectKey + "A", defaultProjectName + " A");
        while (this.isProjectTaken(project)) {
            project = this.mutateProjectName(project);
        }
        return Option.some((Object)project);
    }

    private boolean isProjectTaken(SampleProjectKeyNamePair project) {
        return this.projectManager.getProjectObjByName(project.projectName) != null || this.projectManager.getProjectObjByKey(project.projectKey) != null;
    }

    private String getProjectKey(String projectName) {
        String[] split = projectName.split("\\s");
        String key = "";
        for (String s : split) {
            key = key + s.substring(0, 1);
        }
        return key;
    }

    private SampleProjectKeyNamePair mutateProjectName(SampleProjectKeyNamePair project) {
        Object[] split = project.projectName.split("\\s");
        String lastToken = split[split.length - 1];
        char lastChar = lastToken.charAt(lastToken.length() - 1);
        String newToken = lastChar == 'Z' ? lastToken.substring(0, lastToken.length() - 1) + "AA" : lastToken.substring(0, lastToken.length() - 1) + (char)(lastChar + '\u0001');
        String newKey = project.projectKey.substring(0, project.projectKey.length() - lastToken.length()) + newToken;
        split[split.length - 1] = newToken;
        String newName = StringUtils.join((Object[])split, (String)" ");
        return new SampleProjectKeyNamePair(newKey, newName);
    }
}

