/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.workingdays;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.chart.WorkRateDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WeekDaysModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WorkingDaysHelper;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;

@Path(value="/rapidviewconfig/workingdays")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkingDaysResource
extends AbstractResource {
    private WorkingDaysHelper workingDaysHelper;
    private WorkRateDataFactory workRateDataFactory;
    private TimeZoneManager timeZoneManager;
    private RapidViewService rapidViewService;
    private SprintTimeRemainingService sprintTimeRemainingService;

    public WorkingDaysResource(WorkingDaysHelper workingDaysHelper, WorkRateDataFactory workRateDataFactory, TimeZoneManager timeZoneManager, RapidViewService rapidViewService, SprintTimeRemainingService sprintTimeRemainingService) {
        this.workingDaysHelper = workingDaysHelper;
        this.workRateDataFactory = workRateDataFactory;
        this.timeZoneManager = timeZoneManager;
        this.rapidViewService = rapidViewService;
        this.sprintTimeRemainingService = sprintTimeRemainingService;
    }

    @PUT
    @Path(value="/weekdays")
    public Response updateWeekDaysOff(final WeekDaysModel weekDaysModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<WeekDaysModel> outcome = WorkingDaysResource.this.workingDaysHelper.updateWeekDays(WorkingDaysResource.this.getUser(), weekDaysModel);
                WorkingDaysResource.this.check(outcome);
                return WorkingDaysResource.this.createOkResponse(outcome.getValue());
            }
        });
    }

    @PUT
    @Path(value="/timezone")
    public Response updateTimeZone(final TimeZoneRequest timeZoneRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<WorkingDaysConfig> outcome = WorkingDaysResource.this.workingDaysHelper.updateTimeZone(WorkingDaysResource.this.getUser(), timeZoneRequest.rapidViewId, timeZoneRequest.timeZoneId);
                WorkingDaysResource.this.check(outcome);
                return WorkingDaysResource.this.createOkResponse(timeZoneRequest);
            }
        });
    }

    @POST
    @Path(value="/nonworkingday/add")
    public Response addNonWorkingDay(final NonWorkingDayRequest nonWorkingDayRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<WorkingDaysConfig> outcome = WorkingDaysResource.this.workingDaysHelper.addNonWorkingDay(WorkingDaysResource.this.getUser(), nonWorkingDayRequest);
                WorkingDaysResource.this.check(outcome);
                return WorkingDaysResource.this.createOkResponse(nonWorkingDayRequest);
            }
        });
    }

    @POST
    @Path(value="/nonworkingday/remove")
    public Response removeNonWorkingDay(final NonWorkingDayRequest nonWorkingDayRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<WorkingDaysConfig> outcome = WorkingDaysResource.this.workingDaysHelper.removeNonWorkingDay(WorkingDaysResource.this.getUser(), nonWorkingDayRequest);
                WorkingDaysResource.this.check(outcome);
                return WorkingDaysResource.this.createOkResponse(nonWorkingDayRequest);
            }
        });
    }

    @GET
    @Path(value="/rates")
    @AnonymousAllowed
    public Response getRates(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="startDate") Long startDate, final @QueryParam(value="endDate") Long endDate) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = WorkingDaysResource.this.getUser();
                RapidView rapidView = WorkingDaysResource.this.check(WorkingDaysResource.this.rapidViewService.getRapidView(user, rapidViewId));
                TimeZone timeZone = WorkingDaysResource.this.timeZoneManager.getLoggedInUserTimeZone();
                DateTime startDateTime = new DateTime((Object)startDate);
                DateTime endDateTime = new DateTime((Object)endDate);
                WorkRateData workRate = WorkingDaysResource.this.check(WorkingDaysResource.this.workRateDataFactory.getWorkRateData(user, rapidView, timeZone, startDateTime, endDateTime));
                return WorkingDaysResource.this.createOkResponse(workRate);
            }
        });
    }

    @GET
    @Path(value="/period")
    public Response getWorkdaysInPeriod(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="startDate") Long startDate, final @QueryParam(value="endDate") Long endDate) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = WorkingDaysResource.this.getUser();
                RapidView rapidView = WorkingDaysResource.this.check(WorkingDaysResource.this.rapidViewService.getRapidView(user, rapidViewId));
                DateTime startDateTime = new DateTime((Object)startDate);
                DateTime endDateTime = new DateTime((Object)endDate);
                SprintTimeRemaining sprintTimeRemaining = WorkingDaysResource.this.check(WorkingDaysResource.this.sprintTimeRemainingService.getWorkdaysInPeriod(user, rapidView, startDateTime, endDateTime));
                WorkingDaysInPeriodResponse response = new WorkingDaysInPeriodResponse();
                response.days = sprintTimeRemaining.days;
                return Response.ok((Object)response).build();
            }
        });
    }

    @XmlRootElement
    public static class TimeZoneRequest
    extends RestTemplate {
        @XmlElement
        public Long rapidViewId;
        @XmlElement
        public String timeZoneId;
    }

    @XmlRootElement
    public static class NonWorkingDayRequest
    extends RestTemplate {
        @XmlElement
        public Long rapidViewId;
        @XmlElement
        public String iso8601Date;
    }

    @XmlRootElement
    public static class WorkingDaysInPeriodResponse
    extends RestTemplate {
        @XmlElement
        public int days;
    }
}

