/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.workingdays;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.greenhopper.web.rapid.view.workingdays.NonWorkingDayModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.TimeZoneEditModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WeekDaysModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WorkingDaysConfigModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WorkingDaysResource;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysHelper {
    public static final String DEFAULT_REGION_KEY = "defaultRegionKey";
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private WorkingDaysService workingDaysService;
    @Autowired
    private TimeZoneService timeZoneService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public ServiceOutcome<WorkingDaysConfigModel> getWorkDaysConfigModel(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<WorkingDaysConfig> workingDaysConfig = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView);
        if (!workingDaysConfig.isValid()) {
            return ServiceOutcomeImpl.error(workingDaysConfig);
        }
        return ServiceOutcomeImpl.ok(this.fromConfig(user, rapidView, workingDaysConfig.getValue()));
    }

    private WorkingDaysConfigModel fromConfig(ApplicationUser user, RapidView rapidView, WorkingDaysConfig workingDaysConfig) {
        boolean canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        WorkingDaysConfigModel model = new WorkingDaysConfigModel();
        model.weekDays = this.buildWeekDaysModel(rapidView, workingDaysConfig);
        model.nonWorkingDays = this.getNonWorkingDaysModels(workingDaysConfig);
        model.timeZoneEditModel = this.buildTimeZoneEditModel(user, workingDaysConfig, canEdit);
        model.rapidViewId = rapidView.getId();
        model.canEdit = canEdit;
        return model;
    }

    private WeekDaysModel buildWeekDaysModel(RapidView rapidView, WorkingDaysConfig workingDaysConfig) {
        WeekDaysModel model = new WeekDaysModel();
        model.rapidViewId = rapidView.getId();
        model.monday = workingDaysConfig.isMonday();
        model.tuesday = workingDaysConfig.isTuesday();
        model.wednesday = workingDaysConfig.isWednesday();
        model.thursday = workingDaysConfig.isThursday();
        model.friday = workingDaysConfig.isFriday();
        model.saturday = workingDaysConfig.isSaturday();
        model.sunday = workingDaysConfig.isSunday();
        return model;
    }

    private List<NonWorkingDayModel> getNonWorkingDaysModels(WorkingDaysConfig workingDaysConfig) {
        Set<LocalDate> nonWorkingDays = workingDaysConfig.getNonWorkingLocalDates();
        ArrayList<NonWorkingDayModel> daysOff = new ArrayList<NonWorkingDayModel>();
        for (LocalDate date : nonWorkingDays) {
            daysOff.add(NonWorkingDayModel.fromLocalDate(date));
        }
        return daysOff;
    }

    public TimeZoneEditModel buildTimeZoneEditModel(ApplicationUser user, WorkingDaysConfig workingDaysConfig, boolean canEdit) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        TimeZoneEditModel model = new TimeZoneEditModel();
        model.currentTimeZoneId = workingDaysConfig.getTimezoneId();
        JiraServiceContextImpl context = new JiraServiceContextImpl((ApplicationUser)null);
        List regionInfos = this.timeZoneService.getTimeZoneRegions((JiraServiceContext)context);
        model.regions = TimeZoneEditModel.fromRegionInfos(regionInfos);
        TimeZoneEditModel.Region defaultRegion = new TimeZoneEditModel.Region();
        defaultRegion.displayName = i18n.getText("admin.timezone.system.default");
        defaultRegion.key = DEFAULT_REGION_KEY;
        model.regions.add(0, defaultRegion);
        List timeZoneInfos = this.timeZoneService.getTimeZoneInfos((JiraServiceContext)context);
        model.timeZones = TimeZoneEditModel.toTimeZones(timeZoneInfos);
        TimeZoneInfo defaultTimeZoneInfo = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)context);
        TimeZoneEditModel.TimeZone defaultZone = TimeZoneEditModel.fromTimeZoneInfo(defaultTimeZoneInfo);
        defaultZone.timeZoneId = "defaultTimeZoneId";
        defaultZone.regionKey = DEFAULT_REGION_KEY;
        model.timeZones.add(0, defaultZone);
        if (!canEdit) {
            this.stripUnneededZonesAndRegions(model);
        }
        return model;
    }

    private void stripUnneededZonesAndRegions(TimeZoneEditModel model) {
        Iterator<TimeZoneEditModel.TimeZone> timeZones = model.timeZones.iterator();
        TimeZoneEditModel.TimeZone currentZone = null;
        while (timeZones.hasNext()) {
            TimeZoneEditModel.TimeZone info = timeZones.next();
            if (!info.timeZoneId.equals(model.currentTimeZoneId)) {
                timeZones.remove();
                continue;
            }
            currentZone = info;
        }
        if (currentZone != null) {
            Iterator<TimeZoneEditModel.Region> regions = model.regions.iterator();
            while (regions.hasNext()) {
                TimeZoneEditModel.Region region = regions.next();
                if (region.key.equals(currentZone.regionKey)) continue;
                regions.remove();
            }
        }
    }

    public ServiceOutcome<WorkingDaysConfig> updateTimeZone(ApplicationUser user, Long rapidViewId, String timeZoneId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        DateTimeZone dateTimeZone = null;
        if (!"defaultTimeZoneId".equals(timeZoneId) && (dateTimeZone = DateTimeZone.forID((String)timeZoneId)) == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.config.timezone.invalid", timeZoneId);
        }
        ServiceOutcome<WorkingDaysConfig> configuration = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView.getValue());
        if (!configuration.isValid()) {
            return ServiceOutcomeImpl.error(configuration);
        }
        WorkingDaysConfig updatedConfig = WorkingDaysConfig.builder(configuration.getValue()).timezoneId(timeZoneId).build();
        return this.workingDaysService.updateWorkingDaysConfiguration(user, rapidView.getValue(), updatedConfig);
    }

    public ServiceOutcome<WeekDaysModel> updateWeekDays(ApplicationUser user, WeekDaysModel weekDaysModel) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, weekDaysModel.rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        ServiceOutcome<WorkingDaysConfig> currentWorkingDaysConfig = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView.getValue());
        if (!currentWorkingDaysConfig.isValid()) {
            return ServiceOutcomeImpl.error(currentWorkingDaysConfig);
        }
        WorkingDaysConfig updatedConfig = WorkingDaysConfig.builder(currentWorkingDaysConfig.getValue()).monday(weekDaysModel.monday).tuesday(weekDaysModel.tuesday).wednesday(weekDaysModel.wednesday).thursday(weekDaysModel.thursday).friday(weekDaysModel.friday).saturday(weekDaysModel.saturday).sunday(weekDaysModel.sunday).build();
        ServiceOutcome<WorkingDaysConfig> outcome = this.workingDaysService.updateWorkingDaysConfiguration(user, rapidView.getValue(), updatedConfig);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(this.buildWeekDaysModel(rapidView.getValue(), outcome.getValue()));
    }

    public ServiceOutcome<WorkingDaysConfig> addNonWorkingDay(ApplicationUser user, WorkingDaysResource.NonWorkingDayRequest nonWorkingDayRequest) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, nonWorkingDayRequest.rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        ServiceOutcome<LocalDate> day = this.getLocalDate(nonWorkingDayRequest);
        if (!day.isValid()) {
            return ServiceOutcomeImpl.error(day);
        }
        return this.workingDaysService.addNonWorkingDay(user, rapidView.getValue(), day.getValue());
    }

    public ServiceOutcome<WorkingDaysConfig> removeNonWorkingDay(ApplicationUser user, WorkingDaysResource.NonWorkingDayRequest nonWorkingDayRequest) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, nonWorkingDayRequest.rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        ServiceOutcome<LocalDate> day = this.getLocalDate(nonWorkingDayRequest);
        if (!day.isValid()) {
            return ServiceOutcomeImpl.error(day);
        }
        return this.workingDaysService.removeNonWorkingDay(user, rapidView.getValue(), day.getValue());
    }

    private ServiceOutcome<LocalDate> getLocalDate(WorkingDaysResource.NonWorkingDayRequest nonWorkingDayRequest) {
        if (nonWorkingDayRequest.iso8601Date == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.config.nonworkingdays.isodate.required", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(LocalDate.parse((String)nonWorkingDayRequest.iso8601Date));
    }
}

