/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.workingdays;

import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.TimeZoneInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TimeZoneEditModel
extends RestTemplate {
    @XmlElement
    public String currentTimeZoneId;
    @XmlElement
    public List<Region> regions;
    @XmlElement
    public List<TimeZone> timeZones;

    public static List<Region> fromRegionInfos(List<RegionInfo> regions) {
        ArrayList<Region> result = new ArrayList<Region>();
        for (RegionInfo info : regions) {
            Region region = TimeZoneEditModel.fromRegionInfo(info);
            result.add(region);
        }
        return result;
    }

    private static Region fromRegionInfo(RegionInfo info) {
        Region region = new Region();
        region.key = info.getKey();
        region.displayName = info.getDisplayName();
        return region;
    }

    public static List<TimeZone> toTimeZones(List<TimeZoneInfo> timeZoneInfos) {
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
        for (TimeZoneInfo info : timeZoneInfos) {
            TimeZone zone = TimeZoneEditModel.fromTimeZoneInfo(info);
            zones.add(zone);
        }
        return zones;
    }

    public static TimeZone fromTimeZoneInfo(TimeZoneInfo info) {
        TimeZone zone = new TimeZone();
        zone.city = info.getCity();
        zone.displayName = info.getDisplayName();
        zone.gMTOffset = info.getGMTOffset();
        zone.regionKey = info.getRegionKey();
        zone.timeZoneId = info.getTimeZoneId();
        return zone;
    }

    @XmlRootElement
    public static class TimeZone {
        @XmlElement
        public String timeZoneId;
        @XmlElement
        public String displayName;
        @XmlElement
        public String gMTOffset;
        @XmlElement
        public String city;
        @XmlElement
        public String regionKey;
    }

    @XmlRootElement
    public static class Region
    extends RestTemplate {
        @XmlElement
        public String key;
        @XmlElement
        public String displayName;
    }
}

