/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.detailview;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueeditor.action.BaseEditAction;
import com.atlassian.jira.components.issueviewer.viewissue.IssueFieldProvider;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webwork.action.Action;

@Component
public class DetailViewInlineEditableFieldFactory {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final Map<String, Object> DISPLAY_PARAMS = ImmutableMap.of((Object)"noHeader", (Object)"true", (Object)"theme", (Object)"aui", (Object)"isFirstField", (Object)true, (Object)"isLastField", (Object)true);
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final List<String> ALWAYS_CONFIGURED_FIELDS = ImmutableList.of((Object)"description");
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final List<String> ALWAYS_CONFIGURED_AND_EDITABLE_FIELDS = ImmutableList.of((Object)"summary");
    @Autowired
    private DetailViewFieldService fieldService;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private IssueHelper issueHelper;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private StatisticFieldHelper statisticFieldHelper;
    @Autowired
    private IssueService issueService;
    @Autowired
    private FieldHtmlFactory fieldHtmlFactory;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private ApplicationProperties applicationProperties;

    public ServiceOutcome<List<FieldHtmlBean>> getInlineEditableFields(long rapidViewId, long issueId, ApplicationUser loggedInUser, StatisticsField estimateField, StatisticsField timeTrackingEstimateField) {
        return this.getInlineEditableFields(rapidViewId, issueId, loggedInUser, estimateField, timeTrackingEstimateField, new DoNothingEditAction(this.issueService, new IssueFieldProvider(this.fieldHtmlFactory)));
    }

    public ServiceOutcome<List<FieldHtmlBean>> getInlineEditableFields(long rapidViewId, long issueId, ApplicationUser loggedInUser, StatisticsField estimateField, StatisticsField timeTrackingEstimateField, BaseEditAction dummyAction) {
        ServiceOutcome<DataBucket> dataBucketServiceOutcome = this.getData(rapidViewId, issueId, loggedInUser);
        if (dataBucketServiceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.from(dataBucketServiceOutcome.getErrors());
        }
        DataBucket bucket = dataBucketServiceOutcome.get();
        if (bucket.hasAnyNull()) {
            return ServiceOutcomeImpl.ok(Collections.emptyList());
        }
        Issue issue = bucket.issue;
        RapidView rapidView = bucket.rapidView;
        List<? extends Field> detailViewFields = bucket.detailViewFields;
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        List<FieldHtmlBean> fieldsEditableInDetailView = this.getDetailViewEditableFields(dummyAction, issue, fieldLayout, detailViewFields);
        fieldsEditableInDetailView.addAll(this.toFieldHtml(ALWAYS_CONFIGURED_FIELDS, dummyAction, issue, fieldLayout));
        Set<String> fieldsEditableInJira = this.getJiraEditableFields(loggedInUser, issue, dummyAction);
        fieldsEditableInDetailView.removeIf(fieldHtmlBean -> !fieldsEditableInJira.contains(fieldHtmlBean.getId()));
        fieldsEditableInDetailView.addAll(this.toFieldHtml(ALWAYS_CONFIGURED_AND_EDITABLE_FIELDS, dummyAction, issue, fieldLayout));
        Optional<FieldHtmlBean> estimateStatistic = this.getEstimateField(estimateField, fieldLayout, issue, rapidView, dummyAction);
        estimateStatistic.ifPresent(fieldsEditableInDetailView::add);
        Optional<FieldHtmlBean> remainingStatistic = this.getRemainingEstimateField(timeTrackingEstimateField, fieldLayout, issue, dummyAction);
        remainingStatistic.ifPresent(fieldsEditableInDetailView::add);
        return ServiceOutcomeImpl.ok(fieldsEditableInDetailView);
    }

    private List<FieldHtmlBean> toFieldHtml(List<String> fieldIds, BaseEditAction action, Issue issue, FieldLayout fieldLayout) {
        return fieldIds.stream().map(fieldId -> this.getFieldHtmlBean((String)fieldId, fieldLayout, issue, action)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<FieldHtmlBean> getDetailViewEditableFields(BaseEditAction action, Issue issue, FieldLayout fieldLayout, List<? extends Field> detailViewFields) {
        return detailViewFields.stream().map(field -> this.getFieldHtmlBean(field.getId(), fieldLayout, issue, action)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Set<String> getJiraEditableFields(ApplicationUser loggedInUser, Issue issue, BaseEditAction action) {
        if (this.applicationProperties.getOption("jira.issue.inline.edit.disabled")) {
            return Collections.emptySet();
        }
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, new HashMap());
        return this.fieldHtmlFactory.getEditFields(loggedInUser, (OperationContext)operationContext, (Action)action, issue, false).stream().map(field -> field.getId()).collect(Collectors.toSet());
    }

    private ServiceOutcome<DataBucket> getData(long rapidViewId, long issueId, ApplicationUser loggedInUser) {
        DataBucket bucket = new DataBucket();
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(loggedInUser, rapidViewId);
        if (rapidView.isInvalid()) {
            return ServiceOutcomeImpl.from(rapidView.getErrors());
        }
        bucket.rapidView = rapidView.get();
        ServiceOutcome<Issue> issue = this.issueHelper.findIssue(issueId);
        if (issue.isInvalid()) {
            return ServiceOutcomeImpl.from(issue.getErrors());
        }
        bucket.issue = issue.get();
        ServiceOutcome<List<? extends Field>> detailViewFields = this.fieldService.getDetailViewFields(rapidView.get());
        if (detailViewFields.isInvalid()) {
            return ServiceOutcomeImpl.from(detailViewFields.getErrors());
        }
        bucket.detailViewFields = detailViewFields.get();
        return ServiceOutcomeImpl.ok(bucket);
    }

    private Optional<FieldHtmlBean> getEstimateField(StatisticsField estimateStatistic, FieldLayout fieldLayout, Issue issue, RapidView rapidView, BaseEditAction action) {
        String primaryStatisticFieldId = this.statisticFieldHelper.getEstimateStatisticFieldId(estimateStatistic, issue);
        if (primaryStatisticFieldId != null) {
            if ("timeoriginalestimate".equals(primaryStatisticFieldId)) {
                Optional<FieldHtmlBean> timeTrackingSystemField = this.getFieldHtmlBean("timetracking", fieldLayout, issue, action);
                if (timeTrackingSystemField.isPresent()) {
                    return Optional.of(new FieldHtmlBean("timeoriginalestimate", timeTrackingSystemField.get().getLabel(), true, timeTrackingSystemField.get().getEditHtml(), null));
                }
            } else {
                return this.getFieldHtmlBean(primaryStatisticFieldId, fieldLayout, issue, action);
            }
        }
        return Optional.empty();
    }

    private boolean remainingEstimateIsInlineEditable(StatisticsField remainingEstimateField, Issue issue) {
        return this.trackingStatisticService.isTrackingStatisticValidAndEnabled(remainingEstimateField) && this.trackingStatisticService.isTrackingStatisticFieldAndApplicable(remainingEstimateField, issue);
    }

    private Optional<FieldHtmlBean> getRemainingEstimateField(StatisticsField remainingEstimateField, FieldLayout fieldLayout, Issue issue, BaseEditAction action) {
        Optional<FieldHtmlBean> timeTrackingSystemField;
        if (this.remainingEstimateIsInlineEditable(remainingEstimateField, issue) && (timeTrackingSystemField = this.getFieldHtmlBean("timetracking", fieldLayout, issue, action)).isPresent()) {
            return Optional.of(new FieldHtmlBean("timeestimate", timeTrackingSystemField.get().getLabel(), true, timeTrackingSystemField.get().getEditHtml(), null));
        }
        return Optional.empty();
    }

    private Optional<FieldHtmlBean> getFieldHtmlBean(String fieldId, FieldLayout fieldLayout, Issue issue, BaseEditAction action) {
        OrderableField orderableField = this.getOrderableField(fieldId);
        if (orderableField != null) {
            if (!action.getFieldValuesHolder().containsKey(orderableField.getId())) {
                orderableField.populateFromIssue(action.getFieldValuesHolder(), issue);
            }
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField.getId());
            String editHtml = orderableField.getEditHtml(fieldLayoutItem, (OperationContext)action, (Action)action, issue, DISPLAY_PARAMS);
            return Optional.of(new FieldHtmlBean(orderableField.getId(), orderableField.getNameKey(), true, editHtml, null));
        }
        return Optional.empty();
    }

    private OrderableField getOrderableField(String fieldId) {
        return this.fieldManager.getOrderableField(fieldId);
    }

    private static class DoNothingEditAction
    extends BaseEditAction {
        public DoNothingEditAction(IssueService issueService, IssueFieldProvider issueFieldProvider) {
            super(issueService, issueFieldProvider);
        }
    }

    private static class DataBucket {
        RapidView rapidView;
        Issue issue;
        List<? extends Field> detailViewFields;

        private DataBucket() {
        }

        boolean hasAnyNull() {
            return this.rapidView == null || this.issue == null || this.detailViewFields == null;
        }
    }
}

