/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.detailview;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldConfigModel;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="detailviewfield/{rapidViewId}")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DetailViewFieldResource
extends AbstractResource {
    private DetailViewFieldHelper detailViewFieldHelper;
    private DetailViewFieldConfigurationService detailViewFieldConfigurationService;
    private RapidViewService rapidViewService;
    private EstimateStatisticService estimateStatisticService;
    private I18nFactoryService i18nFactoryService;

    public DetailViewFieldResource(DetailViewFieldHelper detailViewFieldHelper, DetailViewFieldConfigurationService detailViewFieldConfigurationService, RapidViewService rapidViewService, EstimateStatisticService estimateStatisticService, I18nFactoryService i18nFactoryService) {
        this.detailViewFieldHelper = detailViewFieldHelper;
        this.detailViewFieldConfigurationService = detailViewFieldConfigurationService;
        this.rapidViewService = rapidViewService;
        this.estimateStatisticService = estimateStatisticService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @GET
    @Path(value="available")
    public Response getAvailableDetailViewFields(final @PathParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = DetailViewFieldResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = DetailViewFieldResource.this.rapidViewService.getRapidView(user, rapidViewId);
                DetailViewFieldResource.this.check(rapidView);
                ServiceOutcome<AvailableFields> result = DetailViewFieldResource.this.detailViewFieldHelper.getAvailableDetailViewFields(user, rapidView.getValue());
                DetailViewFieldResource.this.check(result);
                AvailableFields fields = result.getValue();
                return DetailViewFieldResource.this.createOkResponse(fields);
            }
        });
    }

    @GET
    @Path(value="configured")
    public Response getConfiguredDetailViewFields(final @PathParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = DetailViewFieldResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = DetailViewFieldResource.this.rapidViewService.getRapidView(user, rapidViewId);
                DetailViewFieldResource.this.check(rapidView);
                ServiceOutcome<DetailViewFieldConfigModel> detailViewFieldConfig = DetailViewFieldResource.this.detailViewFieldHelper.getDetailViewFieldConfig(user, rapidView.getValue());
                DetailViewFieldConfigModel config = DetailViewFieldResource.this.check(detailViewFieldConfig);
                return DetailViewFieldResource.this.createOkResponse(config);
            }
        });
    }

    @POST
    @Path(value="field")
    public Response addDetailViewField(final @PathParam(value="rapidViewId") Long rapidViewId, final AddDetailFieldRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = DetailViewFieldResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = DetailViewFieldResource.this.rapidViewService.getRapidView(user, rapidViewId);
                DetailViewFieldResource.this.check(rapidView);
                DetailViewField newField = DetailViewField.builder().fieldId(request.fieldId).build();
                ServiceOutcome<List<DetailViewFieldConfig>> update = DetailViewFieldResource.this.detailViewFieldConfigurationService.add(user, rapidView.getValue(), newField);
                DetailViewFieldResource.this.check(update);
                DetailViewFieldConfig detailViewFieldConfig = update.getValue().get(0);
                StatisticsField estimateStatistic = DetailViewFieldResource.this.estimateStatisticService.getEstimateStatistic(rapidView.getValue());
                DetailViewFieldConfigModel.DetailViewFieldEntry entry = DetailViewFieldResource.this.detailViewFieldHelper.createEntry(DetailViewFieldResource.this.i18nFactoryService.getI18n(user), detailViewFieldConfig, estimateStatistic);
                return DetailViewFieldResource.this.createOkResponse(entry);
            }
        });
    }

    @DELETE
    @Path(value="field/{detailViewFieldId}")
    public Response deleteDetailViewField(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="detailViewFieldId") Long detailViewFieldId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = DetailViewFieldResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = DetailViewFieldResource.this.rapidViewService.getRapidView(user, rapidViewId);
                DetailViewFieldResource.this.check(rapidView);
                ServiceOutcome<Void> outcome = DetailViewFieldResource.this.detailViewFieldConfigurationService.delete(DetailViewFieldResource.this.getUser(), rapidView.getValue(), detailViewFieldId);
                DetailViewFieldResource.this.check(outcome);
                return DetailViewFieldResource.this.createNoContentResponse();
            }
        });
    }

    @POST
    @Path(value="field/{detailViewFieldId}/move")
    public Response moveDetailViewField(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="detailViewFieldId") Long detailViewFieldId, final EntryMoveModel moveModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = DetailViewFieldResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = DetailViewFieldResource.this.rapidViewService.getRapidView(user, rapidViewId);
                DetailViewFieldResource.this.check(rapidView);
                ServiceOutcome<Void> moveOutcome = DetailViewFieldResource.this.detailViewFieldConfigurationService.moveAfter(user, rapidView.getValue(), detailViewFieldId, moveModel.getMoveToId());
                DetailViewFieldResource.this.check(moveOutcome);
                return DetailViewFieldResource.this.createNoContentResponse();
            }
        });
    }

    @XmlRootElement
    static class AvailableFields
    extends RestTemplate {
        @XmlElement
        public List<DetailViewFieldConfigModel.DetailViewFieldEntry> fields = new ArrayList<DetailViewFieldConfigModel.DetailViewFieldEntry>();

        AvailableFields() {
        }
    }

    static class AddDetailFieldRequest {
        public String fieldId;

        AddDetailFieldRequest() {
        }
    }
}

