/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.detailview;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailTypeChecker;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailsCategory;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldConfigModel;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldResource;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailViewFieldHelper {
    @Autowired
    private DetailViewFieldConfigurationService detailViewFieldConfigurationService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;

    public ServiceOutcome<DetailViewFieldConfigModel> getDetailViewFieldConfig(ApplicationUser user, RapidView rapidView) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        DetailViewFieldConfigModel model = new DetailViewFieldConfigModel();
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        ServiceOutcome<List<DetailViewFieldConfig>> detailViewFields = this.detailViewFieldConfigurationService.getDetailViewFields(rapidView);
        if (!detailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(detailViewFields);
        }
        model.currentFields = new ArrayList<DetailViewFieldConfigModel.DetailViewFieldEntry>();
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        for (DetailViewFieldConfig detailViewFieldConfig : detailViewFields.getValue()) {
            DetailViewFieldConfigModel.DetailViewFieldEntry entry = this.createEntry(i18n, detailViewFieldConfig, estimateStatistic);
            model.currentFields.add(entry);
        }
        ServiceOutcome<DetailViewFieldResource.AvailableFields> availableDetailViewFields = this.getAvailableDetailViewFields(user, rapidView);
        if (!availableDetailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(availableDetailViewFields);
        }
        model.availableFields = availableDetailViewFields.getValue().fields;
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<DetailViewFieldResource.AvailableFields> getAvailableDetailViewFields(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<List<? extends Field>> availableDetailViewFields = this.detailViewFieldConfigurationService.getAvailableDetailViewFields(rapidView);
        if (!availableDetailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(availableDetailViewFields);
        }
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        DetailViewFieldResource.AvailableFields result = new DetailViewFieldResource.AvailableFields();
        for (Field field : availableDetailViewFields.getValue()) {
            DetailViewFieldConfigModel.DetailViewFieldEntry entry = this.createEntry(this.i18nFactoryService.getI18n(user), field, estimateStatistic);
            result.fields.add(entry);
        }
        Collections.sort(result.fields);
        return ServiceOutcomeImpl.ok(result);
    }

    public DetailViewFieldConfigModel.DetailViewFieldEntry createEntry(I18n2 i18n, DetailViewFieldConfig detailViewFieldConfig, StatisticsField estimateStatistic) {
        DetailViewFieldConfigModel.DetailViewFieldEntry entry;
        if (detailViewFieldConfig.isValid()) {
            Field field = detailViewFieldConfig.getJiraField();
            entry = this.createEntry(i18n, field, estimateStatistic);
        } else {
            entry = this.createInvalidEntry(i18n, detailViewFieldConfig.getDetailViewField());
        }
        entry.id = detailViewFieldConfig.getDetailViewField().getId();
        return entry;
    }

    private DetailViewFieldConfigModel.DetailViewFieldEntry createInvalidEntry(I18n2 i18n, DetailViewField field) {
        DetailViewFieldConfigModel.DetailViewFieldEntry entry = new DetailViewFieldConfigModel.DetailViewFieldEntry();
        entry.id = field.getId();
        entry.fieldId = field.getFieldId();
        entry.name = i18n.getText("gh.rapid.config.detailview.warning.invalid.field", (Object)field.getFieldId());
        entry.isValid = false;
        entry.category = FieldDetailsCategory.DETAILS.getKey();
        entry.isEstimationField = false;
        return entry;
    }

    private boolean isEstimationField(StatisticsField estimateStatistic, Field field) {
        return estimateStatistic.isValid() && estimateStatistic.getField() != null && estimateStatistic.getField().getId().equals(field.getId());
    }

    public DetailViewFieldConfigModel.DetailViewFieldEntry createEntry(I18n2 i18n, Field field, StatisticsField estimateStatistic) {
        FieldDetailsCategory fieldCategory = this.getDetailViewFieldCategory(field);
        DetailViewFieldConfigModel.DetailViewFieldEntry entry = new DetailViewFieldConfigModel.DetailViewFieldEntry();
        entry.fieldId = field.getId();
        entry.isValid = true;
        entry.name = this.getFieldName(i18n, field);
        entry.category = fieldCategory.getKey();
        entry.isEstimationField = this.isEstimationField(estimateStatistic, field);
        return entry;
    }

    private String getFieldName(I18n2 i18n, Field field) {
        if (field instanceof CustomField && ((CustomField)field).getCustomFieldType() instanceof EpicLinkCFType) {
            CustomField epicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
            if (field.getId().equals(epicLinkField.getId())) {
                return this.issueTypeService.getOrCreateEpicIssueType().getNameTranslation();
            }
        }
        return i18n.getText(field.getNameKey());
    }

    public List<? extends Field> filterVisibleFieldsByCategory(List<? extends Field> visibleFields, FieldDetailsCategory desiredCategory) {
        return visibleFields.stream().filter(field -> this.isInCategory((Field)field, desiredCategory)).collect(Collectors.toList());
    }

    public boolean isInCategory(Field field, FieldDetailsCategory category) {
        if (category.equals((Object)FieldDetailsCategory.UNSUPPORTED)) {
            return false;
        }
        return category.equals((Object)this.getDetailViewFieldCategory(field));
    }

    private FieldDetailsCategory getDetailViewFieldCategory(Field field) {
        if (field instanceof CustomField) {
            CustomFieldType fieldType = ((CustomField)field).getCustomFieldType();
            return FieldDetailTypeChecker.getTypeFor((CustomFieldType)fieldType).category;
        }
        return FieldDetailTypeChecker.getTypeFor((Field)field).category;
    }
}

