/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.cardlayout;

import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfigurationService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutFields;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="cardlayout/{rapidViewId}/{mode}")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CardLayoutResource
extends AbstractResource {
    private CardLayoutHelper cardLayoutHelper;
    private CardLayoutFieldConfigurationService cardLayoutFieldConfigurationService;
    private RapidViewService rapidViewService;
    private I18nFactoryService i18nFactoryService;

    public CardLayoutResource(CardLayoutHelper cardLayoutHelper, CardLayoutFieldConfigurationService cardLayoutFieldConfigurationService, RapidViewService rapidViewService, I18nFactoryService i18nFactoryService) {
        this.cardLayoutHelper = cardLayoutHelper;
        this.cardLayoutFieldConfigurationService = cardLayoutFieldConfigurationService;
        this.rapidViewService = rapidViewService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @GET
    @Path(value="available")
    public Response getAvailableCardLayoutFields(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="mode") String modeName) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CardLayoutResource.this.getUser();
                RapidView rapidView = CardLayoutResource.this.check(CardLayoutResource.this.rapidViewService.getRapidView(user, rapidViewId));
                CardLayoutField.Mode mode = CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutHelper.getModeFromModeName(modeName));
                return CardLayoutResource.this.createOkResponse(CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutHelper.getAvailableCardLayoutFields(user, rapidView, mode)));
            }
        });
    }

    @POST
    @Path(value="field")
    public Response addCardLayoutField(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="mode") String modeName, final AddCardLayoutFieldRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CardLayoutResource.this.getUser();
                RapidView rapidView = CardLayoutResource.this.check(CardLayoutResource.this.rapidViewService.getRapidView(user, rapidViewId));
                CardLayoutField.Mode mode = CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutHelper.getModeFromModeName(modeName));
                CardLayoutField newField = CardLayoutField.builder().fieldId(request.fieldId).mode(mode).build();
                CardLayoutFieldConfig cardLayoutFieldConfig = CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutFieldConfigurationService.add(user, rapidView, newField));
                return CardLayoutResource.this.createOkResponse(CardLayoutResource.this.cardLayoutHelper.createEntry(CardLayoutResource.this.i18nFactoryService.getI18n(user), cardLayoutFieldConfig));
            }
        });
    }

    @GET
    @Path(value="field")
    public Response getCardLayoutFields(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="mode") String modeName) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CardLayoutResource.this.getUser();
                RapidView rapidView = CardLayoutResource.this.check(CardLayoutResource.this.rapidViewService.getRapidView(user, rapidViewId));
                CardLayoutField.Mode mode = CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutHelper.getModeFromModeName(modeName));
                CardLayoutFields model = CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutHelper.getConfiguredCardLayoutFieldsForMode(user, rapidView, mode));
                return CardLayoutResource.this.createOkResponse(model);
            }
        });
    }

    @DELETE
    @Path(value="field/{cardLayoutFieldId}")
    public Response deleteCardLayoutField(final @PathParam(value="rapidViewId") Long rapidViewId, @PathParam(value="mode") String modeName, final @PathParam(value="cardLayoutFieldId") Long cardLayoutFieldId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CardLayoutResource.this.getUser();
                RapidView rapidView = CardLayoutResource.this.check(CardLayoutResource.this.rapidViewService.getRapidView(user, rapidViewId));
                CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutFieldConfigurationService.delete(user, rapidView, cardLayoutFieldId));
                return CardLayoutResource.this.createNoContentResponse();
            }
        });
    }

    @POST
    @Path(value="field/{cardLayoutFieldId}/move")
    public Response moveCardLayoutField(final @PathParam(value="rapidViewId") Long rapidViewId, @PathParam(value="mode") String modeName, final @PathParam(value="cardLayoutFieldId") Long cardLayoutFieldId, final EntryMoveModel moveModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CardLayoutResource.this.getUser();
                RapidView rapidView = CardLayoutResource.this.check(CardLayoutResource.this.rapidViewService.getRapidView(user, rapidViewId));
                CardLayoutResource.this.check(CardLayoutResource.this.cardLayoutFieldConfigurationService.moveAfter(user, rapidView, cardLayoutFieldId, moveModel.getOptionalMoveToId()));
                return CardLayoutResource.this.createNoContentResponse();
            }
        });
    }

    static class AddCardLayoutFieldRequest {
        public String fieldId;

        AddCardLayoutFieldRequest() {
        }
    }
}

