/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view.cardlayout;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldConfigurationService;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutFieldConfigModel;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutFieldEntry;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutFields;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutHelper {
    @Autowired
    private CardLayoutFieldConfigurationService cardLayoutFieldConfigurationService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;

    public ServiceOutcome<CardLayoutFieldConfigModel> getCardLayoutFieldConfig(ApplicationUser user, RapidView rapidView) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        CardLayoutFieldConfigModel model = new CardLayoutFieldConfigModel();
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        ServiceOutcome<List<CardLayoutFieldConfig>> cardLayoutFields = this.cardLayoutFieldConfigurationService.getCardLayoutFields(rapidView);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        model.currentFields = this.getCurrentConfiguredFields(cardLayoutFields.getValue(), i18n);
        model.availableFields = new ArrayList<CardLayoutFieldEntry>();
        for (CardLayoutField.Mode mode : CardLayoutField.Mode.values()) {
            ServiceOutcome<List<CardLayoutFieldEntry>> availableCardLayoutFields = this.getAvailableCardLayoutFieldEntryList(user, rapidView, mode);
            if (!availableCardLayoutFields.isValid()) {
                return ServiceOutcomeImpl.error(availableCardLayoutFields);
            }
            model.availableFields.addAll((Collection<CardLayoutFieldEntry>)availableCardLayoutFields.getValue());
        }
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<CardLayoutFields> getConfiguredCardLayoutFieldsForMode(ApplicationUser user, RapidView rapidView, CardLayoutField.Mode mode) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        CardLayoutFields model = new CardLayoutFields();
        ServiceOutcome<List<CardLayoutFieldConfig>> cardLayoutFields = this.cardLayoutFieldConfigurationService.getCardLayoutFields(rapidView, mode);
        if (!cardLayoutFields.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFields);
        }
        model.fields = this.getCurrentConfiguredFields(cardLayoutFields.getValue(), i18n);
        return ServiceOutcomeImpl.ok(model);
    }

    private List<CardLayoutFieldEntry> getCurrentConfiguredFields(List<CardLayoutFieldConfig> cardLayoutFields, final I18n2 i18n) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(cardLayoutFields, (Function)new Function<CardLayoutFieldConfig, CardLayoutFieldEntry>(){

            public CardLayoutFieldEntry apply(CardLayoutFieldConfig fieldConfig) {
                return CardLayoutHelper.this.createEntry(i18n, fieldConfig);
            }
        }));
    }

    public ServiceOutcome<CardLayoutFields> getAvailableCardLayoutFields(ApplicationUser user, RapidView rapidView, CardLayoutField.Mode mode) {
        ServiceOutcome<List<CardLayoutFieldEntry>> availableCardLayoutFieldsResult = this.getAvailableCardLayoutFieldEntryList(user, rapidView, mode);
        if (!availableCardLayoutFieldsResult.isValid()) {
            return ServiceOutcomeImpl.error(availableCardLayoutFieldsResult);
        }
        CardLayoutFields cardLayoutAvailableFields = new CardLayoutFields();
        cardLayoutAvailableFields.fields = availableCardLayoutFieldsResult.getValue();
        return ServiceOutcomeImpl.ok(cardLayoutAvailableFields);
    }

    public ServiceOutcome<List<CardLayoutFieldEntry>> getAvailableCardLayoutFieldEntryList(ApplicationUser user, RapidView rapidView, CardLayoutField.Mode mode) {
        ServiceOutcome<Set<Field>> availableFieldsResult = this.cardLayoutFieldConfigurationService.getAvailableCardLayoutFields(user, rapidView, mode);
        if (!availableFieldsResult.isValid()) {
            return ServiceOutcomeImpl.error(availableFieldsResult);
        }
        ArrayList<CardLayoutFieldEntry> availableCardLayoutFields = new ArrayList<CardLayoutFieldEntry>();
        for (Field field : availableFieldsResult.getValue()) {
            availableCardLayoutFields.add(this.createEntry(this.i18nFactoryService.getI18n(user), field, mode));
        }
        Collections.sort(availableCardLayoutFields);
        return ServiceOutcomeImpl.ok(availableCardLayoutFields);
    }

    public CardLayoutFieldEntry createEntry(I18n2 i18n, CardLayoutFieldConfig cardLayoutFieldConfig) {
        CardLayoutFieldEntry entry;
        if (cardLayoutFieldConfig.isValid()) {
            NavigableField field = cardLayoutFieldConfig.getJiraField();
            entry = this.createEntry(i18n, (Field)field, cardLayoutFieldConfig.getCardLayoutField().getMode());
        } else {
            entry = this.createInvalidEntry(i18n, cardLayoutFieldConfig.getCardLayoutField(), cardLayoutFieldConfig.getCardLayoutField().getMode());
        }
        entry.id = cardLayoutFieldConfig.getCardLayoutField().getId();
        return entry;
    }

    public ServiceOutcome<CardLayoutField.Mode> getModeFromModeName(String modeName) {
        CardLayoutField.Mode mode = CardLayoutField.Mode.fromModeName(modeName);
        if (mode == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.cardlayout.error.invalid.mode", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(mode);
    }

    private CardLayoutFieldEntry createInvalidEntry(I18n2 i18n, CardLayoutField field, CardLayoutField.Mode mode) {
        CardLayoutFieldEntry entry = new CardLayoutFieldEntry();
        entry.id = field.getId();
        entry.fieldId = field.getFieldId();
        entry.name = i18n.getText("gh.rapid.config.cardlayout.warning.invalid.field", (Object)field.getFieldId());
        entry.isValid = false;
        entry.mode = mode.getModeName();
        return entry;
    }

    public CardLayoutFieldEntry createEntry(I18n2 i18n, Field field, CardLayoutField.Mode mode) {
        CardLayoutFieldEntry entry = new CardLayoutFieldEntry();
        entry.fieldId = field.getId();
        entry.isValid = true;
        entry.name = i18n.getText(field.getNameKey());
        entry.mode = mode.getModeName();
        return entry;
    }
}

