/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditHelper;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditRequest;
import com.atlassian.greenhopper.web.rapid.workflow.WorkflowHelper;
import com.atlassian.greenhopper.workflow.WorkflowMigrationException;
import com.atlassian.greenhopper.workflow.WorkflowMigrationService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@Path(value="workflow")
@Produces(value={"application/json"})
public class WorkflowResource
extends AbstractResource {
    private static final String STATUS_NAME_CONTEXT_ID = "name";
    private RapidViewService rapidViewService;
    private WorkflowService workflowService;
    private ProjectService jiraProjectService;
    private WorkflowHelper workflowHelper;
    private PermissionService permissionService;
    private SearchService searchService;
    private IssueManager jiraIssueManager;
    private I18nFactoryService i18nFactoryService;
    private SimplifiedWorkflowService simplifiedWorkflowService;
    private ColumnService columnService;
    private WorkflowMigrationService workflowMigrationService;
    private ColumnEditHelper columnEditHelper;
    private StatusEntryFactory statusEntryFactory;
    private WorkflowSchemeManager workflowSchemeManager;
    private final GlobalPermissionManager globalPermissionManager;

    public WorkflowResource(RapidViewService rapidViewService, WorkflowService workflowService, ProjectService jiraProjectService, WorkflowHelper workflowHelper, PermissionService permissionService, SearchService searchService, IssueManager jiraIssueManager, I18nFactoryService i18nFactoryService, SimplifiedWorkflowService simplifiedWorkflowService, ColumnService columnService, WorkflowMigrationService workflowMigrationService, ColumnEditHelper columnEditHelper, StatusEntryFactory statusEntryFactory, WorkflowSchemeManager workflowSchemeManager, GlobalPermissionManager globalPermissionManager) {
        this.rapidViewService = rapidViewService;
        this.workflowService = workflowService;
        this.jiraProjectService = jiraProjectService;
        this.workflowHelper = workflowHelper;
        this.permissionService = permissionService;
        this.searchService = searchService;
        this.jiraIssueManager = jiraIssueManager;
        this.i18nFactoryService = i18nFactoryService;
        this.simplifiedWorkflowService = simplifiedWorkflowService;
        this.columnService = columnService;
        this.workflowMigrationService = workflowMigrationService;
        this.columnEditHelper = columnEditHelper;
        this.statusEntryFactory = statusEntryFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    @GET
    @Path(value="/status/remove")
    public Response getRemoveStatusModel(@QueryParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="statusId") String statusId) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            if (StringUtils.isBlank((String)statusId)) {
                this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "You must specify a status ID", new Object[0]));
            }
            ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
            this.check(rapidView);
            ServiceOutcome<Pair<JiraWorkflow, Project>> ghSimplifiedWorkflow = this.workflowHelper.getGreenHopperSimplifiedWorkflow(user, rapidView.getValue());
            this.check(ghSimplifiedWorkflow);
            JiraWorkflow workflow = (JiraWorkflow)ghSimplifiedWorkflow.getValue().first();
            Project project = (Project)ghSimplifiedWorkflow.getValue().second();
            this.validateModifyWorkflow(user, project, "gh.rapid.config.workflow.remove.status.error.project.admin");
            ServiceOutcome<Status> statusOutcome = this.simplifiedWorkflowService.canStatusBeRemovedFromGreenHopperSimplifiedWorkflow(workflow, statusId);
            this.check(statusOutcome);
            Status status = statusOutcome.getValue();
            ServiceOutcome<Void> statusInUse = this.queryForStatus(user, project, status);
            this.check(statusInUse);
            ServiceOutcome<Boolean> initialStatus = this.workflowService.isStatusInitialStatus(workflow, status);
            this.check(initialStatus);
            Status newInitialStatus = null;
            if (initialStatus.getValue().booleanValue()) {
                List<Status> orderedStatuses = this.columnService.getOrderedStatuses(rapidView.getValue());
                if (orderedStatuses.isEmpty()) {
                    this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.remove.status.error.no.mapped.statuses", status.getNameTranslation()));
                } else {
                    newInitialStatus = orderedStatuses.get(0);
                }
            }
            RemoveStatusModel model = new RemoveStatusModel();
            model.statusId = statusId;
            model.statusName = status.getNameTranslation();
            model.workflowName = workflow.getName();
            model.projectName = project.getName();
            model.isInitialStatus = initialStatus.getValue();
            if (newInitialStatus != null) {
                model.newInitialStatusId = newInitialStatus.getId();
                model.newInitialStatusName = newInitialStatus.getNameTranslation();
            }
            return this.createOkResponse(model);
        });
    }

    @POST
    @Path(value="/status/resolution")
    public Response updateResolution(UpdateResolutionRequest request) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, request.rapidViewId));
            Status status = this.check(this.workflowHelper.getStatusById(request.statusId));
            Pair<JiraWorkflow, Project> simplifiedWorkflow = this.check(this.workflowHelper.getGreenHopperSimplifiedWorkflow(user, rapidView));
            JiraWorkflow workflow = (JiraWorkflow)simplifiedWorkflow.first();
            this.hasAccessToBoardConfiguration(user, (Project)simplifiedWorkflow.second(), "gh.rapid.config.workflow.status.error.noview");
            this.check(this.simplifiedWorkflowService.setStatusResolutionDone(user, workflow, status, request.done));
            return this.createNoContentResponse();
        });
    }

    private void hasAccessToBoardConfiguration(ApplicationUser user, Project project, String errorMsgKey) {
        boolean isAdmin = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
        boolean isProjectAdmin = this.permissionService.isProjectAdministrator(user, Collections.singletonList(project));
        if (!isAdmin && !isProjectAdmin) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, errorMsgKey, new Object[0]));
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/status/remove")
    public Response removeStatus(RemoveStatusRequest removeStatusRequest) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            ServiceOutcome<JiraWorkflow> workflowOutcome = this.workflowHelper.getWorkflow(user, removeStatusRequest.workflowName);
            this.check(workflowOutcome);
            JiraWorkflow workflow = workflowOutcome.getValue();
            List projects = this.workflowSchemeManager.getSchemesForWorkflow(workflow).stream().flatMap(scheme -> this.workflowSchemeManager.getProjects(this.workflowSchemeManager.getSchemeObject(scheme.getLong("id"))).stream()).collect(Collectors.toList());
            if (projects.size() != 1) {
                this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.exactly.one.project", new Object[0]));
            }
            this.validateModifyWorkflow(user, (Project)projects.get(0), "gh.rapid.config.workflow.status.error.noview");
            ServiceOutcome<Status> statusOutcome = this.workflowHelper.getStatusById(removeStatusRequest.statusId);
            this.check(statusOutcome);
            Status status = statusOutcome.getValue();
            if (removeStatusRequest.isInitialStatus) {
                ServiceOutcome<Status> newInitialStatus = this.workflowHelper.getStatusById(removeStatusRequest.newInitialStatusId);
                this.check(newInitialStatus);
                ServiceOutcome<JiraWorkflow> replacement = this.simplifiedWorkflowService.replaceInitialStatusInGreenHopperSimplifiedWorkflow(user, workflow, status, newInitialStatus.getValue());
                this.check(replacement);
                workflow = replacement.getValue();
            }
            ServiceOutcome<Void> remove = this.simplifiedWorkflowService.removeStatusFromGreenHopperSimplifiedWorkflow(user, workflow, status);
            this.checkResult(remove);
            return this.createNoContentResponse();
        });
    }

    @GET
    @Path(value="/convert")
    public Response getConvertWorkflowModel(@QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
            Pair<JiraWorkflow, Project> ghSimplifiedWorkflow = this.check(this.workflowHelper.getPotentialWorkflowForConversion(user, rapidView));
            Project project = (Project)ghSimplifiedWorkflow.second();
            Scheme workflowScheme = this.check(this.workflowService.getWorkflowSchemeForProject(project));
            this.check(this.workflowHelper.checkForSimplifiedWorkflowNamedAfterProject(user, project));
            ConvertWorkflowModel model = new ConvertWorkflowModel();
            model.workflowSchemeName = workflowScheme == null ? i18n.getText("admin.schemes.workflows.default") : workflowScheme.getName();
            model.projectName = project.getName();
            model.projectKey = project.getKey();
            model.numIssuesToMigrate = this.getNumberOfIssuesToMigrate(project);
            model.isSysAdmin = this.permissionService.isJiraSystemAdministrator(user);
            model.statuses = this.getStatusModel(user, i18n, rapidView);
            return this.createOkResponse(model);
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/convert")
    public Response convertWorkflow(ConvertWorkflowRequest convertWorkflowRequest) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            ProjectService.GetProjectResult projectByKey = this.jiraProjectService.getProjectByKey(user, convertWorkflowRequest.projectKey);
            if (!projectByKey.isValid()) {
                this.check(ServiceOutcomeImpl.from(projectByKey.getErrorCollection()));
            }
            Project project = projectByKey.getProject();
            List<Status> resolutionDoneStatuses = this.check(this.workflowHelper.getStatusesByIds(convertWorkflowRequest.resolutionDoneStatusIds));
            ServiceOutcome<Scheme> conversionOutcome = this.simplifiedWorkflowService.createSimplifiedWorkflowForExistingProject(user, project, resolutionDoneStatuses);
            this.check(conversionOutcome);
            ConvertWorkflowModel model = new ConvertWorkflowModel();
            model.projectName = project.getName();
            model.projectId = project.getId();
            model.projectKey = project.getKey();
            model.workflowSchemeId = conversionOutcome.getValue().getId();
            model.workflowSchemeName = conversionOutcome.getValue().getName();
            model.numIssuesToMigrate = this.getNumberOfIssuesToMigrate(project);
            model.taskId = null;
            try {
                Option<TaskDescriptor<WorkflowMigrationResult>> migrationResult = this.workflowMigrationService.doMigrate(model.projectId, model.workflowSchemeId);
                if (!migrationResult.isEmpty()) {
                    model.taskId = ((TaskDescriptor)migrationResult.get()).getTaskId();
                }
            }
            catch (WorkflowMigrationException e) {
                this.log.warn("The migration did not go as planned - an exception was thrown: %s", e.getMessage());
                this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.config.workflow.convert.workflow.error.no.association", new Object[0]));
            }
            return this.createOkResponse(model);
        });
    }

    @POST
    @Path(value="/status/create")
    @Consumes(value={"application/json"})
    public Response createStatus(CreateStatusRequest createStatusRequest) {
        return this.response(() -> {
            this.ensureSimplifiedWorkflowFeatureEnabled();
            ApplicationUser user = this.getUser();
            ServiceOutcome<Void> validateStatusName = this.validateStatusName(createStatusRequest.name);
            this.check(validateStatusName);
            ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, createStatusRequest.rapidViewId);
            this.check(rapidView);
            ServiceOutcome<Status> addStatus = this.workflowHelper.addStatusToGreenHopperSimplifiedWorkflow(user, rapidView.getValue(), createStatusRequest.name, createStatusRequest.statusCategoryId);
            this.check(addStatus);
            Status status = addStatus.getValue();
            ColumnEditRequest.StatusDetails entity = ColumnEditRequest.StatusDetails.from(this.statusEntryFactory.createStatusEntry(status));
            entity.issueCount = 0L;
            entity.isPresentInWorkflow = true;
            return this.createOkResponse(entity);
        });
    }

    private void validateModifyWorkflow(ApplicationUser user, Project project, String errorMsgKey) {
        boolean isProjectAdmin = this.permissionService.isProjectAdministrator(user, Collections.singleton(project));
        if (!isProjectAdmin) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, errorMsgKey, new Object[0]));
        }
    }

    @Nonnull
    private ServiceOutcome<Void> queryForStatus(ApplicationUser user, Project project, Status status) {
        Query query = JqlQueryBuilder.newBuilder().where().defaultAnd().project(new Long[]{project.getId()}).status(new String[]{status.getName()}).buildQuery();
        ServiceOutcome<Long> queryOutcome = this.searchService.searchCountOverrideSecurity(user, query);
        if (!queryOutcome.isValid() || !queryOutcome.getValue().equals(0L)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.remove.status.error.issues.in.status", status.getNameTranslation(), project.getName());
        }
        return ServiceOutcomeImpl.ok();
    }

    @Nonnull
    private ServiceOutcome<Void> validateStatusName(String statusName) {
        if (StringUtils.isBlank((String)statusName)) {
            return ServiceOutcomeImpl.error(STATUS_NAME_CONTEXT_ID, ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.add.status.error.no.name", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    private void ensureSimplifiedWorkflowFeatureEnabled() {
        if (!this.simplifiedWorkflowService.isFeatureEnabled()) {
            this.log.warn("ApplicationUser attempted to use Simplified Workflow features when the feature is not enabled", new Object[0]);
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Your version of JIRA does not allow the use of Simplified Workflow features.", new Object[0]));
        }
    }

    private long getNumberOfIssuesToMigrate(Project project) {
        return this.jiraIssueManager.getIssueCountForProject(project.getId());
    }

    private List<StatusModel> getStatusModel(ApplicationUser user, I18n2 i18n, RapidView rapidView) {
        Pair<List<ColumnEditRequest.MappedColumn>, List<ColumnEditRequest.StatusDetails>> editModel = this.check(this.columnEditHelper.buildColumnStatusesModel(user, i18n, rapidView, false));
        ArrayList result = Lists.newArrayList();
        for (ColumnEditRequest.StatusDetails entry : (List)editModel.second()) {
            result.add(this.convertStatusEntry(entry, false));
        }
        ColumnEditRequest.MappedColumn lastColumn = (ColumnEditRequest.MappedColumn)((List)editModel.first()).get(((List)editModel.first()).size() - 1);
        for (ColumnEditRequest.MappedColumn column : (List)editModel.first()) {
            boolean isLastColumn = column == lastColumn;
            for (ColumnEditRequest.StatusDetails entry : column.mappedStatuses) {
                result.add(this.convertStatusEntry(entry, isLastColumn));
            }
        }
        return result;
    }

    private StatusModel convertStatusEntry(ColumnEditRequest.StatusDetails entry, boolean isLastColumn) {
        StatusModel model = new StatusModel();
        model.id = entry.id;
        model.name = entry.name;
        model.resolutionDoneCandidate = isLastColumn;
        return model;
    }

    @XmlRootElement
    public static class StatusModel
    extends RestTemplate {
        @XmlElement
        String id;
        @XmlElement
        String name;
        @XmlElement
        boolean resolutionDoneCandidate;
    }

    @XmlRootElement
    public static class RemoveStatusRequest
    extends RestTemplate {
        @XmlElement
        String statusId;
        @XmlElement
        String workflowName;
        @XmlElement
        boolean isInitialStatus;
        @XmlElement
        String newInitialStatusId;
    }

    @XmlRootElement
    public static class UpdateResolutionRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        String statusId;
        @XmlElement
        boolean done;
    }

    @XmlRootElement
    public static class RemoveStatusModel
    extends RestTemplate {
        @XmlElement
        String statusId;
        @XmlElement
        String statusName;
        @XmlElement
        String workflowName;
        @XmlElement
        String projectName;
        @XmlElement
        boolean isInitialStatus = false;
        @XmlElement
        String newInitialStatusId;
        @XmlElement
        String newInitialStatusName;
    }

    @XmlRootElement
    public static class CreateStatusRequest {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        Long statusCategoryId;
        @XmlElement
        String name;
    }

    @XmlRootElement
    public static class ConvertWorkflowRequest {
        @XmlElement
        String projectKey;
        @XmlElement
        List<String> resolutionDoneStatusIds;
    }

    @XmlRootElement
    public static class ConvertWorkflowModel
    extends RestTemplate {
        @XmlElement
        String projectName;
        @XmlElement
        String projectKey;
        @XmlElement
        Long projectId;
        @XmlElement
        String workflowSchemeName;
        @XmlElement
        Long workflowSchemeId;
        @XmlElement
        Long numIssuesToMigrate;
        @XmlElement
        boolean isSysAdmin;
        @XmlElement
        Long taskId;
        @XmlElement
        List<StatusModel> statuses;
    }
}

