/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneEntry;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="swimlanes")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SwimlaneResource
extends AbstractResource {
    private final SwimlaneHelper swimlaneHelper;

    public SwimlaneResource(SwimlaneHelper swimlaneHelper) {
        this.swimlaneHelper = swimlaneHelper;
    }

    @AnonymousAllowed
    @GET
    @Path(value="{rapidViewId}/{id}")
    public Response getSwimlane(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                SwimlaneEntry swimlaneModel = SwimlaneResource.this.swimlaneHelper.getSwimlane(SwimlaneResource.this.getUser(), rapidViewId, id);
                return SwimlaneResource.this.createOkResponse(swimlaneModel);
            }
        });
    }

    @PUT
    @Path(value="{rapidViewId}/{id}")
    public Response updateSwimlane(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final SwimlaneEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                SwimlaneEntry swimlaneModel = SwimlaneResource.this.swimlaneHelper.updateSwimlane(SwimlaneResource.this.getUser(), rapidViewId, id, editModel);
                return SwimlaneResource.this.createOkResponse(swimlaneModel);
            }
        });
    }

    @POST
    @Path(value="{rapidViewId}")
    public Response addSwimlane(final @PathParam(value="rapidViewId") Long rapidViewId, final SwimlaneEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                SwimlaneEntry swimlaneModel = SwimlaneResource.this.swimlaneHelper.addSwimlane(SwimlaneResource.this.getUser(), rapidViewId, editModel);
                return SwimlaneResource.this.createOkResponse(swimlaneModel);
            }
        });
    }

    @DELETE
    @Path(value="{rapidViewId}/{id}")
    public Response deleteSwimlane(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                SwimlaneResource.this.swimlaneHelper.deleteSwimlane(SwimlaneResource.this.getUser(), rapidViewId, id);
                return SwimlaneResource.this.createNoContentResponse();
            }
        });
    }

    @POST
    @Path(value="{rapidViewId}/{id}/move")
    public Response moveSwimlane(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final EntryMoveModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                SwimlaneResource.this.swimlaneHelper.moveSwimlane(SwimlaneResource.this.getUser(), rapidViewId, id, model);
                return SwimlaneResource.this.createNoContentResponse();
            }
        });
    }
}

