/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotFoundWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneEditModel;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneEntry;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwimlaneHelper {
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private SwimlaneService swimlanesService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    @Autowired
    private JqlHelper jqlHelper;

    public SwimlaneEditModel buildSwimlaneEditModel(ApplicationUser user, RapidView rapidView) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        SwimlaneEditModel model = new SwimlaneEditModel();
        model.rapidView = rapidView;
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        model.swimlaneStrategy = rapidView.getSwimlaneStrategy().getId();
        ArrayList<SwimlaneEntry> swimlanes = new ArrayList<SwimlaneEntry>();
        for (Swimlane swimlane : this.swimlanesService.loadSwimlanes(rapidView)) {
            SwimlaneEntry editModel = this.toEditModel(user, swimlane, i18n);
            swimlanes.add(editModel);
        }
        model.swimlanes = swimlanes;
        return model;
    }

    public ServiceOutcome<RapidView> updateSwimlaneStrategy(ApplicationUser user, long rapidViewId, String swimlaneStrategyId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        SwimlaneStrategy swimlaneStrategy = SwimlaneStrategy.lookup(swimlaneStrategyId);
        RapidView updatedView = RapidView.builder(rapidView.getValue()).swimlaneStrategy(swimlaneStrategy).build();
        ServiceResult updated = this.rapidViewService.update(user, updatedView);
        if (!updated.isValid()) {
            return ServiceOutcomeImpl.error(updated);
        }
        return ServiceOutcomeImpl.ok(updatedView);
    }

    public SwimlaneEntry getSwimlane(ApplicationUser user, long rapidViewId, long swimlaneId) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        ErrorCollection errors = new ErrorCollection();
        Swimlane swimlane = this.swimlanesService.get(user, rapidView.getValue(), swimlaneId, errors);
        if (errors.hasErrors()) {
            throw new JiraCopiedNotFoundWebException(JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(errors, user)));
        }
        return this.toEditModel(user, swimlane, i18n);
    }

    public SwimlaneEntry addSwimlane(ApplicationUser user, long rapidViewId, SwimlaneEntry editModel) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        Swimlane swimlane = Swimlane.builder().name(StringUtils.defaultString((String)editModel.name)).query(StringUtils.defaultString((String)editModel.query)).description(StringUtils.defaultString((String)editModel.description)).build();
        ServiceOutcome<Swimlane> createdSwimlane = this.swimlanesService.add(user, rapidView.getValue(), swimlane);
        if (!createdSwimlane.isValid()) {
            ErrorCollections.checkErrors(createdSwimlane.getErrors(), i18n);
        }
        return this.toEditModel(user, createdSwimlane.getValue(), i18n);
    }

    public SwimlaneEntry updateSwimlane(ApplicationUser user, long rapidViewId, long swimlaneId, SwimlaneEntry editModel) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        ErrorCollection errors = new ErrorCollection();
        Swimlane existingSwimlane = this.swimlanesService.get(user, rapidView.getValue(), swimlaneId, errors);
        ErrorCollections.checkErrors(errors, i18n);
        Swimlane.SwimlaneBuilder swimlane = Swimlane.builder(existingSwimlane);
        if (editModel.name != null) {
            swimlane.name(editModel.name);
        }
        if (!existingSwimlane.isDefaultLane() && editModel.query != null) {
            swimlane.query(editModel.query);
        }
        if (editModel.description != null) {
            swimlane.description(editModel.description);
        }
        Swimlane updatedSwimlane = this.swimlanesService.update(user, rapidView.getValue(), swimlane.build(), errors);
        ErrorCollections.checkErrors(errors, i18n);
        return this.toEditModel(user, updatedSwimlane, i18n);
    }

    public void deleteSwimlane(ApplicationUser user, long rapidViewId, long swimlaneId) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        ErrorCollection errors = new ErrorCollection();
        this.swimlanesService.delete(user, rapidView.getValue(), swimlaneId, errors);
        ErrorCollections.checkErrors(errors, i18n);
    }

    public void moveSwimlane(ApplicationUser user, long rapidViewId, long swimlaneId, EntryMoveModel moveModel) {
        ServiceOutcome<Void> outcome;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        if (!(outcome = this.swimlanesService.moveAfter(user, rapidView.getValue(), swimlaneId, moveModel.getMoveToId())).isValid()) {
            ErrorCollections.checkErrors(outcome.getErrors(), i18n);
        }
    }

    private SwimlaneEntry toEditModel(ApplicationUser user, Swimlane swimlane, I18n2 i18n) {
        SwimlaneEntry swimlaneModel = new SwimlaneEntry();
        swimlaneModel.id = swimlane.getId();
        swimlaneModel.name = i18n.getText(swimlane.getName());
        swimlaneModel.query = this.jqlHelper.getSanitisedQueryString(user, swimlane.getQuery());
        swimlaneModel.description = i18n.getText(swimlane.getDescription());
        swimlaneModel.isDefault = swimlane.isDefaultLane();
        return swimlaneModel;
    }
}

