/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotFoundWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.service.subquery.SubqueryService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.greenhopper.web.rapid.view.SubqueryEditModel;
import com.atlassian.greenhopper.web.rapid.view.SubqueryEntry;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubqueryHelper {
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private SubqueryService subqueryService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;

    public ServiceOutcome<SubqueryEditModel> buildSubqueryEditModel(ApplicationUser user, RapidView rapidView) {
        SubqueryEditModel model = new SubqueryEditModel();
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        ServiceOutcome<Subquery> outcome = this.subqueryService.getSubquery(user, rapidView);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        model.subqueries = Collections.singletonList(this.toEditModel(user, outcome.getValue()));
        return ServiceOutcomeImpl.ok(model);
    }

    public SubqueryEntry getSubquery(ApplicationUser user, long rapidViewId) {
        ServiceOutcome<Subquery> subquery;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        if (!(subquery = this.subqueryService.getSubquery(user, rapidView.getValue())).isValid()) {
            throw new JiraCopiedNotFoundWebException(JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(subquery.getErrors(), user)));
        }
        return this.toEditModel(user, subquery.getValue());
    }

    public SubqueryEntry updateSubquery(ApplicationUser user, long rapidViewId, SubqueryEntry editModel) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        Subquery subquery = Subquery.builder().query(editModel.query).build();
        ServiceOutcome<Subquery> updated = this.subqueryService.updateSubquery(user, rapidView.getValue(), subquery);
        if (!updated.isValid()) {
            ErrorCollections.checkErrors(updated.getErrors(), i18n);
        }
        return this.toEditModel(user, updated.getValue());
    }

    private SubqueryEntry toEditModel(ApplicationUser user, Subquery subquery) {
        SubqueryEntry SubqueryModel = new SubqueryEntry();
        SubqueryModel.id = subquery.getId();
        SubqueryModel.query = this.jqlHelper.getSanitisedQueryString(user, subquery.getQuery());
        return SubqueryModel;
    }
}

