/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.jira.util.lang.Pair;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
public class StatisticsFieldEntry
extends RestTemplate {
    @XmlElement
    String typeId;
    @XmlElement
    String fieldId;
    @XmlElement
    String id;
    @XmlElement
    String name;
    @XmlElement
    boolean isValid = true;
    @XmlElement
    boolean isEnabled;
    @XmlElement
    String renderer;

    public static StatisticsFieldEntry create(String typeId, String fieldId, String name, boolean isEnabled, boolean isValid) {
        StatisticsFieldEntry entry = new StatisticsFieldEntry();
        entry.typeId = typeId;
        entry.fieldId = fieldId;
        entry.id = StatisticsFieldEntry.buildCompositeId(typeId, fieldId);
        entry.name = name;
        entry.isEnabled = isEnabled;
        entry.isValid = isValid;
        entry.renderer = "timeoriginalestimate".equals(fieldId) || "timeestimate".equals(fieldId) ? FieldRenderer.DURATION.getKey() : FieldRenderer.NUMBER.getKey();
        return entry;
    }

    public static StatisticsFieldEntry create(StatisticsField statisticsField, I18n2 i18n) {
        return StatisticsFieldEntry.create(statisticsField.getConfig().getType().getId(), statisticsField.getConfig().getFieldId(), statisticsField.getDisplayName(i18n), statisticsField.isEnabled(), statisticsField.isValid());
    }

    public static StatisticsFieldEntry create(StatisticsFieldInstance statisticsField, I18n2 i18n) {
        return StatisticsFieldEntry.create(statisticsField.getConfig().getType().getId(), statisticsField.getConfig().getFieldId(), statisticsField.getDisplayName(i18n), statisticsField.isEnabled(), statisticsField.isValid());
    }

    public static String getTypeIdFromComposite(String compositeId) {
        if (!compositeId.contains("_")) {
            throw new IllegalArgumentException("Invalid composite id format for '" + compositeId + "'");
        }
        return compositeId.substring(0, compositeId.indexOf("_"));
    }

    public static String getFieldIdFromComposite(String compositeId) {
        if (!compositeId.contains("_")) {
            throw new IllegalArgumentException("Invalid composite id format for '" + compositeId + "'");
        }
        return compositeId.substring(compositeId.indexOf("_") + 1);
    }

    public static ServiceOutcome<Pair<String, String>> parseCompositeId(String compositeId) {
        if (!compositeId.contains("_")) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.estimation.statistics.error.format", compositeId);
        }
        String typeId = compositeId.substring(0, compositeId.indexOf("_"));
        String fieldId = compositeId.endsWith("_") ? "" : compositeId.substring(compositeId.indexOf("_") + 1);
        Pair result = Pair.of((Object)typeId, (Object)fieldId);
        return ServiceOutcomeImpl.ok(result);
    }

    private static String buildCompositeId(String typeId, String fieldId) {
        StringBuilder sb = new StringBuilder(typeId).append("_");
        if (StringUtils.isNotBlank((CharSequence)fieldId)) {
            sb.append(fieldId);
        }
        return sb.toString();
    }

    @XmlRootElement
    public static class ValidationEntry
    extends RestTemplate {
        @XmlElement
        public boolean isValid;
        @XmlElement
        public String validationMessage;
    }
}

