/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.view.RapidViewFilterHelper;
import com.atlassian.greenhopper.web.rapid.view.SavedFilterEntry;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/savedfilter")
@Produces(value={"application/json"})
public class SavedFilterResource
extends AbstractResource {
    private final RapidViewFilterHelper rapidViewFilterHelper;
    private final ErrorCollectionTransformer errorCollectionTransformer;

    public SavedFilterResource(RapidViewFilterHelper rapidViewFilterHelper, ErrorCollectionTransformer errorCollectionTransformer) {
        this.rapidViewFilterHelper = rapidViewFilterHelper;
        this.errorCollectionTransformer = errorCollectionTransformer;
    }

    @GET
    @Path(value="list")
    public Response getList(final @QueryParam(value="query") String query) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<List<SavedFilterEntry>> outcome = SavedFilterResource.this.rapidViewFilterHelper.searchSavedFiltersByQuery(SavedFilterResource.this.getUser(), query);
                SavedFilterListModel model = new SavedFilterListModel();
                String string = model.query = query != null ? query : "";
                if (outcome.isValid()) {
                    model.filters = outcome.getValue();
                } else {
                    model.errors = JiraCopiedRestErrorCollection.of(SavedFilterResource.this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors()));
                }
                return SavedFilterResource.this.createOkResponse(model);
            }
        });
    }

    @XmlRootElement
    public static class SavedFilterListModel
    extends RestTemplate {
        @XmlElement
        public String query;
        @XmlElement
        public List<SavedFilterEntry> filters;
        @XmlElement
        public JiraCopiedRestErrorCollection errors;
    }
}

