/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RapidViewEntry;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.view.RapidViewHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="rapidview")
@Produces(value={"application/json"})
public class RapidViewResource
extends AbstractResource {
    private final RapidViewHelper rapidViewHelper;

    public RapidViewResource(RapidViewHelper rapidViewHelper) {
        this.rapidViewHelper = rapidViewHelper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/create/advanced")
    public Response create(final CreateAdvancedRequest createAdvancedRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CreateResponse> result = RapidViewResource.this.rapidViewHelper.createRapidViewWithFilter(RapidViewResource.this.getUser(), createAdvancedRequest.name, createAdvancedRequest.filterId, createAdvancedRequest.methodology);
                RapidViewResource.this.check(result);
                return RapidViewResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/create/presets")
    public Response setupView(final CreatePresetsRequest createPresetsRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CreateResponse> result = RapidViewResource.this.rapidViewHelper.createRapidViewForPreset(RapidViewResource.this.getUser(), createPresetsRequest.name, createPresetsRequest.projectIds, createPresetsRequest.preset);
                RapidViewResource.this.check(result);
                return RapidViewResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @GET
    @AnonymousAllowed
    @Path(value="{id}")
    public Response read(final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidViewEntry> result = RapidViewResource.this.rapidViewHelper.getRapidView(RapidViewResource.this.getUser(), id);
                RapidViewResource.this.check(result);
                return RapidViewResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @GET
    @AnonymousAllowed
    public Response readAll() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<List<RapidViewEntry>> result = RapidViewResource.this.rapidViewHelper.getRapidViews(RapidViewResource.this.getUser());
                RapidViewResource.this.check(result);
                AllViewsResponse response = new AllViewsResponse();
                response.views = result.getValue();
                return RapidViewResource.this.createOkResponse(response);
            }
        });
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<String> result = RapidViewResource.this.rapidViewHelper.deleteRapidView(RapidViewResource.this.getUser(), id);
                RapidViewResource.this.check(result);
                DeleteResponse response = new DeleteResponse();
                response.message = result.getValue();
                return RapidViewResource.this.createOkResponse(response);
            }
        });
    }

    @PUT
    @Path(value="{id}/copy")
    public Response copy(final @PathParam(value="id") Long sourceRapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidViewEntry> result = RapidViewResource.this.rapidViewHelper.copyRapidView(RapidViewResource.this.getUser(), sourceRapidViewId);
                RapidViewResource.this.check(result);
                return RapidViewResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @GET
    @Path(value="createmodel")
    public Response getCreateModel() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return RapidViewResource.this.createOkResponse(RapidViewResource.this.rapidViewHelper.getCreateModel(RapidViewResource.this.getUser()));
            }
        });
    }

    @XmlRootElement
    static class AllViewsResponse
    extends RestTemplate {
        @XmlElement
        List<RapidViewEntry> views;

        AllViewsResponse() {
        }
    }

    @XmlRootElement
    static class DeleteResponse
    extends RestTemplate {
        @XmlElement
        String message;

        DeleteResponse() {
        }
    }

    @XmlRootElement
    static class CreateResponse
    extends RestTemplate {
        @XmlElement
        Long id;
        @XmlElement
        String name;

        CreateResponse() {
        }
    }

    @XmlRootElement
    private static class CreatePresetsRequest
    extends RestTemplate {
        @XmlElement
        String name;
        @XmlElement
        Set<String> projectIds;
        @XmlElement
        String preset;

        private CreatePresetsRequest() {
        }
    }

    @XmlRootElement
    private static class CreateAdvancedRequest
    extends RestTemplate {
        @XmlElement
        String name;
        @XmlElement
        Long filterId;
        @XmlElement
        String methodology;

        private CreateAdvancedRequest() {
        }
    }
}

