/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectEntry;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectListResponse;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewProjectHelper {
    public static final int MAX_SUPPORT_SHOWING_PROJECT = 10;
    @Autowired
    private QueryService queryService;
    @Autowired
    private I18nHelper.BeanFactory i18nBeanFactory;
    @Autowired
    private PermissionManager permissionManager;

    public ServiceOutcome<RapidViewProjectListResponse> getRapidViewProjectList(ApplicationUser user, Query query) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(user);
        RapidViewProjectListResponse projectList = new RapidViewProjectListResponse();
        ServiceOutcome<Set<Project>> boardFilterProjects = this.queryService.getProjectsForRapidViewFilterQuery(user, query);
        Set<Project> projectsForView = boardFilterProjects.getValue();
        if (CollectionUtils.isEmpty(projectsForView)) {
            projectList.displayMessage = i18nHelper.getText("gh.rapid.view.configure.undefined.projects");
            return ServiceOutcomeImpl.ok(projectList);
        }
        int returnedProjectsCount = projectsForView.size();
        if (returnedProjectsCount > 10) {
            projectList.displayMessage = i18nHelper.getText("gh.rapid.view.configure.number.projects", (Object)returnedProjectsCount);
            return ServiceOutcomeImpl.ok(projectList);
        }
        projectList.projects = this.transformProjectsToRapidViewProjectEntries(Lists.newArrayList(projectsForView), user);
        return ServiceOutcomeImpl.ok(projectList);
    }

    private List<RapidViewProjectEntry> transformProjectsToRapidViewProjectEntries(List<Project> projectsForView, ApplicationUser user) {
        return projectsForView.stream().map(project -> RapidViewProjectEntry.create(project.getId(), project.getName(), project.getKey(), this.canEditProjectConfiguration((Project)project, user))).collect(Collectors.toList());
    }

    private boolean canEditProjectConfiguration(Project project, ApplicationUser user) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }
}

