/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.project.ProjectHelper;
import com.atlassian.greenhopper.web.rapid.RapidGlobalConfig;
import com.atlassian.greenhopper.web.rapid.RapidViewEntry;
import com.atlassian.greenhopper.web.rapid.RapidViewEntryList;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListModel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="rapidviews")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RapidViewListResource
extends AbstractResource {
    private static final int MAX_RECENT_VIEWS_TO_SHOW = 9;
    private final RapidViewListHelper rapidViewListHelper;
    private final ProjectHelper projectHelper;

    public RapidViewListResource(RapidViewListHelper rapidViewListHelper, ProjectHelper projectHelper) {
        this.rapidViewListHelper = rapidViewListHelper;
        this.projectHelper = projectHelper;
    }

    @GET
    @Path(value="/list")
    public Response getListModel(final @QueryParam(value="query") String query, final @QueryParam(value="projectKey") String projectKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                if (query != null && projectKey != null) {
                    throw new UnsupportedOperationException("query and projectKey parameters cannot be used in conjunction.");
                }
                if (projectKey != null) {
                    Project project = RapidViewListResource.this.check(RapidViewListResource.this.projectHelper.getProjectByKey(RapidViewListResource.this.getUser(), projectKey));
                    List<RapidViewEntry> projectRapidViews = RapidViewListResource.this.check(RapidViewListResource.this.rapidViewListHelper.getProjectRapidViews(RapidViewListResource.this.getUser(), project));
                    RapidViewEntryList model = new RapidViewEntryList();
                    model.views = projectRapidViews;
                    return RapidViewListResource.this.createOkResponse(model);
                }
                RapidViewListModel result = RapidViewListResource.this.check(RapidViewListResource.this.rapidViewListHelper.queryListModel(RapidViewListResource.this.getUser(), query));
                return RapidViewListResource.this.createOkResponse(result);
            }
        });
    }

    @GET
    @Path(value="/viewsData")
    public Response getViewsAndConfigModel(final @QueryParam(value="query") String name, final @QueryParam(value="type") StringList type, final @QueryParam(value="startAt") Long startAt, final @QueryParam(value="maxResults") Integer maxResults) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RapidViewListModel result = RapidViewListResource.this.check(RapidViewListResource.this.rapidViewListHelper.buildListAndConfigModel(RapidViewListResource.this.getUser(), name, type, startAt, maxResults));
                return RapidViewListResource.this.createOkResponse(result);
            }
        });
    }

    @GET
    @Path(value="/config")
    public Response getConfigModel() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RapidGlobalConfig configModel = RapidViewListResource.this.check(RapidViewListResource.this.rapidViewListHelper.buildConfigModel(RapidViewListResource.this.getUser()));
                return RapidViewListResource.this.createOkResponse(configModel);
            }
        });
    }

    @GET
    @Path(value="/recent")
    public Response getRecentBoards(@QueryParam(value="maxResults") Integer maxResults) {
        if (maxResults == null || maxResults < 1 || maxResults > 9) {
            maxResults = 9;
        }
        final Integer finalMaxResults = maxResults;
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RapidViewListModel recentBoards = RapidViewListResource.this.check(RapidViewListResource.this.rapidViewListHelper.getRecentBoards(RapidViewListResource.this.getUser(), finalMaxResults));
                return RapidViewListResource.this.createOkResponse(recentBoards);
            }
        });
    }
}

