/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.api.rest.util.QueryParamParser;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.RapidBoardViewModelFactory;
import com.atlassian.greenhopper.web.rapid.RapidGlobalConfig;
import com.atlassian.greenhopper.web.rapid.RapidViewEntry;
import com.atlassian.greenhopper.web.rapid.view.BoardAdminsModel;
import com.atlassian.greenhopper.web.rapid.view.RapidViewFilterHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListEntry;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListModel;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewListHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private RapidViewFilterHelper rapidViewFilterHelper;
    @Autowired
    private UserFormats userFormats;
    @Autowired
    private BoardAdminService boardAdminService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private RapidBoardViewModelFactory rapidBoardViewModelFactory;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    @Autowired
    private RapidViewHistoryService rapidViewHistoryService;
    @Autowired
    private ProjectRapidViewService projectRapidViewService;
    @Autowired
    private UserKeyService userKeyService;
    private final Supplier<UserFormatter> profileLinkFormat = Suppliers.memoize((Supplier)new Supplier<UserFormatter>(){

        public UserFormatter get() {
            return RapidViewListHelper.this.userFormats.formatter("profileLink");
        }
    });

    public ServiceOutcome<RapidViewListModel> buildListAndConfigModel(ApplicationUser user, String query, StringList typeNames, Long start, Integer limit) {
        RapidViewQuery.Builder rapidViewQueryBuilder = RapidViewQuery.builder().partialName(query);
        if (typeNames != null && !typeNames.asList().isEmpty()) {
            ServiceOutcome<Set<RapidView.Type>> types = QueryParamParser.parseEnumSet("type", (List<String>)typeNames.asList(), RapidView.Type.class);
            if (types.isValid()) {
                rapidViewQueryBuilder.types(types.get());
            } else {
                return com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl.error(types);
            }
        }
        RapidViewQuery rapidViewQuery = rapidViewQueryBuilder.filterByBoardAdmin(true).build();
        ServiceOutcome<Page<RapidView>> rapidViews = this.rapidViewService.getRapidViews(user, PageRequests.request(start, limit), rapidViewQuery);
        if (!rapidViews.isValid()) {
            return ServiceOutcomeImpl.error(rapidViews);
        }
        ServiceOutcome<RapidViewListModel> modelServiceOutcome = this.buildListModel(user, rapidViews.get());
        if (modelServiceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(modelServiceOutcome);
        }
        RapidViewListModel model = modelServiceOutcome.get();
        model.globalConfig = this.rapidBoardViewModelFactory.buildRapidGlobalConfig(user);
        model.startAt = start;
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<RapidViewListModel> queryListModel(ApplicationUser user, String query) {
        RapidViewQuery rapidViewQuery = RapidViewQuery.builder().partialName(query).build();
        ServiceOutcome<Page<RapidView>> rapidViews = this.rapidViewService.getRapidViews(user, PageRequests.request(0L, PageRequest.MAX_PAGE_LIMIT), rapidViewQuery);
        if (!rapidViews.isValid()) {
            return ServiceOutcomeImpl.error(rapidViews);
        }
        return this.buildListModel(user, rapidViews.get());
    }

    public ServiceOutcome<List<RapidViewEntry>> getProjectRapidViews(ApplicationUser user, Project project) {
        ServiceOutcome<List<RapidView>> rapidViewsByProjectOutcome = this.projectRapidViewService.findRapidViewsByProject(user, project);
        if (rapidViewsByProjectOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewsByProjectOutcome);
        }
        ArrayList projectRapidViews = Lists.newArrayList();
        for (RapidView rapidView : rapidViewsByProjectOutcome.get()) {
            projectRapidViews.add(RapidViewEntry.fromRapidView(rapidView, true));
        }
        return ServiceOutcomeImpl.ok(projectRapidViews);
    }

    private ServiceOutcome<RapidViewListModel> buildListModel(ApplicationUser user, Page<RapidView> rapidViewPage) {
        RapidViewListModel model = new RapidViewListModel();
        List<RapidView> views = rapidViewPage.getValues();
        Multimap<RapidView, BoardAdmin> viewAdmins = this.boardAdminService.getBoardAdmins(views);
        ArrayList entries = Lists.newArrayListWithCapacity((int)views.size());
        for (RapidView view : views) {
            ServiceOutcome<RapidViewListEntry> outcome = this.buildListEntry(user, view, viewAdmins);
            if (!outcome.isValid()) {
                return ServiceOutcomeImpl.error(outcome);
            }
            entries.add(outcome.getValue());
        }
        model.views = entries;
        model.total = rapidViewPage.getTotal();
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<RapidViewListModel> getRecentBoards(ApplicationUser user, Integer maxResults) {
        List<RapidView> recentBoards = this.rapidViewHistoryService.getRecentViews(user, maxResults);
        Multimap<RapidView, BoardAdmin> viewAdmins = this.boardAdminService.getBoardAdmins(recentBoards);
        ArrayList<RapidViewListEntry> entries = new ArrayList<RapidViewListEntry>();
        for (RapidView view : recentBoards) {
            ServiceOutcome<RapidViewListEntry> outcome = this.buildListEntry(user, view, viewAdmins);
            if (!outcome.isValid()) {
                this.log.info("recent board list entry build failed: %s", this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors(), user));
                continue;
            }
            entries.add(outcome.getValue());
        }
        RapidViewListModel model = new RapidViewListModel();
        model.views = entries;
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<RapidGlobalConfig> buildConfigModel(ApplicationUser user) {
        return ServiceOutcomeImpl.ok(this.rapidBoardViewModelFactory.buildRapidGlobalConfig(user));
    }

    private ServiceOutcome<RapidViewListEntry> buildListEntry(ApplicationUser user, RapidView view, Multimap<RapidView, BoardAdmin> viewAdmins) {
        RapidViewListEntry entry = new RapidViewListEntry();
        entry.rapidView = view;
        entry.id = view.getId();
        entry.name = view.getName();
        entry.canEdit = this.rapidViewPermissionService.canEdit(user, view);
        entry.sprintSupportEnabled = view.isSprintSupportEnabled();
        entry.boardAdmins = this.buildBoardAdminsFromView(viewAdmins.get((Object)view));
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, view.getSavedFilterId());
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        entry.filter = this.rapidViewFilterHelper.buildSavedFilterEntry(user, savedFilter.getValue());
        return ServiceOutcomeImpl.ok(entry);
    }

    private BoardAdminsModel buildBoardAdminsFromView(Collection<BoardAdmin> boardAdmins) {
        ArrayList users = Lists.newArrayList();
        ArrayList groups = Lists.newArrayList();
        for (BoardAdmin boardAdmin : boardAdmins) {
            BoardAdminsModel.BoardAdmin newBoardAdmin = new BoardAdminsModel.BoardAdmin();
            newBoardAdmin.key = boardAdmin.getKey();
            if (boardAdmin.getType() == BoardAdmin.Type.GROUP) {
                newBoardAdmin.displayName = boardAdmin.getKey();
                groups.add(newBoardAdmin);
                continue;
            }
            if (boardAdmin.getType() != BoardAdmin.Type.USER) continue;
            newBoardAdmin.displayName = ((UserFormatter)this.profileLinkFormat.get()).formatUsername(this.getUserNameForKey(boardAdmin.getKey()), "");
            users.add(newBoardAdmin);
        }
        return BoardAdminsModel.create(users, groups);
    }

    private String getUserNameForKey(String userKey) {
        return this.userKeyService.getUsernameForKey(userKey);
    }
}

