/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.customfield.CustomFieldConfigurationRestorer;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.RapidViewEntry;
import com.atlassian.greenhopper.web.rapid.view.RapidViewCreateModel;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.greenhopper.web.rapid.view.RapidViewResource;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private CustomFieldConfigurationRestorer customFieldConfigurationRestorer;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewManager rapidViewManager;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private ProjectRapidViewService projectRapidViewService;
    @Autowired
    private ProjectService jiraProjectService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private RapidViewPresetService rapidViewPresetService;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public RapidViewCreateModel getCreateModel(ApplicationUser user) {
        RapidViewCreateModel createModel = new RapidViewCreateModel();
        createModel.canSeeSavedFilters = this.savedFilterService.canUserSeeAnySavedFilters(user);
        return createModel;
    }

    public ServiceOutcome<RapidViewResource.CreateResponse> createRapidViewForPreset(ApplicationUser user, String name, Set<String> projectIds, String presetName) {
        List<Project> projects;
        ErrorCollection errors = new ErrorCollection();
        Optional<RapidViewPreset> preset = RapidViewPreset.get(presetName);
        if (!preset.isPresent()) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "preset", "gh.rapid.welcome.view.invalid.preset", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.wizard.board.specify.name", new Object[0]);
        }
        if ((projects = this.getProjects(user, projectIds)).isEmpty()) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "projectIds", "gh.rapid.welcome.view.projects.error.required", new Object[0]);
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome<RapidView> rapidView = this.createRapidViewWithProjects(user, name, preset.get(), projects);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        return ServiceOutcomeImpl.ok(this.toCreateResponse(rapidView.getValue()));
    }

    public ServiceOutcome<RapidView> createDefaultRapidViewForProject(ApplicationUser user, String name, RapidViewPreset preset, Project project) {
        return this.createRapidViewWithProjects(user, name, preset, Arrays.asList(project), true);
    }

    public ServiceOutcome<RapidView> createRapidViewWithProjects(ApplicationUser user, String name, RapidViewPreset preset, List<Project> projects) {
        return this.createRapidViewWithProjects(user, name, preset, projects, false);
    }

    public ServiceOutcome<RapidViewResource.CreateResponse> createRapidViewWithFilter(ApplicationUser user, String name, Long filterId, String methodology) {
        ErrorCollection errors = new ErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.wizard.board.specify.name", new Object[0]);
        }
        if (filterId == null) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "filterId", "gh.wizard.specify.filter", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)methodology)) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "methodology", "gh.wizard.specify.methodology", new Object[0]);
        }
        RapidViewPreset preset = null;
        if ("scrum".equalsIgnoreCase(methodology)) {
            preset = RapidViewPreset.SCRUM;
        } else if ("kanban".equalsIgnoreCase(methodology)) {
            preset = RapidViewPreset.KANBAN;
        } else {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "methodology", "gh.wizard.specify.scrum.or.kanban", new Object[0]);
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.create(user, name, filterId, preset);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        this.customFieldConfigurationRestorer.ensureFieldsAreCorrectlyConfigured(Collections.emptyList(), RapidViewPresetService.getAssociatedProjectType(preset), CustomFieldConfigurationRestorer.ScreenSchemeOption.USE_EXISTING_SCREEN_SCHEME);
        return ServiceOutcomeImpl.ok(this.toCreateResponse(rapidView.getValue()));
    }

    public ServiceOutcome<String> deleteRapidView(ApplicationUser user, Long id) {
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, id);
        if (!rapidViewOutcome.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        ServiceResult deleteOutcome = this.rapidViewService.delete(user, rapidViewOutcome.get());
        if (!deleteOutcome.isValid()) {
            return ServiceOutcomeImpl.error(deleteOutcome);
        }
        return ServiceOutcomeImpl.ok("RapidView with id " + id + " has been successfully deleted.");
    }

    public ServiceOutcome<RapidViewEntry> copyRapidView(ApplicationUser user, Long sourceRapidViewId) {
        ServiceOutcome<RapidView> sourceRapidView = this.rapidViewService.getRapidView(user, sourceRapidViewId);
        if (!sourceRapidView.isValid()) {
            return ServiceOutcomeImpl.error(sourceRapidView);
        }
        ServiceOutcome<RapidView> copiedRapidView = this.rapidViewService.copy(user, sourceRapidView.getValue());
        if (!copiedRapidView.isValid()) {
            return ServiceOutcomeImpl.error(copiedRapidView);
        }
        return ServiceOutcomeImpl.ok(RapidViewEntry.fromRapidView(copiedRapidView.getValue(), this.rapidViewPermissionService.canEdit(user, copiedRapidView.getValue())));
    }

    public ServiceOutcome<RapidViewEntry> getRapidView(ApplicationUser user, Long id) {
        ServiceOutcome<RapidView> view = this.rapidViewService.getRapidView(user, id);
        if (!view.isValid()) {
            return ServiceOutcomeImpl.error(view);
        }
        return ServiceOutcomeImpl.ok(RapidViewEntry.fromRapidView(view.getValue(), this.rapidViewPermissionService.canEdit(user, view.getValue())));
    }

    public ServiceOutcome<List<RapidViewEntry>> getRapidViews(ApplicationUser user) {
        ArrayList<RapidViewEntry> entries = new ArrayList<RapidViewEntry>();
        List rapidViews = (List)MoreObjects.firstNonNull(this.rapidViewService.getRapidViews(user).getValue(), Collections.emptyList());
        for (RapidView view : rapidViews) {
            entries.add(RapidViewEntry.fromRapidView(view, this.rapidViewPermissionService.canEdit(user, view)));
        }
        return ServiceOutcomeImpl.ok(entries);
    }

    public String getDefaultBoardName(Project project, ApplicationUser user) {
        return this.i18nFactoryService.getI18n(user).getText("gh.board.name", (Object)project.getKey());
    }

    private List<Project> getProjects(ApplicationUser user, Set<String> projectIds) {
        ArrayList<Project> projects = new ArrayList<Project>();
        if (null == projectIds) {
            return projects;
        }
        for (String projectIdString : projectIds) {
            try {
                Long id = Long.parseLong(projectIdString);
                ProjectService.GetProjectResult result = this.jiraProjectService.getProjectById(user, id);
                if (result.getErrorCollection().hasAnyErrors()) continue;
                projects.add(result.getProject());
            }
            catch (NumberFormatException e) {
                this.log.info("Shouldn't have gotten a bad project id '%s'. Skipping...", projectIdString);
            }
        }
        return projects;
    }

    private ServiceOutcome<SearchRequest> createSavedFilter(ApplicationUser user, String boardName, RapidViewPreset preset, List<Project> projects, boolean skipFilterCreationPermissionCheck) {
        Query query = this.rapidViewPresetService.createDefaultBaseQuery(preset, projects);
        SharedEntity.SharePermissions sharePermissions = this.buildPermissions(projects);
        ServiceOutcome<SearchRequest> result = skipFilterCreationPermissionCheck ? this.savedFilterService.createSavedFilterWithNoPermissionCheck(user, boardName, query, sharePermissions) : this.savedFilterService.createSavedFilter(user, boardName, query, sharePermissions);
        if (!result.isValid()) {
            this.log.info("saved filter creation failed: %s", result.getErrors());
        } else {
            this.log.info("created new saved filter: %d %s", result.getValue().getId(), result.getValue().getName());
        }
        return result;
    }

    private SharedEntity.SharePermissions buildPermissions(List<Project> projects) {
        HashSet<SharePermissionImpl> shares = new HashSet<SharePermissionImpl>();
        for (Project project : projects) {
            shares.add(new SharePermissionImpl(ProjectShareType.TYPE, String.valueOf(project.getId()), null));
        }
        return new SharedEntity.SharePermissions(shares);
    }

    private RapidViewResource.CreateResponse toCreateResponse(RapidView rapidView) {
        RapidViewResource.CreateResponse response = new RapidViewResource.CreateResponse();
        response.id = rapidView.getId();
        response.name = rapidView.getName();
        return response;
    }

    private ServiceOutcome<RapidView> createRapidViewWithProjects(ApplicationUser user, String name, RapidViewPreset preset, List<Project> projects, boolean skipFilterCreationPermissionCheck) {
        ServiceOutcome<SearchRequest> savedFilterOutcome = this.createSavedFilter(user, name, preset, projects, skipFilterCreationPermissionCheck);
        if (!savedFilterOutcome.isValid()) {
            return ServiceOutcomeImpl.from(savedFilterOutcome.getErrors());
        }
        SearchRequest savedFilter = savedFilterOutcome.get();
        ServiceOutcome<RapidView> rapidView = skipFilterCreationPermissionCheck ? this.rapidViewManager.create(user, name, savedFilter.getId(), preset) : this.rapidViewService.create(user, name, savedFilter.getId(), preset);
        if (!rapidView.isValid()) {
            this.log.info("deleting saved filter: %d", savedFilter.getId());
            this.savedFilterService.deleteSavedFilter(user, savedFilter.getId());
            return ServiceOutcomeImpl.from(rapidView.getErrors());
        }
        this.customFieldConfigurationRestorer.ensureFieldsAreCorrectlyConfigured(projects, RapidViewPresetService.getAssociatedProjectType(preset), CustomFieldConfigurationRestorer.ScreenSchemeOption.USE_EXISTING_SCREEN_SCHEME);
        return ServiceOutcomeImpl.ok(rapidView.get());
    }

    public ServiceOutcome<RapidView> getDefaultRapidViewForProject(ApplicationUser user, Project project) {
        ServiceOutcome<List<RapidView>> rapidViewsByProject = this.projectRapidViewService.findRapidViewsByProject(user, project);
        if (rapidViewsByProject.isInvalid()) {
            return ServiceOutcomeImpl.from(rapidViewsByProject.getErrors());
        }
        Optional<RapidView> first = rapidViewsByProject.get().stream().filter(rapidView -> this.getDefaultBoardName(project, user).equals(rapidView.getName())).findFirst();
        if (!first.isPresent()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "Could not find default board for Project", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(first.get());
    }
}

