/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.features.AgileDarkFeature;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rank.SortedByRankFieldResult;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewEditModel;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectListResponse;
import com.atlassian.greenhopper.web.rapid.view.SavedFilterEntry;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewFilterHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProjectRoleService projectRoleService;
    @Autowired
    private UserManager userManager;
    @Autowired
    private ShareTypeFactory shareTypeFactory;
    @Autowired
    private SearchService searchService;
    @Autowired
    private UserFormats userFormats;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    @Autowired
    private RapidViewProjectHelper rapidViewProjectHelper;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private JiraAuthenticationContext authContext;
    @Autowired
    private ShareManager shareManager;
    private final Supplier<Comparator<SharePermission>> permissionComparator = Suppliers.memoize((Supplier)new Supplier<Comparator<SharePermission>>(){

        public Comparator<SharePermission> get() {
            return RapidViewFilterHelper.this.shareTypeFactory.getPermissionComparator();
        }
    });
    private final Supplier<UserFormatter> profileLinkFormat = Suppliers.memoize((Supplier)new Supplier<UserFormatter>(){

        public UserFormatter get() {
            return RapidViewFilterHelper.this.userFormats.formatter("profileLink");
        }
    });

    public ServiceOutcome<List<SavedFilterEntry>> searchSavedFiltersByQuery(ApplicationUser user, String query) {
        ServiceOutcome<List<SearchRequest>> savedFilters = this.savedFilterService.findSavedFilters(user, query);
        if (!savedFilters.isValid()) {
            return ServiceOutcomeImpl.error(savedFilters);
        }
        return this.buildSavedFilterEntries(user, savedFilters.getValue());
    }

    public ServiceOutcome<SavedFilterEntry> setOrderByRank(ApplicationUser user, Long rapidViewId) {
        ServiceOutcome<RapidView> view = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!view.isValid()) {
            return ServiceOutcomeImpl.error(view);
        }
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, view.get().getSavedFilterId());
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        ServiceOutcome<SearchRequest> updatedFilter = this.savedFilterService.setOrderByRank(user, savedFilter.getValue());
        if (!updatedFilter.isValid()) {
            return ServiceOutcomeImpl.error(updatedFilter);
        }
        return ServiceOutcomeImpl.ok(this.buildSavedFilterEntry(user, updatedFilter.getValue()));
    }

    public ServiceOutcome<SavedFilterEntry> getRapidViewFilterModel(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        return ServiceOutcomeImpl.ok(this.buildSavedFilterEntry(user, savedFilter.getValue()));
    }

    public ServiceOutcome<List<SavedFilterEntry>> buildSavedFilterEntries(ApplicationUser user, List<SearchRequest> savedFilters) {
        ArrayList<SavedFilterEntry> entries = new ArrayList<SavedFilterEntry>();
        for (SearchRequest savedFilter : savedFilters) {
            entries.add(this.buildSavedFilterEntry(user, savedFilter));
        }
        return ServiceOutcomeImpl.ok(entries);
    }

    public SavedFilterEntry buildSavedFilterEntry(ApplicationUser user, SearchRequest savedFilter) {
        ServiceOutcome<RapidViewProjectListResponse> projectsInBoard;
        SavedFilterEntry entry = new SavedFilterEntry();
        entry.id = savedFilter.getId();
        entry.name = savedFilter.getName();
        entry.query = this.searchService.getJqlString(savedFilter.getQuery());
        entry.canEdit = this.shareManager.isSharedWith(user, (SharedEntity)savedFilter, (ShareRight)ShareRights.VIEW_EDIT);
        ServiceOutcome<SortedByRankFieldResult> sortedByRankFieldOutput = this.rankCustomFieldService.getSortedByRankField(savedFilter.getQuery());
        if (sortedByRankFieldOutput.isValid()) {
            SortedByRankFieldResult sortedByRankField = sortedByRankFieldOutput.get();
            ServiceOutcome<Void> outcome = this.rankCustomFieldService.validateRankFieldConfiguration(user, sortedByRankField.getCustomField());
            if (!outcome.isValid()) {
                entry.isOrderedByRank = false;
                entry.canBeFixed = false;
                entry.orderByWarnings = JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors(), user));
            } else if (sortedByRankField.getWarnings().hasErrors()) {
                entry.isOrderedByRank = false;
                entry.canBeFixed = sortedByRankField.isCanBeFixed();
                entry.orderByWarnings = JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(sortedByRankField.getWarnings(), user));
            } else {
                entry.isOrderedByRank = true;
            }
        } else {
            entry.isOrderedByRank = false;
            entry.canBeFixed = true;
        }
        entry.owner = RapidViewEditModel.Owner.create(savedFilter, this.userManager, (UserFormatter)this.profileLinkFormat.get());
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        for (SharePermission permission : this.getSortedSharePermissions(savedFilter)) {
            ShareType shareType = this.shareTypeFactory.getShareType(permission.getType());
            if (shareType == null) continue;
            String type = "gh.rapid.view.list.permission.restricted";
            if (shareType.getType().equals((Object)ShareType.Name.GLOBAL) || shareType.getType().equals((Object)ShareType.Name.AUTHENTICATED)) {
                type = "common.sharing.shared.template.everyone";
            }
            SavedFilterEntry.SavedFilterPermissionEntry permissionEntry = new SavedFilterEntry.SavedFilterPermissionEntry();
            permissionEntry.values.add(new SavedFilterEntry.SavedFilterPermissionValue(i18n.getText(type), shareType.getRenderer().renderPermission(permission, this.authContext)));
            entry.permissionEntries.add(permissionEntry);
        }
        if (this.isOptimizedBoardsLoadingDisabled() && (projectsInBoard = this.rapidViewProjectHelper.getRapidViewProjectList(user, savedFilter.getQuery())).isValid()) {
            entry.queryProjects = projectsInBoard.getValue();
        }
        return entry;
    }

    private Collection<SharePermission> getSortedSharePermissions(SearchRequest request) {
        ArrayList<SharePermission> permissions = new ArrayList<SharePermission>(request.getPermissions().getPermissionSet());
        permissions.sort((Comparator)this.permissionComparator.get());
        return permissions;
    }

    private boolean isOptimizedBoardsLoadingDisabled() {
        return this.featureManager.isEnabled((Feature)AgileDarkFeature.DISABLE_OPTIMIZED_BOARDS_LOADING);
    }
}

