/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.view.BoardAdminsModel;
import com.atlassian.greenhopper.web.rapid.view.BoardAdminsPickerModel;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditHelper;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditRequest;
import com.atlassian.greenhopper.web.rapid.view.EstimationHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewEditHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewEditModel;
import com.atlassian.greenhopper.web.rapid.view.RapidViewFilterHelper;
import com.atlassian.greenhopper.web.rapid.view.SavedFilterEntry;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="rapidviewconfig")
@Produces(value={"application/json"})
public class RapidViewEditResource
extends AbstractResource {
    private ColumnEditHelper columnEditHelper;
    private RapidViewEditHelper rapidViewEditHelper;
    private RapidViewFilterHelper rapidViewFilterHelper;
    private SwimlaneHelper swimlaneHelper;
    private RapidViewService rapidViewService;
    private EstimateStatisticService estimateStatisticService;
    private EstimationHelper estimationHelper;
    private TrackingStatisticService trackingStatisticService;
    private I18nFactoryService i18nFactoryService;
    private RapidViewHistoryService rapidViewHistoryService;

    public RapidViewEditResource(ColumnEditHelper columnEditHelper, RapidViewEditHelper rapidViewEditHelper, RapidViewFilterHelper rapidViewFilterHelper, SwimlaneHelper swimlaneHelper, RapidViewService rapidViewService, EstimateStatisticService estimateStatisticService, EstimationHelper estimationHelper, TrackingStatisticService trackingStatisticService, I18nFactoryService i18nFactoryService, RapidViewHistoryService rapidViewHistoryService) {
        this.columnEditHelper = columnEditHelper;
        this.rapidViewEditHelper = rapidViewEditHelper;
        this.rapidViewFilterHelper = rapidViewFilterHelper;
        this.swimlaneHelper = swimlaneHelper;
        this.rapidViewService = rapidViewService;
        this.estimateStatisticService = estimateStatisticService;
        this.estimationHelper = estimationHelper;
        this.trackingStatisticService = trackingStatisticService;
        this.i18nFactoryService = i18nFactoryService;
        this.rapidViewHistoryService = rapidViewHistoryService;
    }

    @POST
    @Path(value="/columns")
    @Consumes(value={"application/json"})
    public Response addNewColumn(final ColumnAddRequest columnAddRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidViewEditResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidViewEditResource.this.rapidViewService.getRapidView(user, columnAddRequest.rapidViewId);
                RapidViewEditResource.this.check(rapidView);
                if (columnAddRequest.alsoAddStatus) {
                    ServiceOutcome<Column> addColumnAndStatus = RapidViewEditResource.this.rapidViewEditHelper.addColumnAndStatus(user, rapidView.getValue(), columnAddRequest.name, columnAddRequest.statusCategoryId);
                    RapidViewEditResource.this.check(addColumnAndStatus);
                } else {
                    ServiceOutcome<Column> addColumn = RapidViewEditResource.this.rapidViewEditHelper.addColumn(user, rapidView.getValue(), columnAddRequest.name);
                    RapidViewEditResource.this.check(addColumn);
                }
                I18n2 i18n = RapidViewEditResource.this.i18nFactoryService.getI18n(user);
                ColumnEditRequest columnEditRequest = RapidViewEditResource.this.check(RapidViewEditResource.this.columnEditHelper.buildColumnEditModel(user, i18n, rapidView.getValue()));
                return RapidViewEditResource.this.createOkResponse(columnEditRequest);
            }
        });
    }

    @PUT
    @Path(value="/columns")
    @Consumes(value={"application/json"})
    public Response updateRapidList(final ColumnEditRequest columnEditRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ColumnEditRequest request = RapidViewEditResource.this.check(RapidViewEditResource.this.columnEditHelper.updateStatusMapping(RapidViewEditResource.this.getUser(), columnEditRequest));
                return RapidViewEditResource.this.createOkResponse(request);
            }
        });
    }

    @PUT
    @Path(value="/name")
    @Consumes(value={"application/json"})
    public Response updateRapidViewName(final RapidViewUpdateRequest updateRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<String> outcome = RapidViewEditResource.this.rapidViewEditHelper.updateRapidViewName(RapidViewEditResource.this.getUser(), updateRequest);
                RapidViewEditResource.this.check(outcome);
                ChangeNameResponse response = new ChangeNameResponse();
                response.name = outcome.getValue();
                return RapidViewEditResource.this.createOkResponse(response);
            }
        });
    }

    @GET
    @Path(value="/boardadminspicker")
    public Response getBoardAdminsPickerData(final @QueryParam(value="query") String query, final @QueryParam(value="maxResults") int maxResults) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                BoardAdminsPickerModel boardAdminsPickerModel = RapidViewEditResource.this.check(RapidViewEditResource.this.rapidViewEditHelper.getBoardAdminsPickerData(RapidViewEditResource.this.getUser(), query, maxResults));
                return RapidViewEditResource.this.createOkResponse(boardAdminsPickerModel);
            }
        });
    }

    @PUT
    @Path(value="/boardadmins")
    @Consumes(value={"application/json"})
    public Response updateRapidViewBoardAdmins(final RapidViewUpdateRequest updateRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                BoardAdminsModel boardAdminsModel = RapidViewEditResource.this.check(RapidViewEditResource.this.rapidViewEditHelper.updateBoardAdmins(RapidViewEditResource.this.getUser(), updateRequest));
                return RapidViewEditResource.this.createOkResponse(boardAdminsModel);
            }
        });
    }

    @PUT
    @Path(value="/filter")
    @Consumes(value={"application/json"})
    public Response updateRapidViewFilter(final RapidViewUpdateRequest updateRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<SavedFilterEntry> outcome = RapidViewEditResource.this.rapidViewEditHelper.updateRapidViewFilter(RapidViewEditResource.this.getUser(), updateRequest);
                RapidViewEditResource.this.check(outcome);
                return RapidViewEditResource.this.createOkResponse(outcome.getValue());
            }
        });
    }

    @PUT
    @Path(value="/showDaysInColumn")
    @Consumes(value={"application/json"})
    public Response updateShowDaysInColumn(final ShowDaysInColumnUpdateRequest updateRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RapidViewEditResource.this.check(RapidViewEditResource.this.rapidViewEditHelper.updateShowDaysInColumn(RapidViewEditResource.this.getUser(), updateRequest));
                return RapidViewEditResource.this.createNoContentResponse();
            }
        });
    }

    @PUT
    @Path(value="/oldDoneIssuesCutoff")
    @Consumes(value={"application/json"})
    public Response updateOldDoneIssuesCutoff(final OldDoneIssuesCutoffRequest updateRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RapidViewEditResource.this.check(RapidViewEditResource.this.rapidViewEditHelper.updateOldDoneIssuesCutoff(RapidViewEditResource.this.getUser(), updateRequest));
                return RapidViewEditResource.this.createNoContentResponse();
            }
        });
    }

    @PUT
    @Path(value="/showEpicAsPanel")
    @Consumes(value={"application/json"})
    public Response updateShowEpicAsPanel(ShowEpicAsPanelUpdateRequest updateRequest) {
        return this.response(() -> {
            this.checkResult(this.rapidViewEditHelper.updateShowEpicAsPanel(this.getUser(), updateRequest));
            return this.createNoContentResponse();
        });
    }

    @GET
    @AnonymousAllowed
    @Path(value="/editmodel")
    public Response getEditModel(final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidView> rapidView = RapidViewEditResource.this.rapidViewService.getRapidView(RapidViewEditResource.this.getUser(), rapidViewId);
                RapidViewEditResource.this.check(rapidView);
                ServiceOutcome<RapidViewEditModel> editModel = RapidViewEditResource.this.rapidViewEditHelper.getEditModel(RapidViewEditResource.this.getUser(), rapidView.getValue());
                RapidViewEditResource.this.check(editModel);
                RapidViewEditResource.this.rapidViewHistoryService.storeRapidView(RapidViewEditResource.this.getUser(), rapidView.getValue());
                return RapidViewEditResource.this.createOkResponse(editModel.getValue());
            }
        });
    }

    @PUT
    @Path(value="/orderbyrank")
    @Consumes(value={"application/json"})
    public Response setFilterOrderByRank(final RapidViewEditModel editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<SavedFilterEntry> outcome = RapidViewEditResource.this.rapidViewFilterHelper.setOrderByRank(RapidViewEditResource.this.getUser(), editModel.id);
                RapidViewEditResource.this.check(outcome);
                return RapidViewEditResource.this.createOkResponse(outcome.getValue());
            }
        });
    }

    @PUT
    @Path(value="/swimlaneStrategy")
    @Consumes(value={"application/json"})
    public Response setSwimlaneStrategy(final SwimlaneStrategyUpdateRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidView> updated = RapidViewEditResource.this.swimlaneHelper.updateSwimlaneStrategy(RapidViewEditResource.this.getUser(), request.id, request.swimlaneStrategyId);
                RapidViewEditResource.this.check(updated);
                return RapidViewEditResource.this.createNoContentResponse();
            }
        });
    }

    @GET
    @Path(value="/estimation")
    @Consumes(value={"application/json"})
    public Response getEstimationConfig(final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidView> rapidView = RapidViewEditResource.this.rapidViewService.getRapidView(RapidViewEditResource.this.getUser(), rapidViewId);
                RapidViewEditResource.this.check(rapidView);
                return RapidViewEditResource.this.createOkResponse(RapidViewEditResource.this.estimationHelper.buildModel(RapidViewEditResource.this.getUser(), rapidView.getValue()));
            }
        });
    }

    @PUT
    @Path(value="/estimation")
    @Consumes(value={"application/json"})
    public Response setEstimationConfig(final EstimationConfigRequest estimationConfigRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidViewEditResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidViewEditResource.this.rapidViewService.getRapidView(user, estimationConfigRequest.rapidViewId);
                RapidViewEditResource.this.check(rapidView);
                ServiceOutcome<StatisticsFieldConfig> estimateStatisticConfig = RapidViewEditResource.this.estimationHelper.getEstimateStatisticConfig(estimationConfigRequest.estimateStatisticId);
                RapidViewEditResource.this.check(estimateStatisticConfig);
                ServiceOutcome<StatisticsFieldConfig> trackingStatisticConfig = RapidViewEditResource.this.estimationHelper.getTrackingStatisticConfig(estimationConfigRequest.trackingStatisticId);
                RapidViewEditResource.this.check(trackingStatisticConfig);
                ServiceOutcome<Void> updateOutcome = RapidViewEditResource.this.estimateStatisticService.updateEstimateStatistic(user, rapidView.getValue(), estimateStatisticConfig.getValue());
                RapidViewEditResource.this.check(updateOutcome);
                updateOutcome = RapidViewEditResource.this.trackingStatisticService.updateTrackingStatistic(user, rapidView.getValue(), trackingStatisticConfig.getValue());
                RapidViewEditResource.this.check(updateOutcome);
                return RapidViewEditResource.this.createOkResponse(RapidViewEditResource.this.estimationHelper.buildModel(user, rapidView.getValue()));
            }
        });
    }

    @XmlRootElement
    static class ChangeNameResponse
    extends RestTemplate {
        @XmlElement
        String name;

        ChangeNameResponse() {
        }
    }

    @XmlRootElement
    static class ShowEpicAsPanelUpdateRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        boolean showEpicAsPanel;

        ShowEpicAsPanelUpdateRequest() {
        }
    }

    @XmlRootElement
    static class OldDoneIssuesCutoffRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        String oldDoneIssuesCutoff;

        OldDoneIssuesCutoffRequest() {
        }
    }

    @XmlRootElement
    static class ShowDaysInColumnUpdateRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        boolean showDaysInColumn;

        ShowDaysInColumnUpdateRequest() {
        }
    }

    @XmlRootElement
    static class ColumnAddRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        String name;
        @XmlElement
        boolean alsoAddStatus;
        @XmlElement
        Long statusCategoryId;

        ColumnAddRequest() {
        }
    }

    @XmlRootElement
    static class EstimationConfigRequest
    extends RestTemplate {
        @XmlElement
        Long rapidViewId;
        @XmlElement
        String estimateStatisticId;
        @XmlElement
        String trackingStatisticId;

        EstimationConfigRequest() {
        }
    }

    @XmlRootElement
    static class SwimlaneStrategyUpdateRequest
    extends RestTemplate {
        @XmlElement
        Long id;
        @XmlElement
        String swimlaneStrategyId;

        SwimlaneStrategyUpdateRequest() {
        }
    }

    @XmlRootElement
    static class RapidViewUpdateRequest
    extends RestTemplate {
        @XmlElement
        Long id;
        @XmlElement
        String name;
        @XmlElement
        BoardAdmins boardAdmins;
        @XmlElement
        Long savedFilterId;

        RapidViewUpdateRequest() {
        }

        @XmlRootElement
        public static class BoardAdmins {
            @XmlElement
            List<String> userKeys;
            @XmlElement
            List<String> groupKeys;
        }
    }
}

