/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.greenhopper.features.AgileDarkFeature;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.jira.JiraServiceContextFactory;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminListToMapMapper;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminValidator;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.RapidBoardViewModelFactory;
import com.atlassian.greenhopper.web.rapid.view.BoardAdminsModel;
import com.atlassian.greenhopper.web.rapid.view.BoardAdminsPickerModel;
import com.atlassian.greenhopper.web.rapid.view.CardColorHelper;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditHelper;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditRequest;
import com.atlassian.greenhopper.web.rapid.view.EstimationHelper;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewEditModel;
import com.atlassian.greenhopper.web.rapid.view.RapidViewEditResource;
import com.atlassian.greenhopper.web.rapid.view.RapidViewFilterHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewProjectListResponse;
import com.atlassian.greenhopper.web.rapid.view.SavedFilterEntry;
import com.atlassian.greenhopper.web.rapid.view.SubqueryEditModel;
import com.atlassian.greenhopper.web.rapid.view.SubqueryHelper;
import com.atlassian.greenhopper.web.rapid.view.SwimlaneHelper;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutFieldConfigModel;
import com.atlassian.greenhopper.web.rapid.view.cardlayout.CardLayoutHelper;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldConfigModel;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldHelper;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WorkingDaysConfigModel;
import com.atlassian.greenhopper.web.rapid.view.workingdays.WorkingDaysHelper;
import com.atlassian.greenhopper.web.rapid.workflow.WorkflowHelper;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewEditHelper {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private ColumnEditHelper rapidListEditHelper;
    @Autowired
    private RapidViewFilterHelper rapidViewFilterHelper;
    @Autowired
    private SwimlaneHelper swimlanesHelper;
    @Autowired
    private CardColorHelper cardColorHelper;
    @Autowired
    private DetailViewFieldHelper detailViewFieldHelper;
    @Autowired
    private QuickFilterHelper quickFilterHelper;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private SubqueryHelper subqueryHelper;
    @Autowired
    private EstimationHelper estimationHelper;
    @Autowired
    private AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    @Autowired
    private JiraAuthenticationContext authContext;
    @Autowired
    private WorkflowHelper workflowHelper;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private BoardAdminService boardAdminService;
    @Autowired
    private WorkingDaysHelper workingDaysHelper;
    @Autowired
    private RapidBoardViewModelFactory rapidBoardViewModelFactory;
    @Autowired
    private UserPickerSearchService userPickerSearchService;
    @Autowired
    private GroupPickerSearchService groupPickerSearchService;
    @Autowired
    private JiraServiceContextFactory jiraServiceContextFactory;
    @Autowired
    private CardLayoutHelper cardLayoutHelper;
    @Autowired
    private RapidViewProjectHelper rapidViewProjectHelper;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private BoardAdminValidator boardAdminValidator;
    @Autowired
    BoardAdminListToMapMapper boardAdminListToMapMapper;

    public ServiceOutcome<RapidViewEditModel> getEditModel(ApplicationUser user, RapidView view) {
        ServiceOutcome<SubqueryEditModel> subqueryEditModel;
        RapidViewEditModel model = new RapidViewEditModel();
        model.rapidView = view;
        model.id = view.getId();
        model.name = view.getName();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, view);
        model.warnBeforeEditingOwner = !this.rapidViewPermissionService.isAdmin(user, view);
        model.boardAdmins = this.createBoardAdmins(this.boardAdminService.getBoardAdmins(view));
        model.isSprintSupportEnabled = view.isSprintSupportEnabled();
        model.canUseBoardAdminsPicker = this.userPickerSearchService.canPerformAjaxSearch(user);
        model.showDaysInColumn = view.showDaysInColumn();
        model.isKanPlanEnabled = this.columnService.isKanPlanEnabledForBoard(view);
        model.showEpicAsPanel = view.getShowEpicsAsPanel().isEnabled();
        model.isOldDoneIssuesCutoffConfigurable = !view.isSprintSupportEnabled() && this.featureManager.isEnabled(SoftwareFeatureFlags.KANBAN_HIDE_OLD_DONE_ISSUES);
        model.oldDoneIssuesCutoff = view.getOldDoneIssuesCutoff().getValue();
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        model.oldDoneIssuesCutoffOptions = this.getOldDoneIssuesCutoffOptions(i18n);
        ServiceOutcome<ColumnEditRequest> requestOutcome = this.rapidListEditHelper.buildColumnEditModel(user, i18n, view);
        if (requestOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(requestOutcome);
        }
        model.rapidListConfig = requestOutcome.getValue();
        model.swimlanesConfig = this.swimlanesHelper.buildSwimlaneEditModel(user, view);
        model.quickFilterConfig = this.quickFilterHelper.buildQuickFilterEditModel(user, view);
        ServiceOutcome<SavedFilterEntry> rapidViewFilterModel = this.rapidViewFilterHelper.getRapidViewFilterModel(user, view);
        if (rapidViewFilterModel.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewFilterModel);
        }
        model.filterConfig = rapidViewFilterModel.getValue();
        if (this.isOptimizedBoardsLoadingEnabled()) {
            ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, view.getSavedFilterId());
            if (!savedFilter.isValid()) {
                return ServiceOutcomeImpl.error(savedFilter);
            }
            ServiceOutcome<RapidViewProjectListResponse> projectsInBoard = this.rapidViewProjectHelper.getRapidViewProjectList(user, savedFilter.getValue().getQuery());
            if (projectsInBoard.isValid()) {
                model.filterConfig.queryProjects = projectsInBoard.getValue();
            }
        }
        if (!(subqueryEditModel = this.subqueryHelper.buildSubqueryEditModel(user, view)).isValid()) {
            return ServiceOutcomeImpl.error(subqueryEditModel);
        }
        model.subqueryConfig = subqueryEditModel.getValue();
        model.estimationStatisticConfig = this.estimationHelper.buildModel(user, view);
        model.JQLAutoComplete = this.getJQLAutoCompleteData(user);
        model.cardColorConfig = this.cardColorHelper.getBaseCardColorEditModel(user, view);
        ServiceOutcome<WorkingDaysConfigModel> workDaysConfigModel = this.workingDaysHelper.getWorkDaysConfigModel(user, view);
        if (!workDaysConfigModel.isValid()) {
            return ServiceOutcomeImpl.error(workDaysConfigModel);
        }
        model.workingDaysConfig = workDaysConfigModel.getValue();
        ServiceOutcome<DetailViewFieldConfigModel> detailViewFieldConfig = this.detailViewFieldHelper.getDetailViewFieldConfig(user, view);
        if (!detailViewFieldConfig.isValid()) {
            return ServiceOutcomeImpl.error(detailViewFieldConfig);
        }
        model.detailViewFieldConfig = detailViewFieldConfig.getValue();
        model.globalConfig = this.rapidBoardViewModelFactory.buildRapidGlobalConfig(user);
        ServiceOutcome<CardLayoutFieldConfigModel> cardLayoutFieldConfig = this.cardLayoutHelper.getCardLayoutFieldConfig(user, view);
        if (!cardLayoutFieldConfig.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFieldConfig);
        }
        model.cardLayoutConfig = cardLayoutFieldConfig.getValue();
        return ServiceOutcomeImpl.ok(model);
    }

    private BoardAdminsModel createBoardAdmins(List<BoardAdmin> boardAdmins) {
        List<BoardAdminsModel.BoardAdmin> groups = boardAdmins.stream().filter(boardAdmin -> boardAdmin.getType() == BoardAdmin.Type.GROUP).map(BoardAdmin::getKey).map(BoardAdminsModel.BoardAdmin::create).collect(Collectors.toList());
        List<BoardAdminsModel.BoardAdmin> users = boardAdmins.stream().filter(boardAdmin -> boardAdmin.getType() == BoardAdmin.Type.USER).map(boardAdmin -> {
            ApplicationUser user = ApplicationUsers.byKey((String)boardAdmin.getKey());
            String displayName = Optional.ofNullable(user).map(appUser -> String.format("%s (%s)", appUser.getDisplayName(), appUser.getName())).orElse(boardAdmin.getKey());
            return BoardAdminsModel.BoardAdmin.create(boardAdmin.getKey(), displayName);
        }).collect(Collectors.toList());
        return BoardAdminsModel.create(users, groups);
    }

    private RapidViewEditModel.JQLAutoCompleteData getJQLAutoCompleteData(ApplicationUser user) {
        try {
            RapidViewEditModel.JQLAutoCompleteData jqlAutoCompleteData = new RapidViewEditModel.JQLAutoCompleteData();
            jqlAutoCompleteData.jqlFields = this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(user, this.getLocale());
            jqlAutoCompleteData.jqlFunctionNames = this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(user, this.getLocale());
            jqlAutoCompleteData.jqlReservedWords = this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
            return jqlAutoCompleteData;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private List<RapidViewEditModel.OldDoneIssuesCutoffOption> getOldDoneIssuesCutoffOptions(I18n2 i18n) {
        return Stream.of(RapidView.OldDoneIssuesCutoff.values()).map(val -> {
            String label;
            switch (val) {
                case ONE_WEEK: {
                    label = i18n.getText("gh.rapid.config.filter.hide.old.done.cutoff.1w");
                    break;
                }
                case TWO_WEEKS: {
                    label = i18n.getText("gh.rapid.config.filter.hide.old.done.cutoff.2w");
                    break;
                }
                case FOUR_WEEKS: {
                    label = i18n.getText("gh.rapid.config.filter.hide.old.done.cutoff.4w");
                    break;
                }
                default: {
                    label = i18n.getText("gh.rapid.config.filter.hide.old.done.cutoff.none");
                }
            }
            return new RapidViewEditModel.OldDoneIssuesCutoffOption(val.getValue(), label);
        }).collect(Collectors.toList());
    }

    private Locale getLocale() {
        return this.authContext.getLocale();
    }

    public ServiceOutcome<BoardAdminsPickerModel> getBoardAdminsPickerData(ApplicationUser user, String query, int maxResults) {
        JiraServiceContext jiraServiceContext = this.jiraServiceContextFactory.buildUserContext(user);
        if (maxResults == 0) {
            maxResults = 15;
        }
        if (!this.userPickerSearchService.canPerformAjaxSearch(user)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.configuration.board.admin.picker.permission.error", new Object[0]);
        }
        List<ApplicationUser> userResults = this.userPickerSearchService.findUsersAllowEmptyQuery(jiraServiceContext, query);
        List<Group> groupResults = this.groupPickerSearchService.findGroups(query);
        int maxNumUsers = maxResults < userResults.size() ? maxResults : userResults.size();
        int maxNumGroups = maxResults < groupResults.size() ? maxResults : groupResults.size();
        userResults = userResults.subList(0, maxNumUsers);
        groupResults = groupResults.subList(0, maxNumGroups);
        return ServiceOutcomeImpl.ok(BoardAdminsPickerModel.create(userResults, groupResults));
    }

    public ServiceOutcome<String> updateRapidViewName(ApplicationUser user, RapidViewEditResource.RapidViewUpdateRequest editModel) {
        ServiceOutcome<RapidView> view = this.rapidViewService.getRapidView(user, editModel.id);
        if (view.isInvalid()) {
            return ServiceOutcomeImpl.error(view);
        }
        ServiceResult updateOutcome = this.rapidViewService.update(user, RapidView.builder(view.getValue()).name(editModel.name).build());
        if (updateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        return ServiceOutcomeImpl.ok(editModel.name);
    }

    public ServiceOutcome<Boolean> updateShowDaysInColumn(ApplicationUser user, RapidViewEditResource.ShowDaysInColumnUpdateRequest updateRequest) {
        RapidView updatedRapidView;
        ServiceResult updateOutcome;
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, updateRequest.rapidViewId);
        if (rapidViewOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        RapidView existingRapidView = rapidViewOutcome.getValue();
        if (updateRequest.showDaysInColumn != existingRapidView.showDaysInColumn() && (updateOutcome = this.rapidViewService.update(user, updatedRapidView = RapidView.builder(existingRapidView).showDaysInColumn(updateRequest.showDaysInColumn).build())).isInvalid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        return ServiceOutcomeImpl.ok(updateRequest.showDaysInColumn);
    }

    public ServiceOutcome<String> updateOldDoneIssuesCutoff(ApplicationUser user, RapidViewEditResource.OldDoneIssuesCutoffRequest updateRequest) {
        RapidView updatedRapidView;
        ServiceResult updateOutcome;
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, updateRequest.rapidViewId);
        if (rapidViewOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        RapidView existingRapidView = rapidViewOutcome.getValue();
        Optional<RapidView.OldDoneIssuesCutoff> oldDoneIssuesCutoff = RapidView.OldDoneIssuesCutoff.fromValue(updateRequest.oldDoneIssuesCutoff);
        if (!oldDoneIssuesCutoff.isPresent()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.filter.hide.old.done.cutoff.invalid.error", new Object[0]);
        }
        if (!existingRapidView.getOldDoneIssuesCutoff().getValue().equals(updateRequest.oldDoneIssuesCutoff) && (updateOutcome = this.rapidViewService.update(user, updatedRapidView = RapidView.builder(existingRapidView).oldDoneIssuesCutoff(oldDoneIssuesCutoff.get()).build())).isInvalid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        return ServiceOutcomeImpl.ok(updateRequest.oldDoneIssuesCutoff);
    }

    public ServiceResult updateShowEpicAsPanel(ApplicationUser user, RapidViewEditResource.ShowEpicAsPanelUpdateRequest updateRequest) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(user, updateRequest.rapidViewId));
            if (updateRequest.showEpicAsPanel != rapidView.getShowEpicsAsPanel().isEnabled()) {
                RapidView updatedRapidView = RapidView.builder(rapidView).showEpicAsPanel(ShowEpics.getValueFrom(updateRequest.showEpicAsPanel)).build();
                ServiceOutcomeHelper.validate(this.rapidViewService.update(user, updatedRapidView));
            }
        });
    }

    public ServiceOutcome<BoardAdminsModel> updateBoardAdmins(ApplicationUser user, RapidViewEditResource.RapidViewUpdateRequest editModel) {
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, editModel.id);
        if (rapidViewOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        ServiceOutcome<List<BoardAdmin>> newBoardAdminsListOutcome = this.resolveNewBoardAdminList(editModel);
        if (newBoardAdminsListOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(newBoardAdminsListOutcome);
        }
        ServiceOutcome<List<BoardAdmin>> result = this.boardAdminService.updateBoardAdmins(rapidViewOutcome.getValue(), user, newBoardAdminsListOutcome.getValue());
        if (result.isInvalid()) {
            return ServiceOutcomeImpl.error(result);
        }
        return ServiceOutcomeImpl.ok(this.createBoardAdmins(result.getValue()));
    }

    @VisibleForTesting
    protected ServiceOutcome<List<BoardAdmin>> resolveNewBoardAdminList(RapidViewEditResource.RapidViewUpdateRequest editModel) {
        if (editModel.boardAdmins == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admins", new Object[0]);
        }
        if (editModel.boardAdmins.userKeys == null || editModel.boardAdmins.groupKeys == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admins", new Object[0]);
        }
        if (editModel.boardAdmins.userKeys.isEmpty() && editModel.boardAdmins.groupKeys.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admins.empty", new Object[0]);
        }
        editModel.boardAdmins.userKeys = ImmutableSet.copyOf(editModel.boardAdmins.userKeys).asList();
        editModel.boardAdmins.groupKeys = ImmutableSet.copyOf(editModel.boardAdmins.groupKeys).asList();
        RapidView rapidView = RapidView.builder().id(editModel.id).build();
        Map<BoardAdmin.Type, Set<String>> existingAdmins = this.boardAdminListToMapMapper.apply(this.boardAdminService.getBoardAdmins(rapidView));
        ArrayList<BoardAdmin> newBoardAdmins = new ArrayList<BoardAdmin>();
        for (String userKey : editModel.boardAdmins.userKeys) {
            if (!this.boardAdminValidator.isBoardAdminValid(existingAdmins, BoardAdmin.Type.USER, userKey)) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admin.user", userKey);
            }
            newBoardAdmins.add(BoardAdmin.builder().key(userKey).type(BoardAdmin.Type.USER).build());
        }
        for (String groupKey : editModel.boardAdmins.groupKeys) {
            if (!this.boardAdminValidator.isBoardAdminValid(existingAdmins, BoardAdmin.Type.GROUP, groupKey)) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.invalid.board.admin.group", groupKey);
            }
            newBoardAdmins.add(BoardAdmin.builder().key(groupKey).type(BoardAdmin.Type.GROUP).build());
        }
        return ServiceOutcomeImpl.ok(newBoardAdmins);
    }

    public ServiceOutcome<SavedFilterEntry> updateRapidViewFilter(ApplicationUser user, RapidViewEditResource.RapidViewUpdateRequest updateRequest) {
        ServiceOutcome<RapidViewProjectListResponse> projectsInBoard;
        ServiceOutcome<RapidView> view = this.rapidViewService.getRapidView(user, updateRequest.id);
        if (!view.isValid()) {
            return ServiceOutcomeImpl.error(view);
        }
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, updateRequest.savedFilterId);
        if (!savedFilter.isValid()) {
            return ServiceOutcomeImpl.error(savedFilter);
        }
        ServiceResult updateOutcome = this.rapidViewService.update(user, RapidView.builder(view.getValue()).savedFilterId(savedFilter.getValue().getId()).build());
        if (!updateOutcome.isValid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        SavedFilterEntry savedFilterEntry = this.rapidViewFilterHelper.buildSavedFilterEntry(user, savedFilter.getValue());
        if (this.isOptimizedBoardsLoadingEnabled() && (projectsInBoard = this.rapidViewProjectHelper.getRapidViewProjectList(user, savedFilter.getValue().getQuery())).isValid()) {
            savedFilterEntry.queryProjects = projectsInBoard.getValue();
        }
        return ServiceOutcomeImpl.ok(savedFilterEntry);
    }

    public ServiceOutcome<Column> addColumnAndStatus(ApplicationUser user, RapidView rapidView, String columnAndStatusName, Long statusCategoryId) {
        if (StringUtils.isBlank((CharSequence)columnAndStatusName)) {
            return ServiceOutcomeImpl.error("name", ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.add.column.error.no.name", new Object[0]);
        }
        ServiceOutcome<Status> addStatus = this.workflowHelper.addStatusToGreenHopperSimplifiedWorkflow(user, rapidView, columnAndStatusName, statusCategoryId);
        if (!addStatus.isValid()) {
            return ServiceOutcomeImpl.error(addStatus);
        }
        Set<Status> mappedStatuses = this.columnService.getMappedStatuses(rapidView);
        Column newColumn = mappedStatuses.contains(addStatus.getValue()) ? Column.builder().name(columnAndStatusName).build() : Column.builder().name(columnAndStatusName).statusId(addStatus.getValue().getId()).build();
        return this.columnService.addColumn(user, rapidView, newColumn);
    }

    public ServiceOutcome<Column> addColumn(ApplicationUser user, RapidView rapidView, String columnName) {
        Column newColumn = Column.builder().name(columnName).build();
        return this.columnService.addColumn(user, rapidView, newColumn);
    }

    private boolean isOptimizedBoardsLoadingEnabled() {
        return !this.featureManager.isEnabled((Feature)AgileDarkFeature.DISABLE_OPTIMIZED_BOARDS_LOADING);
    }
}

