/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterEntry;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="quickfilters")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class QuickFilterResource
extends AbstractResource {
    private final QuickFilterHelper quickFilterHelper;

    public QuickFilterResource(QuickFilterHelper quickFilterHelper) {
        this.quickFilterHelper = quickFilterHelper;
    }

    @AnonymousAllowed
    @GET
    @Path(value="{rapidViewId}/{id}")
    public Response getQuickFilter(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                QuickFilterEntry quickFilterModel = QuickFilterResource.this.quickFilterHelper.getQuickFilter(QuickFilterResource.this.getUser(), rapidViewId, id);
                return QuickFilterResource.this.createOkResponse(quickFilterModel);
            }
        });
    }

    @PUT
    @Path(value="{rapidViewId}/{id}")
    public Response updateQuickFilter(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final QuickFilterEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                QuickFilterEntry quickFilterModel = QuickFilterResource.this.quickFilterHelper.updateQuickFilter(QuickFilterResource.this.getUser(), rapidViewId, id, editModel);
                return QuickFilterResource.this.createOkResponse(quickFilterModel);
            }
        });
    }

    @POST
    @Path(value="{rapidViewId}")
    public Response addQuickFilter(final @PathParam(value="rapidViewId") Long rapidViewId, final QuickFilterEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                QuickFilterEntry quickFilterModel = QuickFilterResource.this.quickFilterHelper.addQuickFilter(QuickFilterResource.this.getUser(), rapidViewId, editModel);
                return QuickFilterResource.this.createOkResponse(quickFilterModel);
            }
        });
    }

    @DELETE
    @Path(value="{rapidViewId}/{id}")
    public Response deleteQuickFilter(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                QuickFilterResource.this.quickFilterHelper.deleteQuickFilter(QuickFilterResource.this.getUser(), rapidViewId, id);
                return QuickFilterResource.this.createNoContentResponse();
            }
        });
    }

    @POST
    @Path(value="{rapidViewId}/{id}/move")
    public Response moveQuickFilter(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final EntryMoveModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                QuickFilterResource.this.quickFilterHelper.moveQuickFilter(QuickFilterResource.this.getUser(), rapidViewId, id, model);
                return QuickFilterResource.this.createNoContentResponse();
            }
        });
    }
}

