/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotFoundWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterEditModel;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterEntry;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuickFilterHelper {
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private QuickFilterService quickFilterService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;

    public QuickFilterEntry updateQuickFilter(ApplicationUser user, Long rapidViewId, Long quickFilterId, QuickFilterEntry editModel) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        ErrorCollection errors = new ErrorCollection();
        QuickFilter existing = this.quickFilterService.get(user, rapidView.getValue(), quickFilterId, errors);
        ErrorCollections.checkErrors(errors, i18n);
        QuickFilter quickFilter = QuickFilter.builder(existing).name(StringUtils.defaultString((String)editModel.name, (String)existing.getName())).query(StringUtils.defaultString((String)editModel.query, (String)existing.getQuery())).description(StringUtils.defaultString((String)editModel.description, (String)existing.getDescription())).build();
        QuickFilter updatedQuickFilter = this.quickFilterService.update(user, rapidView.getValue(), quickFilter, errors);
        ErrorCollections.checkErrors(errors, i18n);
        boolean canEdit = true;
        return this.toQuickFilterEntry(user, updatedQuickFilter, canEdit, i18n);
    }

    public QuickFilterEntry addQuickFilter(ApplicationUser user, Long rapidViewId, QuickFilterEntry editModel) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        QuickFilter quickFilter = QuickFilter.builder().name(StringUtils.defaultString((String)editModel.name)).query(StringUtils.defaultString((String)editModel.query)).description(StringUtils.defaultString((String)editModel.description)).build();
        ServiceOutcome<QuickFilter> createdQuickFilter = this.quickFilterService.add(user, rapidView.getValue(), quickFilter);
        if (!createdQuickFilter.isValid()) {
            ErrorCollections.checkErrors(createdQuickFilter.getErrors(), i18n);
        }
        boolean canEdit = true;
        return this.toQuickFilterEntry(user, createdQuickFilter.getValue(), canEdit, i18n);
    }

    public QuickFilterEntry getQuickFilter(ApplicationUser user, Long rapidViewId, Long quickFilterId) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            JiraCopiedRestErrorCollection restErrorCollection = JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            throw new JiraCopiedNotFoundWebException(restErrorCollection);
        }
        ErrorCollection errors = new ErrorCollection();
        QuickFilter quickFilter = this.quickFilterService.get(user, rapidView.getValue(), quickFilterId, errors);
        if (errors.hasErrors()) {
            JiraCopiedRestErrorCollection restErrorCollection = JiraCopiedRestErrorCollection.of(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            throw new JiraCopiedNotFoundWebException(restErrorCollection);
        }
        boolean canEdit = this.rapidViewPermissionService.canEdit(user, rapidView.getValue());
        return this.toQuickFilterEntry(user, quickFilter, canEdit, i18n);
    }

    public void deleteQuickFilter(ApplicationUser user, Long rapidViewId, Long quickFilterId) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        ErrorCollection errors = new ErrorCollection();
        this.quickFilterService.delete(user, rapidView.getValue(), quickFilterId, errors);
        ErrorCollections.checkErrors(errors, i18n);
    }

    public void moveQuickFilter(ApplicationUser user, Long rapidViewId, Long quickFilterId, EntryMoveModel moveModel) {
        ServiceOutcome<Void> outcome;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
        }
        if (!(outcome = this.quickFilterService.moveAfter(user, rapidView.getValue(), quickFilterId, moveModel.getMoveToId())).isValid()) {
            ErrorCollections.checkErrors(outcome.getErrors(), i18n);
        }
    }

    public QuickFilterEditModel buildQuickFilterEditModel(ApplicationUser user, RapidView rapidView) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        QuickFilterEditModel model = new QuickFilterEditModel();
        model.rapidView = rapidView;
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        model.quickFilters = new ArrayList<QuickFilterEntry>();
        for (QuickFilter quickFilter : this.quickFilterService.loadQuickFilters(rapidView)) {
            model.quickFilters.add(this.toQuickFilterEntry(user, quickFilter, model.canEdit, i18n));
        }
        return model;
    }

    private QuickFilterEntry toQuickFilterEntry(ApplicationUser user, QuickFilter quickFilter, boolean canEdit, I18n2 i18n) {
        QuickFilterEntry quickFilterEntry = new QuickFilterEntry();
        quickFilterEntry.id = quickFilter.getId();
        quickFilterEntry.name = i18n.getText(quickFilter.getName());
        quickFilterEntry.query = this.jqlHelper.getSanitisedQueryString(user, quickFilter.getQuery());
        quickFilterEntry.description = i18n.getText(quickFilter.getDescription());
        quickFilterEntry.canEdit = canEdit;
        return quickFilterEntry;
    }
}

