/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.KanbanBacklogColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.UserConfigurationService;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditHelper;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditRequest;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="xboard/plan/kanban")
@Produces(value={"application/json"})
public class KanbanPlanModeResource
extends AbstractResource {
    private final UserConfigurationService userConfigurationService;
    private final RapidViewService rapidViewService;
    private final KanbanBacklogColumnService kanbanBacklogColumnService;
    private final I18nFactoryService i18nFactoryService;
    private final ColumnEditHelper columnEditHelper;
    private final ColumnService columnService;
    private final IssueTransitionAndRankService issueTransitionAndRankService;
    private final RapidViewPermissionService rapidViewPermissionService;
    private final ResponseFactory responseFactory;

    public KanbanPlanModeResource(UserConfigurationService userConfigurationService, RapidViewService rapidViewService, KanbanBacklogColumnService kanbanBacklogColumnService, I18nFactoryService i18nFactoryService, ColumnEditHelper columnEditHelper, ColumnService columnService, IssueTransitionAndRankService issueTransitionAndRankService, RapidViewPermissionService rapidViewPermissionService, ResponseFactory responseFactory) {
        this.userConfigurationService = userConfigurationService;
        this.rapidViewService = rapidViewService;
        this.kanbanBacklogColumnService = kanbanBacklogColumnService;
        this.i18nFactoryService = i18nFactoryService;
        this.columnEditHelper = columnEditHelper;
        this.columnService = columnService;
        this.issueTransitionAndRankService = issueTransitionAndRankService;
        this.rapidViewPermissionService = rapidViewPermissionService;
        this.responseFactory = responseFactory;
    }

    @GET
    @Path(value="acknowledgeDisplay")
    public Response getAcknowledgeDisplay() {
        return this.response(() -> this.createOkResponse(this.userConfigurationService.getKanPlanAcknowledgeDisplay(this.getUser())));
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="closeAcknowledge")
    public void closeAcknowledge(@QueryParam(value="mode") String mode) {
        this.userConfigurationService.setClosedKanPlanAcknowledge(mode, this.getUser());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="closeEpicsOnboardingDialog")
    public void closeEpicsOnboardingDialog(@QueryParam(value="mode") String mode) {
        this.userConfigurationService.setEpicsOnboardingDialogAsClosed(mode, this.getUser());
    }

    @POST
    @Path(value="{rapidViewId}/disbandBacklogColumn")
    public Response disbandBacklogColumn(@PathParam(value="rapidViewId") Long rapidViewId) {
        return this.response(() -> {
            RapidView rapidView = this.getRapidView(rapidViewId);
            ServiceOutcome<List<Column>> disbandBacklogColumnOutcome = this.disbandBacklogColumnIfExists(this.getUser(), rapidView);
            DisableKanbanBacklogResponse resp = new DisableKanbanBacklogResponse();
            if (disbandBacklogColumnOutcome.isValid()) {
                resp.isSuccessful = true;
                resp.columns = this.toMappedColumn(rapidView, disbandBacklogColumnOutcome.getValue());
            }
            return this.createOkResponse(resp);
        });
    }

    @POST
    @Path(value="{rapidViewId}/autoConvert")
    public Response autoConvert(@PathParam(value="rapidViewId") Long rapidViewId) {
        return this.response(() -> {
            RapidView rapidView = this.getRapidView(rapidViewId);
            Optional<Response> editPermissions = this.checkEditPermissions(rapidView);
            if (editPermissions.isPresent()) {
                return editPermissions.get();
            }
            ServiceOutcome<List<Column>> serviceOutcome = this.kanbanBacklogColumnService.migrateBacklogColumn(this.getUser(), rapidView);
            if (serviceOutcome.isValid()) {
                return this.createNoContentResponse();
            }
            return Response.serverError().entity((Object)ErrorCollection.of((String[])new String[]{this.i18nFactoryService.getI18n(this.getUser()).getText(KanbanPlanModeResource.getMessageKeyFrom(serviceOutcome))})).build();
        });
    }

    private ServiceOutcome<List<Column>> disbandBacklogColumnIfExists(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<KanbanBacklogColumn> backlogServiceOutcome = this.columnService.getKanbanBacklogColumn(rapidView);
        if (backlogServiceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(backlogServiceOutcome);
        }
        ServiceOutcome<List<Column>> disbandServiceOutcome = this.kanbanBacklogColumnService.disbandBacklogColumn(user, rapidView);
        if (disbandServiceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(disbandServiceOutcome);
        }
        return ServiceOutcomeImpl.ok(disbandServiceOutcome.get());
    }

    private static String getMessageKeyFrom(ServiceOutcome serviceOutcome) {
        return serviceOutcome.getErrors().getErrors().get(0).getMessageKey();
    }

    private Optional<Response> checkEditPermissions(RapidView rapidView) {
        ServiceOutcome<Void> permission = this.rapidViewPermissionService.validateModifyPermission(this.getUser(), rapidView);
        if (permission.isInvalid()) {
            return Optional.of(this.responseFactory.errorsToResponse(permission));
        }
        return Optional.empty();
    }

    private RapidView getRapidView(Long rapidViewId) {
        return this.rapidViewService.getRapidView(this.getUser(), rapidViewId).get();
    }

    private ColumnEditRequest.MappedColumn toMappedColumn(RapidView rapidView, Column column) throws NoSuchElementException {
        ServiceOutcome<ColumnEditRequest.MappedColumn> mappedColumnOutcome = this.columnEditHelper.toMappedColumn(this.getUser(), rapidView, column);
        return mappedColumnOutcome.get();
    }

    private List<ColumnEditRequest.MappedColumn> toMappedColumn(RapidView rapidView, List<Column> columns) {
        return columns.stream().map(column -> this.toMappedColumn(rapidView, (Column)column)).collect(Collectors.toList());
    }

    @XmlRootElement
    public static class DisableKanbanBacklogResponse
    extends RestTemplate {
        @XmlElement
        Boolean isSuccessful;
        @XmlElement
        List<ColumnEditRequest.MappedColumn> columns;
    }

    @XmlRootElement
    public static class KanPlanOnboardingStateModel
    extends RestTemplate {
        @XmlElement
        public boolean isClosedOnWorkMode;
        @XmlElement
        public boolean isClosedOnPlanMode;
    }
}

