/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.Query;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JqlHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final int MAX_ADVANCED_VALIDATION_MESSAGES = 10;
    @Autowired
    private SearchService searchService;
    @Autowired
    private JqlQueryParser jqlQueryParser;

    public void validateJql(ApplicationUser user, String queryString, String errorContext, ErrorCollection errors) {
        Query query = this.createQuery(user, queryString, errorContext, errors);
        if (!errors.hasErrors()) {
            this.validateJql(user, query, errorContext, errors);
        }
    }

    public ServiceOutcome<Query> validateJql(ApplicationUser user, String queryString, String errorContext) {
        ServiceOutcome<Query> queryOutcome = this.createQuery(user, queryString, errorContext);
        if (queryOutcome.isValid()) {
            return this.validateJql(user, queryOutcome.getValue(), errorContext);
        }
        return queryOutcome;
    }

    public void validateJql(ApplicationUser user, Query query, String errorContext, ErrorCollection errors) {
        MessageSet result = this.searchService.validateQuery(user, query);
        if (result != null) {
            int maxResult;
            Iterator iter;
            if (result.hasAnyErrors()) {
                iter = result.getErrorMessages().iterator();
                for (maxResult = 10; iter.hasNext() && maxResult > 0; --maxResult) {
                    String error = (String)iter.next();
                    errors.addContextualError(errorContext, error, new Object[0]);
                }
            }
            iter = result.getWarningMessages().iterator();
            while (iter.hasNext() && maxResult > 0) {
                String warning = (String)iter.next();
                errors.addContextualError(errorContext, warning, new Object[0]);
                --maxResult;
            }
        }
    }

    public ServiceOutcome<Query> validateJql(ApplicationUser user, Query query, String errorContext) {
        MessageSet result = this.searchService.validateQuery(user, query);
        if (result != null) {
            int maxResult;
            Iterator iter;
            ErrorCollection errors = new ErrorCollection();
            if (result.hasAnyErrors()) {
                iter = result.getErrorMessages().iterator();
                for (maxResult = 10; iter.hasNext() && maxResult > 0; --maxResult) {
                    String error = (String)iter.next();
                    errors.addContextualError(errorContext, error, new Object[0]);
                }
            }
            iter = result.getWarningMessages().iterator();
            while (iter.hasNext() && maxResult > 0) {
                String warning = (String)iter.next();
                errors.addContextualError(errorContext, warning, new Object[0]);
                --maxResult;
            }
            if (errors.hasErrors()) {
                return ServiceOutcomeImpl.from(errors);
            }
        }
        return ServiceOutcomeImpl.ok(query);
    }

    public Query createQuery(ApplicationUser user, String jqlQuery, String errorContext, ErrorCollection errors) {
        Query newQuery = null;
        if (jqlQuery != null) {
            SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jqlQuery);
            if (parseResult.isValid()) {
                newQuery = parseResult.getQuery();
            } else {
                Set errorMessages = parseResult.getErrors().getErrorMessages();
                for (String s : errorMessages) {
                    errors.addContextualError(errorContext, s, new Object[0]);
                }
            }
        }
        return newQuery;
    }

    public ServiceOutcome<Query> createQuery(ApplicationUser user, String jqlQuery) {
        return this.createQuery(user, jqlQuery, "");
    }

    public ServiceOutcome<Query> createQuery(ApplicationUser user, String jqlQuery, String errorContext) {
        Query newQuery = null;
        if (jqlQuery != null) {
            SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jqlQuery);
            if (parseResult.isValid()) {
                newQuery = parseResult.getQuery();
            } else {
                Set errorMessages = parseResult.getErrors().getErrorMessages();
                ErrorCollection errors = new ErrorCollection();
                for (String s : errorMessages) {
                    if (StringUtils.isNotBlank((CharSequence)errorContext)) {
                        errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, errorContext, s, new Object[0]);
                        continue;
                    }
                    errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, s, new Object[0]);
                }
                return ServiceOutcomeImpl.from(errors);
            }
        }
        return ServiceOutcomeImpl.ok(newQuery);
    }

    public String getSanitisedQueryString(ApplicationUser user, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            this.log.debug("Ignoring blank query", new Object[0]);
            return query;
        }
        try {
            Query parsedQuery = this.jqlQueryParser.parseQuery(query);
            return this.searchService.getJqlString(this.searchService.sanitiseSearchQuery(user, parsedQuery));
        }
        catch (JqlParseException e) {
            this.log.debug("Got an unparsable query: %s", query);
            return query;
        }
    }
}

