/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.StoryPointsCustomFieldProvider;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.web.rapid.view.EstimationConfig;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.lang.Pair;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimationHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private StoryPointsCustomFieldProvider storyPointsCustomFieldProvider;
    @Autowired
    private TimeTrackingConfiguration timeTrackingConfiguration;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;

    public EstimationConfig buildModel(ApplicationUser user, RapidView rapidView) {
        StatisticsField currentEstimateStatistic;
        StatisticsFieldEntryFunction transformer = new StatisticsFieldEntryFunction(user);
        EstimationConfig model = new EstimationConfig();
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        model.isTimeTrackingEnabledInJira = this.timeTrackingConfiguration.enabled();
        model.canEnableTimeTracking = this.permissionService.hasGlobalPermission(user, 0);
        ServiceOutcome<StatisticsField> estimateStatisticOutcome = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!estimateStatisticOutcome.isValid()) {
            currentEstimateStatistic = this.estimateStatisticService.getInvalidEstimateStatistic(rapidView);
            this.log.info("Estimate statistic for Rapid View %d is not correctly configured for type '%s' and field id '%s'", rapidView.getId(), currentEstimateStatistic.getConfig().getType().getId(), currentEstimateStatistic.getConfig().getFieldId());
        } else {
            currentEstimateStatistic = estimateStatisticOutcome.getValue();
        }
        model.currentEstimationStatistic = transformer.apply(currentEstimateStatistic);
        ArrayList<StatisticsField> availableEstimateStatistics = new ArrayList<StatisticsField>(this.estimateStatisticService.getAvailableEstimateStatistics());
        this.sortAvailableEstimateStatistics(availableEstimateStatistics, this.i18nFactoryService.getI18n(user));
        if (!model.currentEstimationStatistic.isValid) {
            availableEstimateStatistics.add(0, currentEstimateStatistic);
        }
        model.availableEstimationStatistics = CollectionUtil.transform(availableEstimateStatistics, (Function)transformer);
        StatisticsField currentTrackingStatistic = this.trackingStatisticService.getTrackingStatistic(rapidView);
        model.currentTrackingStatistic = transformer.apply(currentTrackingStatistic);
        return model;
    }

    private void sortAvailableEstimateStatistics(List<StatisticsField> availableEstimateStatistics, final I18n2 i18n) {
        Option storyPointsCustomFieldId;
        if (this.storyPointsCustomFieldProvider.doesDefaultFieldExist()) {
            CustomField storyPointsCustomField = this.storyPointsCustomFieldProvider.getOrCreateDefaultField();
            storyPointsCustomFieldId = Option.some((Object)storyPointsCustomField.getId());
        } else {
            storyPointsCustomFieldId = Option.none();
        }
        Collections.sort(availableEstimateStatistics, new Comparator<StatisticsField>(){

            @Override
            public int compare(StatisticsField o1, StatisticsField o2) {
                if (this.isIssueCount(o1)) {
                    return 1;
                }
                if (this.isIssueCount(o2)) {
                    return -1;
                }
                if (this.isStoryPoints(o1)) {
                    return -1;
                }
                if (this.isStoryPoints(o2)) {
                    return 1;
                }
                if (this.isOriginalEstimate(o1)) {
                    return -1;
                }
                if (this.isOriginalEstimate(o2)) {
                    return 1;
                }
                return o1.getDisplayName(i18n).compareTo(o2.getDisplayName(i18n));
            }

            private boolean isIssueCount(StatisticsField statisticsField) {
                return statisticsField.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT;
            }

            private boolean isStoryPoints(StatisticsField statisticsField) {
                if (storyPointsCustomFieldId.isEmpty()) {
                    return false;
                }
                return statisticsField.isFieldBased() && ((String)storyPointsCustomFieldId.get()).equals(statisticsField.getField().getId());
            }

            private boolean isOriginalEstimate(StatisticsField statisticsField) {
                return statisticsField.isFieldBased() && "timeoriginalestimate".equals(statisticsField.getField().getId());
            }
        });
    }

    public ServiceOutcome<StatisticsFieldConfig> getEstimateStatisticConfig(String estimateStatisticId) {
        if (StringUtils.isBlank((CharSequence)estimateStatisticId)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.estimation.statistics.error.none", new Object[0]);
        }
        ServiceOutcome<Pair<String, String>> parsedIds = StatisticsFieldEntry.parseCompositeId(estimateStatisticId);
        if (!parsedIds.isValid()) {
            return ServiceOutcomeImpl.error(parsedIds);
        }
        String typeId = (String)parsedIds.getValue().first();
        StatisticsFieldConfig.Type statisticFieldType = StatisticsFieldConfig.Type.lookup(typeId);
        if (statisticFieldType == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.estimation.statistics.error.unrecognisedtype", typeId);
        }
        String fieldId = null;
        if (statisticFieldType.isFieldBased().booleanValue()) {
            fieldId = (String)parsedIds.getValue().second();
        }
        StatisticsFieldConfig statisticsFieldConfig = StatisticsFieldConfig.builder().type(statisticFieldType).fieldId(fieldId).build();
        return ServiceOutcomeImpl.ok(statisticsFieldConfig);
    }

    public ServiceOutcome<StatisticsFieldConfig> getTrackingStatisticConfig(String trackingStatisticId) {
        if (StringUtils.isBlank((CharSequence)trackingStatisticId)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.tracking.statistics.error.none", new Object[0]);
        }
        ServiceOutcome<Pair<String, String>> parsedIds = StatisticsFieldEntry.parseCompositeId(trackingStatisticId);
        if (!parsedIds.isValid()) {
            return ServiceOutcomeImpl.error(parsedIds);
        }
        String typeId = (String)parsedIds.getValue().first();
        StatisticsFieldConfig.Type statisticFieldType = StatisticsFieldConfig.Type.lookup(typeId);
        if (statisticFieldType == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.estimation.statistics.error.unrecognisedtype", typeId);
        }
        String fieldId = null;
        if (statisticFieldType.isFieldBased().booleanValue()) {
            fieldId = (String)parsedIds.getValue().second();
        }
        StatisticsFieldConfig statisticsFieldConfig = StatisticsFieldConfig.builder().type(statisticFieldType).fieldId(fieldId).build();
        return ServiceOutcomeImpl.ok(statisticsFieldConfig);
    }

    @Nonnull
    public ServiceOutcome<StatisticsField> getDefaultStatisticsField(@Nonnull RapidView rapidView) {
        ServiceOutcome<StatisticsField> field = this.trackingStatisticService.getTrackingStatisticStrict(rapidView);
        if (field.isInvalid() || !field.get().isEnabled()) {
            field = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        }
        return field;
    }

    @Nonnull
    public ServiceOutcome<StatisticsField> getStatisticsField(String statisticId) {
        ServiceOutcome<StatisticsField> statisticOutcome;
        ServiceOutcome<StatisticsFieldConfig> statisticConfigOutcome = this.getEstimateStatisticConfig(statisticId);
        if (statisticConfigOutcome.isValid() && statisticConfigOutcome.getValue() != null && (statisticOutcome = this.estimateStatisticService.getInstanceOf(statisticConfigOutcome.getValue())).getValue() != null && statisticOutcome.get().isEnabled()) {
            return statisticOutcome;
        }
        statisticConfigOutcome = this.getTrackingStatisticConfig(statisticId);
        if (statisticConfigOutcome.isValid() && statisticConfigOutcome.getValue() != null && (statisticOutcome = this.trackingStatisticService.getInstanceOf(statisticConfigOutcome.getValue())).getValue() != null && statisticOutcome.getValue().isEnabled()) {
            return statisticOutcome;
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "The statistic id selected is invalid", new Object[0]);
    }

    private class StatisticsFieldEntryFunction
    implements Function<StatisticsField, StatisticsFieldEntry> {
        private final ApplicationUser user;

        public StatisticsFieldEntryFunction(ApplicationUser user) {
            this.user = user;
        }

        public StatisticsFieldEntry apply(StatisticsField statisticsFieldInstance) {
            return StatisticsFieldEntry.create(statisticsFieldInstance, EstimationHelper.this.i18nFactoryService.getI18n(this.user));
        }
    }
}

