/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.StatusCountCallback;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.view.ColumnEditRequest;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.greenhopper.web.rapid.workflow.WorkflowHelper;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColumnEditHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private WorkflowHelper workflowHelper;
    @Autowired
    private SimplifiedWorkflowService simplifiedWorkflowService;
    @Autowired
    private StatusEntryFactory statusEntryFactory;

    public ServiceOutcome<ColumnEditRequest> updateStatusMapping(ApplicationUser user, ColumnEditRequest columnEditModel) {
        ErrorCollection errorCollection = new ErrorCollection();
        ServiceOutcome<Void> validateOutcome = this.validateUpdateStatusMappingsRequest(user, columnEditModel);
        if (!validateOutcome.isValid()) {
            return ServiceOutcomeImpl.error(validateOutcome);
        }
        RapidView rapidView = RapidView.builder(columnEditModel.rapidView).build();
        ServiceOutcome<List<Column>> listServiceOutcome = this.columnService.updateColumns(user, rapidView, columnEditModel.columns);
        if (!listServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(listServiceOutcome);
        }
        StatisticsFieldConfig.StatisticsFieldConfigBuilder statisticsFieldConfigBuilder = new StatisticsFieldConfig.StatisticsFieldConfigBuilder();
        statisticsFieldConfigBuilder.fieldId(StatisticsFieldEntry.getFieldIdFromComposite(columnEditModel.currentStatisticsField.id));
        statisticsFieldConfigBuilder.type(StatisticsFieldConfig.Type.lookup(StatisticsFieldEntry.getTypeIdFromComposite(columnEditModel.currentStatisticsField.id)));
        this.statisticsFieldService.updateStatisticsField(user, errorCollection, rapidView, statisticsFieldConfigBuilder.build());
        if (errorCollection.hasErrors()) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, rapidView.getId());
        if (!rapidViewOutcome.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        return this.buildColumnEditModel(user, i18n, rapidViewOutcome.getValue());
    }

    private ServiceOutcome<Void> validateUpdateStatusMappingsRequest(ApplicationUser user, ColumnEditRequest editModel) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, editModel.rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        editModel.rapidView = rapidView.getValue();
        editModel.columns = new LinkedList<Column>();
        for (ColumnEditRequest.MappedColumn mappedColumn : editModel.mappedColumns) {
            if (mappedColumn.isKanPlanColumn) {
                editModel.columns.add(0, KanbanBacklogColumn.newKanbanBacklogColumn(mappedColumn.id, ColumnEditHelper.extractStatusIds(mappedColumn.mappedStatuses)));
                continue;
            }
            Column.ColumnBuilder column = Column.builder().id(mappedColumn.id).name(mappedColumn.name).min(NumberUtils.toDouble(mappedColumn.min)).max(NumberUtils.toDouble(mappedColumn.max));
            for (ColumnEditRequest.StatusDetails statusEntry : mappedColumn.mappedStatuses) {
                column.statusId(statusEntry.id);
            }
            editModel.columns.add(column.build());
        }
        return ServiceOutcomeImpl.ok();
    }

    private static List<String> extractStatusIds(List<ColumnEditRequest.StatusDetails> statuses) {
        return statuses.stream().map(statusEntry -> statusEntry.id).collect(Collectors.toList());
    }

    public ServiceOutcome<ColumnEditRequest> buildColumnEditModel(ApplicationUser user, I18n2 i18n, RapidView rapidView) {
        ColumnEditRequest model = new ColumnEditRequest();
        model.rapidView = rapidView;
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        model.workflow = this.buildSimplifiedWorkflowEntry(user, rapidView);
        StatisticFieldConfigurationEntry columnConstraintStatisticModel = this.getColumnConstraintStatisticModel(i18n, rapidView);
        model.currentStatisticsField = columnConstraintStatisticModel.currentStatisticsField;
        model.showDaysInColumn = rapidView.showDaysInColumn();
        model.statisticsFields = columnConstraintStatisticModel.statisticsFields;
        model.statisticsFieldValidation = columnConstraintStatisticModel.statisticsFieldValidation;
        ServiceOutcome<Pair<List<ColumnEditRequest.MappedColumn>, List<ColumnEditRequest.StatusDetails>>> mappedColumnsAndUnmappedStatusesOutcome = this.buildColumnStatusesModel(user, i18n, rapidView, model.workflow.usingSimplifiedWorkflow);
        if (mappedColumnsAndUnmappedStatusesOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(mappedColumnsAndUnmappedStatusesOutcome);
        }
        Pair<List<ColumnEditRequest.MappedColumn>, List<ColumnEditRequest.StatusDetails>> mappedColumnsAndUnmappedStatuses = mappedColumnsAndUnmappedStatusesOutcome.getValue();
        model.mappedColumns = (List)mappedColumnsAndUnmappedStatuses.first();
        model.unmappedStatuses = (List)mappedColumnsAndUnmappedStatuses.second();
        model.showEpicAsPanel = rapidView.getShowEpicsAsPanel().isEnabled();
        return ServiceOutcomeImpl.ok(model);
    }

    private ColumnEditRequest.SimplifiedWorkflowEntry buildSimplifiedWorkflowEntry(ApplicationUser user, RapidView rapidView) {
        ColumnEditRequest.SimplifiedWorkflowEntry workflow = new ColumnEditRequest.SimplifiedWorkflowEntry();
        if (this.simplifiedWorkflowService.isFeatureEnabled()) {
            workflow.isSimplifiedWorkflowFeatureEnabled = true;
            WorkflowHelper.SimplifiedWorkflowResult simplifiedWorkflowResult = this.workflowHelper.isRapidViewUsingGreenHopperSimplifiedWorkflow(user, rapidView);
            Project simplifiedWorkflowProject = simplifiedWorkflowResult.getSimplifiedWorkflowProject();
            workflow.usingSimplifiedWorkflow = simplifiedWorkflowResult.isUsingSimplifiedWorkflow();
            if (simplifiedWorkflowProject != null) {
                workflow.simplifiedWorkflowProjectName = simplifiedWorkflowProject.getName();
                workflow.simplifiedWorkflowProjectKey = simplifiedWorkflowProject.getKey();
            }
            workflow.isProjectAdminOfSimplifiedWorkflow = simplifiedWorkflowResult.isUserAdminOfProject();
            workflow.canSimplifyWorkflow = simplifiedWorkflowResult.canSimplifyWorkflow();
            workflow.userCanSimplifyWorkflow = simplifiedWorkflowResult.userCanSimplifyWorkflow();
        }
        return workflow;
    }

    private ServiceOutcome<JiraWorkflow> getJiraWorkflow(ApplicationUser user, RapidView rapidView, boolean usingSimplifiedWorkflow) {
        JiraWorkflow jiraWorkflow = null;
        if (usingSimplifiedWorkflow) {
            ServiceOutcome<Pair<JiraWorkflow, Project>> workflowOutcome = this.workflowHelper.getGreenHopperSimplifiedWorkflow(user, rapidView);
            if (workflowOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(workflowOutcome);
            }
            jiraWorkflow = (JiraWorkflow)workflowOutcome.getValue().first();
        }
        return ServiceOutcomeImpl.ok(jiraWorkflow);
    }

    private Map<String, Long> getStatusCount(ApplicationUser user, Query baseQuery) {
        StatusCountCallback callback = new StatusCountCallback();
        ServiceOutcome<Void> result = this.issueDataService.findWithServiceOutcome(user, baseQuery, callback);
        Map<String, Long> statusCount = result.isValid() ? callback.getStatusCount() : Collections.emptyMap();
        return statusCount;
    }

    public ServiceOutcome<Pair<List<ColumnEditRequest.MappedColumn>, List<ColumnEditRequest.StatusDetails>>> buildColumnStatusesModel(ApplicationUser user, I18n2 i18n, RapidView rapidView, boolean usingSimplifiedWorkflow) {
        Set<Status> accessibleStatuses;
        Map<String, Long> statusCount;
        ServiceOutcome<Query> baseQueryOutcome = this.getBaseQuery(user, rapidView);
        if (baseQueryOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(baseQueryOutcome);
        }
        Query baseQuery = baseQueryOutcome.get();
        ServiceOutcome<JiraWorkflow> workflowOutcome = this.getJiraWorkflow(user, rapidView, usingSimplifiedWorkflow);
        if (workflowOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(workflowOutcome);
        }
        JiraWorkflow jiraWorkflow = workflowOutcome.getValue();
        ServiceOutcome<List<ColumnEditRequest.MappedColumn>> mappedColumnsOutcome = this.getMappedColumns(user, i18n, jiraWorkflow, statusCount = this.getStatusCount(user, baseQuery), accessibleStatuses = this.workflowService.getAccessibleStatuses(user, baseQuery), usingSimplifiedWorkflow, rapidView);
        if (mappedColumnsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(mappedColumnsOutcome);
        }
        List<ColumnEditRequest.MappedColumn> mappedColumns = mappedColumnsOutcome.get();
        ServiceOutcome<List<ColumnEditRequest.StatusDetails>> unmappedStatusOutcome = this.getUnmappedStatuses(user, jiraWorkflow, statusCount, accessibleStatuses, usingSimplifiedWorkflow, rapidView);
        if (unmappedStatusOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(unmappedStatusOutcome);
        }
        List<ColumnEditRequest.StatusDetails> unmappedStatusEntries = unmappedStatusOutcome.get();
        return ServiceOutcomeImpl.ok(Pair.of(mappedColumns, unmappedStatusEntries));
    }

    private ServiceOutcome<List<ColumnEditRequest.MappedColumn>> getMappedColumns(ApplicationUser user, I18n2 i18n, JiraWorkflow jiraWorkflow, Map<String, Long> statusCount, Set<Status> accessibleStatuses, boolean usingSimplifiedWorkflow, RapidView rapidView) {
        ArrayList<ColumnEditRequest.MappedColumn> mappedColumns = new ArrayList<ColumnEditRequest.MappedColumn>();
        for (Column column : this.columnService.getVisibleColumns(rapidView)) {
            ServiceOutcome<ColumnEditRequest.MappedColumn> mappedColumnServiceOutcome = this.getMappedColumn(user, i18n, jiraWorkflow, statusCount, accessibleStatuses, usingSimplifiedWorkflow, column);
            if (mappedColumnServiceOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(mappedColumnServiceOutcome);
            }
            mappedColumns.add(mappedColumnServiceOutcome.get());
        }
        return ServiceOutcomeImpl.ok(mappedColumns);
    }

    private ServiceOutcome<List<ColumnEditRequest.StatusDetails>> getUnmappedStatuses(ApplicationUser user, JiraWorkflow jiraWorkflow, Map<String, Long> statusCount, Set<Status> accessibleStatuses, boolean usingSimplifiedWorkflow, RapidView rapidView) {
        ArrayList<Status> unmappedStatuses = new ArrayList<Status>(accessibleStatuses);
        Set<Status> mappedStatuses = this.columnService.getMappedStatuses(rapidView);
        unmappedStatuses.removeAll(mappedStatuses);
        ArrayList<ColumnEditRequest.StatusDetails> unmappedStatusEntries = new ArrayList<ColumnEditRequest.StatusDetails>();
        for (Status status : unmappedStatuses) {
            ServiceOutcome<ColumnEditRequest.StatusDetails> statusOutcome = this.asStatusEntry(user, jiraWorkflow, status, statusCount, true, usingSimplifiedWorkflow);
            if (statusOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(statusOutcome);
            }
            unmappedStatusEntries.add(statusOutcome.getValue());
        }
        Collections.sort(unmappedStatusEntries);
        return ServiceOutcomeImpl.ok(unmappedStatusEntries);
    }

    private ServiceOutcome<ColumnEditRequest.MappedColumn> getMappedColumn(ApplicationUser user, I18n2 i18n, JiraWorkflow jiraWorkflow, Map<String, Long> statusCount, Set<Status> accessibleStatuses, boolean usingSimplifiedWorkflow, Column column) {
        ColumnEditRequest.MappedColumn mappedColumn = new ColumnEditRequest.MappedColumn();
        mappedColumn.id = column.getId();
        mappedColumn.name = i18n.getText(column.getName());
        mappedColumn.isKanPlanColumn = KanbanBacklogColumn.isKanbanBacklogColumn(column);
        mappedColumn.min = column.getMin() == null ? "" : Long.toString(Math.round(column.getMin()));
        mappedColumn.max = column.getMax() == null ? "" : Long.toString(Math.round(column.getMax()));
        for (String statusId : column.getStatusIds()) {
            Status status = this.workflowService.getWorkflowStatusObject(statusId);
            if (status != null) {
                ServiceOutcome<ColumnEditRequest.StatusDetails> statusOutcome = this.asStatusEntry(user, jiraWorkflow, status, statusCount, accessibleStatuses.contains(status), usingSimplifiedWorkflow);
                if (statusOutcome.isInvalid()) {
                    return ServiceOutcomeImpl.error(statusOutcome);
                }
                mappedColumn.mappedStatuses.add(statusOutcome.getValue());
                continue;
            }
            this.log.info("Invalid status [id %d] mapped to column [id %d], ignoring", statusId, column.getId());
        }
        return ServiceOutcomeImpl.ok(mappedColumn);
    }

    public ServiceOutcome<ColumnEditRequest.MappedColumn> toMappedColumn(ApplicationUser user, RapidView rapidView, Column column) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ColumnEditRequest.SimplifiedWorkflowEntry simplifiedWorkflowEntry = this.buildSimplifiedWorkflowEntry(user, rapidView);
        boolean usingSimplifiedWorkflow = simplifiedWorkflowEntry.usingSimplifiedWorkflow;
        ServiceOutcome<Query> baseQueryOutcome = this.getBaseQuery(user, rapidView);
        if (baseQueryOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(baseQueryOutcome);
        }
        Query baseQuery = baseQueryOutcome.get();
        Map<String, Long> statusCount = this.getStatusCount(user, baseQuery);
        ServiceOutcome<JiraWorkflow> jiraWorkflowOutcome = this.getJiraWorkflow(user, rapidView, usingSimplifiedWorkflow);
        if (jiraWorkflowOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(jiraWorkflowOutcome);
        }
        JiraWorkflow jiraWorkflow = jiraWorkflowOutcome.getValue();
        Set<Status> accessibleStatuses = this.workflowService.getAccessibleStatuses(user, baseQuery);
        return this.getMappedColumn(user, i18n, jiraWorkflow, statusCount, accessibleStatuses, usingSimplifiedWorkflow, column);
    }

    private ServiceOutcome<Query> getBaseQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<SearchRequest> searchRequestOutcome = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (searchRequestOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(searchRequestOutcome);
        }
        return ServiceOutcomeImpl.ok(searchRequestOutcome.get().getQuery());
    }

    private ServiceOutcome<ColumnEditRequest.StatusDetails> asStatusEntry(ApplicationUser user, JiraWorkflow workflow, Status status, Map<String, Long> statusCount, boolean isPresentInWorkflow, boolean usingSimplifiedWorkflow) {
        ColumnEditRequest.StatusDetails statusEntry = ColumnEditRequest.StatusDetails.from(this.statusEntryFactory.createStatusEntry(status));
        statusEntry.issueCount = 0L;
        statusEntry.isPresentInWorkflow = isPresentInWorkflow;
        if (statusCount.containsKey(status.getId())) {
            statusEntry.issueCount = statusCount.get(status.getId());
        }
        if (usingSimplifiedWorkflow) {
            ServiceOutcome<Boolean> resolutionDoneOutcome = this.simplifiedWorkflowService.isStatusResolutionDone(user, workflow, status);
            if (resolutionDoneOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(resolutionDoneOutcome);
            }
            statusEntry.isResolutionDone = resolutionDoneOutcome.getValue();
        }
        return ServiceOutcomeImpl.ok(statusEntry);
    }

    private StatisticFieldConfigurationEntry getColumnConstraintStatisticModel(I18n2 i18n, RapidView rapidView) {
        List<StatisticsFieldInstance> availableStatisticsFields = this.statisticsFieldService.getAvailableStatisticsFields();
        ArrayList<StatisticsFieldEntry> statisticsFields = new ArrayList<StatisticsFieldEntry>();
        for (StatisticsFieldInstance instance : availableStatisticsFields) {
            StatisticsFieldEntry entry = StatisticsFieldEntry.create(instance, i18n);
            statisticsFields.add(entry);
        }
        ServiceOutcome<StatisticsFieldConfig> statisticsField = this.statisticsFieldService.loadStatisticsField(rapidView);
        StatisticsFieldConfig currentConfig = StatisticsFieldConfig.buildNone();
        if (statisticsField.isValid()) {
            currentConfig = statisticsField.getValue();
        }
        Pair<StatisticsFieldEntry, StatisticsFieldEntry.ValidationEntry> statFieldWithValidationErrors = this.createCurrentStatisticsFieldEntry(currentConfig, i18n);
        StatisticsFieldEntry currentStatisticsField = (StatisticsFieldEntry)statFieldWithValidationErrors.first();
        StatisticsFieldEntry.ValidationEntry statisticsFieldValidation = (StatisticsFieldEntry.ValidationEntry)statFieldWithValidationErrors.second();
        if (!currentStatisticsField.isValid) {
            statisticsFields.add(0, currentStatisticsField);
        }
        StatisticFieldConfigurationEntry entry = new StatisticFieldConfigurationEntry();
        entry.statisticsFields = statisticsFields;
        entry.currentStatisticsField = currentStatisticsField;
        entry.statisticsFieldValidation = statisticsFieldValidation;
        return entry;
    }

    private Pair<StatisticsFieldEntry, StatisticsFieldEntry.ValidationEntry> createCurrentStatisticsFieldEntry(StatisticsFieldConfig config, I18n2 i18n) {
        ServiceOutcome<StatisticsFieldInstance> result = this.statisticsFieldService.getInstanceOfField(config);
        StatisticsFieldConfig.Type type = config.getType();
        StatisticsFieldEntry.ValidationEntry validationEntry = new StatisticsFieldEntry.ValidationEntry();
        StatisticsFieldEntry entry = StatisticsFieldEntry.create(type.getId(), config.getFieldId() == null ? "" : config.getFieldId(), result.getValue().getName(i18n), type != StatisticsFieldConfig.Type.NONE, true);
        entry.isValid = result.isValid();
        validationEntry.isValid = result.isValid();
        if (!result.isValid()) {
            ErrorCollection.ErrorItem errorItem = result.getErrors().getErrors().get(0);
            validationEntry.validationMessage = i18n.getText(errorItem.getMessageKey(), errorItem.getParams());
            entry.name = "";
        }
        return Pair.of((Object)entry, (Object)validationEntry);
    }

    private static class StatisticFieldConfigurationEntry {
        StatisticsFieldEntry currentStatisticsField;
        StatisticsFieldEntry.ValidationEntry statisticsFieldValidation;
        List<StatisticsFieldEntry> statisticsFields = new ArrayList<StatisticsFieldEntry>();

        private StatisticFieldConfigurationEntry() {
        }
    }
}

