/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.view.CardColorEditModel;
import com.atlassian.greenhopper.web.rapid.view.CardColorEntry;
import com.atlassian.greenhopper.web.rapid.view.CardColorHelper;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="cardcolors/{rapidViewId}")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CardColorResource
extends AbstractResource {
    private CardColorHelper cardColorHelper;
    private I18nFactoryService i18nFactoryService;

    public CardColorResource(CardColorHelper cardColorHelper, I18nFactoryService i18nFactoryService) {
        this.cardColorHelper = cardColorHelper;
        this.i18nFactoryService = i18nFactoryService;
    }

    @PUT
    @Path(value="/strategy")
    @Consumes(value={"application/json"})
    public Response setCardColorStrategy(final CardColorStrategyUpdateRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RapidView> updated = CardColorResource.this.cardColorHelper.updateCardColorStrategy(CardColorResource.this.getUser(), request.id, request.cardColorStrategyId);
                CardColorResource.this.check(updated);
                return CardColorResource.this.createNoContentResponse();
            }
        });
    }

    @AnonymousAllowed
    @GET
    @Path(value="strategy/{strategyId}")
    public Response getStrategyColors(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="strategyId") String strategyId, final @QueryParam(value="preloadValues") Boolean preloadValues) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CardColorEditModel> cardColorModel = CardColorResource.this.cardColorHelper.getColorModelForStrategy(CardColorResource.this.getUser(), rapidViewId, strategyId, preloadValues != null ? preloadValues : false);
                CardColorResource.this.check(cardColorModel);
                return CardColorResource.this.createOkResponse(cardColorModel.getValue());
            }
        });
    }

    @AnonymousAllowed
    @GET
    @Path(value="color/{id}")
    public Response getCardColor(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CardColorEntry> cardColorModel = CardColorResource.this.cardColorHelper.getCardColor(CardColorResource.this.getUser(), rapidViewId, id);
                CardColorResource.this.check(cardColorModel);
                return CardColorResource.this.createOkResponse(cardColorModel.getValue());
            }
        });
    }

    @PUT
    @Path(value="color/{id}")
    public Response updateCardColor(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final CardColorEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CardColorEntry> cardColorModel = CardColorResource.this.cardColorHelper.updateCardColor(CardColorResource.this.getUser(), rapidViewId, id, editModel);
                CardColorResource.this.check(cardColorModel);
                return CardColorResource.this.createOkResponse(cardColorModel.getValue());
            }
        });
    }

    @POST
    @Path(value="color")
    public Response addCardColor(final @PathParam(value="rapidViewId") Long rapidViewId, final CardColorEntry editModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<CardColorEntry> cardColorModel = CardColorResource.this.cardColorHelper.addCardColor(CardColorResource.this.getUser(), rapidViewId, editModel);
                CardColorResource.this.check(cardColorModel);
                return CardColorResource.this.createOkResponse(cardColorModel.getValue());
            }
        });
    }

    @DELETE
    @Path(value="color/{id}")
    public Response deleteCardColor(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<Void> outcome = CardColorResource.this.cardColorHelper.deleteCardColor(CardColorResource.this.getUser(), rapidViewId, id);
                CardColorResource.this.check(outcome);
                return CardColorResource.this.createNoContentResponse();
            }
        });
    }

    @POST
    @Path(value="color/{id}/move")
    public Response moveCardColor(final @PathParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="id") Long id, final EntryMoveModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<Void> outcome = CardColorResource.this.cardColorHelper.moveCardColor(CardColorResource.this.getUser(), rapidViewId, id, model);
                CardColorResource.this.check(outcome);
                return CardColorResource.this.createNoContentResponse();
            }
        });
    }

    @XmlRootElement
    static class CardColorStrategyUpdateRequest
    extends RestTemplate {
        @XmlElement
        Long id;
        @XmlElement
        String cardColorStrategyId;

        CardColorStrategyUpdateRequest() {
        }
    }
}

