/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorQueryService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorService;
import com.atlassian.greenhopper.util.ColorUtils;
import com.atlassian.greenhopper.web.rapid.view.CardColorEditModel;
import com.atlassian.greenhopper.web.rapid.view.CardColorEntry;
import com.atlassian.greenhopper.web.rapid.view.EntryMoveModel;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.I18nHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorHelper {
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private CardColorService cardColorService;
    @Autowired
    private JqlHelper jqlHelper;
    @Autowired
    private ConstantsManager constantsManager;
    @Autowired
    I18nHelper.BeanFactory i18nBeanFactory;
    @Autowired
    private CardColorQueryService cardColorQueryService;
    @Autowired
    private CardColorPalette cardColorPalette;

    public ServiceOutcome<RapidView> updateCardColorStrategy(ApplicationUser user, long rapidViewId, String cardColorStrategyId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        CardColorStrategy cardColorStrategy = CardColorStrategy.lookup(cardColorStrategyId);
        RapidView updatedView = RapidView.builder(rapidView.getValue()).cardColorStrategy(cardColorStrategy).build();
        ServiceResult updated = this.rapidViewService.update(user, updatedView);
        if (!updated.isValid()) {
            return ServiceOutcomeImpl.error(updated);
        }
        return ServiceOutcomeImpl.ok(updatedView);
    }

    public CardColorEditModel getBaseCardColorEditModel(ApplicationUser user, RapidView rapidView) {
        return this.getBaseCardColorEditModel(user, rapidView, rapidView.getCardColorStrategy());
    }

    public CardColorEditModel getBaseCardColorEditModel(ApplicationUser user, RapidView rapidView, CardColorStrategy cardColorStrategy) {
        CardColorEditModel model = new CardColorEditModel();
        model.rapidViewId = rapidView.getId();
        model.canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        model.cardColorStrategy = cardColorStrategy.getId();
        return model;
    }

    public ServiceOutcome<CardColorEditModel> getColorModelForStrategy(ApplicationUser user, long rapidViewId, String cardColorStrategyId, boolean preloadValues) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        CardColorStrategy cardColorStrategy = CardColorStrategy.lookup(cardColorStrategyId);
        if (cardColorStrategy == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.cardcolor.strategy.invalid", cardColorStrategyId);
        }
        CardColorEditModel model = this.getBaseCardColorEditModel(user, rapidView.getValue(), cardColorStrategy);
        if (CardColorStrategy.NONE != cardColorStrategy) {
            ServiceOutcome<List<CardColorEntry>> cardColorsServiceOutCome;
            if (preloadValues) {
                this.cardColorQueryService.queryAndAttributeColorSettingsForBoard(user, rapidView.getValue(), cardColorStrategy);
            }
            if (!(cardColorsServiceOutCome = this.getCardColorEntries(cardColorStrategy, user, rapidView, model)).isValid()) {
                return ServiceOutcomeImpl.error(cardColorsServiceOutCome);
            }
            model.cardColors = cardColorsServiceOutCome.getValue();
        } else {
            model.cardColors = Collections.emptyList();
        }
        if (CardColorStrategy.CUSTOM == cardColorStrategy) {
            ArrayList<String> defaultColors = new ArrayList<String>();
            for (Color color : this.cardColorPalette.getDefaultColors()) {
                defaultColors.add(ColorUtils.colorToHex(color));
            }
            model.defaultColors = defaultColors;
        }
        return ServiceOutcomeImpl.ok(model);
    }

    private ServiceOutcome<List<CardColorEntry>> getCardColorEntries(CardColorStrategy cardColorStrategy, ApplicationUser user, ServiceOutcome<RapidView> rapidView, CardColorEditModel model) {
        ServiceOutcome<List<CardColor>> cardColorsServiceOutcome = this.cardColorService.getForStrategy(user, rapidView.getValue(), cardColorStrategy);
        if (!cardColorsServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Unable to load card colors", new Object[0]);
        }
        List<CardColor> cardColors = cardColorsServiceOutcome.getValue();
        ServiceOutcome<List<CardColorEntry>> cardColorEntriesServiceOutCome = this.toCardColorEntries(user, cardColors, model.canEdit);
        if (!cardColorEntriesServiceOutCome.isValid()) {
            return ServiceOutcomeImpl.error(cardColorEntriesServiceOutCome);
        }
        List<CardColorEntry> cardColorEntries = cardColorEntriesServiceOutCome.getValue();
        return ServiceOutcomeImpl.ok(cardColorEntries);
    }

    public ServiceOutcome<CardColorEntry> updateCardColor(ApplicationUser user, Long rapidViewId, Long cardColorId, CardColorEntry editModel) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        ServiceOutcome<CardColor> existing = this.cardColorService.get(user, rapidView.getValue(), cardColorId);
        if (!existing.isValid()) {
            return ServiceOutcomeImpl.error(existing);
        }
        Color newColor = existing.getValue().getColor();
        CardColorStrategy strategy = CardColorStrategy.lookup(editModel.strategy);
        if (strategy == null) {
            strategy = existing.getValue().getStrategy();
        }
        CardColor cardColor = CardColor.builder(existing.getValue()).strategy(strategy).color(ColorUtils.hexToColor(editModel.color, existing.getValue().getColor())).value(StringUtils.defaultString((String)editModel.value, (String)existing.getValue().getValue())).build();
        ServiceOutcome<CardColor> updatedCardColor = this.cardColorService.update(user, rapidView.getValue(), cardColor);
        if (!updatedCardColor.isValid()) {
            return ServiceOutcomeImpl.error(updatedCardColor);
        }
        boolean canEdit = true;
        return ServiceOutcomeImpl.ok(this.toCardColorEntry(user, updatedCardColor.getValue(), canEdit));
    }

    public ServiceOutcome<CardColorEntry> addCardColor(ApplicationUser user, Long rapidViewId, CardColorEntry editModel) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        CardColorStrategy strategy = CardColorStrategy.lookup(editModel.strategy);
        if (strategy == null) {
            strategy = CardColorStrategy.ISSUE_TYPE;
        }
        CardColor cardColor = CardColor.builder().strategy(strategy).color(ColorUtils.hexToColor(editModel.color, this.cardColorPalette.getFallback())).value(StringUtils.defaultString((String)editModel.value)).build();
        ServiceOutcome<CardColor> createdCardColor = this.cardColorService.add(user, rapidView.getValue(), cardColor);
        if (!createdCardColor.isValid()) {
            return ServiceOutcomeImpl.error(createdCardColor);
        }
        boolean canEdit = true;
        return ServiceOutcomeImpl.ok(this.toCardColorEntry(user, createdCardColor.getValue(), canEdit));
    }

    public ServiceOutcome<CardColorEntry> getCardColor(ApplicationUser user, Long rapidViewId, Long cardColorId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        ServiceOutcome<CardColor> cardColor = this.cardColorService.get(user, rapidView.getValue(), cardColorId);
        if (!cardColor.isValid()) {
            return ServiceOutcomeImpl.error(cardColor);
        }
        boolean canEdit = this.rapidViewPermissionService.canEdit(user, rapidView.getValue());
        return ServiceOutcomeImpl.ok(this.toCardColorEntry(user, cardColor.getValue(), canEdit));
    }

    public ServiceOutcome<Void> deleteCardColor(ApplicationUser user, Long rapidViewId, Long cardColorId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        return this.cardColorService.delete(user, rapidView.getValue(), cardColorId);
    }

    public ServiceOutcome<Void> moveCardColor(ApplicationUser user, Long rapidViewId, Long cardColorId, EntryMoveModel moveModel) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        return this.cardColorService.moveAfter(user, rapidView.getValue(), cardColorId, moveModel.getMoveToId());
    }

    private ServiceOutcome<List<CardColorEntry>> toCardColorEntries(ApplicationUser user, List<CardColor> cardColors, boolean canEdit) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(user);
        ArrayList<CardColorEntry> entries = new ArrayList<CardColorEntry>();
        for (CardColor cardColor : cardColors) {
            entries.add(this.toCardColorEntry(user, cardColor, canEdit, i18nHelper));
        }
        return ServiceOutcomeImpl.ok(entries);
    }

    private CardColorEntry toCardColorEntry(ApplicationUser user, CardColor cardColor, boolean canEdit) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(user);
        return this.toCardColorEntry(user, cardColor, canEdit, i18nHelper);
    }

    private CardColorEntry toCardColorEntry(ApplicationUser user, CardColor cardColor, boolean canEdit, I18nHelper i18nHelper) {
        CardColorEntry entry = new CardColorEntry();
        entry.id = cardColor.getId();
        entry.strategy = cardColor.getStrategy().getId();
        entry.color = ColorUtils.colorToHex(cardColor.getColor());
        entry.canEdit = canEdit;
        entry.displayValue = entry.value = cardColor.getValue();
        switch (cardColor.getStrategy()) {
            case ISSUE_TYPE: {
                IssueType issueType = this.constantsManager.getIssueTypeObject(entry.value);
                if (issueType == null) break;
                entry.displayValue = issueType.getNameTranslation(i18nHelper);
                break;
            }
            case PRIORITY: {
                Priority priority = this.constantsManager.getPriorityObject(entry.value);
                if (priority == null) break;
                entry.displayValue = priority.getNameTranslation(i18nHelper);
                break;
            }
            case CUSTOM: {
                entry.displayValue = entry.value = this.jqlHelper.getSanitisedQueryString(user, entry.value);
                break;
            }
            case ASSIGNEE: {
                if ("unassigned".equals(entry.value)) {
                    entry.displayValue = i18nHelper.getText("gh.issue.noassignee");
                    break;
                }
                ApplicationUser assignee = ApplicationUsers.byKey((String)entry.value);
                if (assignee == null) break;
                entry.displayValue = assignee.getDisplayName();
                break;
            }
        }
        return entry;
    }
}

