/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.view;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class BoardAdminsPickerModel
extends RestTemplate {
    @XmlElement
    @Nonnull
    List<BoardAdmin> users;
    @XmlElement
    @Nonnull
    List<BoardAdmin> groups;

    public static BoardAdminsPickerModel create(List<ApplicationUser> users, List<Group> groups) {
        BoardAdminsPickerModel boardAdminsPickerModel = new BoardAdminsPickerModel();
        boardAdminsPickerModel.users = Lists.newArrayList();
        boardAdminsPickerModel.groups = Lists.newArrayList();
        for (ApplicationUser user : users) {
            boardAdminsPickerModel.users.add(BoardAdmin.create(user));
        }
        for (Group group : groups) {
            boardAdminsPickerModel.groups.add(BoardAdmin.create(group));
        }
        return boardAdminsPickerModel;
    }

    @XmlRootElement
    public static class BoardAdmin
    extends RestTemplate {
        @XmlElement
        String displayName;
        @XmlElement
        String name;
        @XmlElement
        String key;

        public static BoardAdmin create(ApplicationUser user) {
            BoardAdmin boardAdmin = new BoardAdmin();
            boardAdmin.displayName = user.getDisplayName();
            boardAdmin.name = user.getName();
            boardAdmin.key = ApplicationUsers.getKeyFor((ApplicationUser)user);
            return boardAdmin;
        }

        public static BoardAdmin create(Group group) {
            BoardAdmin boardAdmin = new BoardAdmin();
            boardAdmin.displayName = group.getName();
            boardAdmin.name = group.getName();
            boardAdmin.key = group.getName();
            return boardAdmin;
        }
    }
}

