/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.version;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.version.VersionPermissionService;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Path(value="versions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class VersionResource
extends AbstractResource {
    private VersionService versionService;
    private ProjectManager projectManager;
    private DateTimeFormatter dateTimeFormatterFactory;
    private DateFieldFormat dateFieldFormat;
    private VersionPermissionService versionPermissionService;

    public VersionResource(VersionService versionService, ProjectManager projectManager, DateTimeFormatter dateTimeFormatterFactory, DateFieldFormat dateFieldFormat, VersionPermissionService versionPermissionService) {
        this.versionService = versionService;
        this.projectManager = projectManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.dateFieldFormat = dateFieldFormat;
        this.versionPermissionService = versionPermissionService;
    }

    @POST
    public Response create(final VersionModel versionModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = VersionResource.this.getUser();
                Project project = (Project)VersionResource.this.check(VersionResource.this.validateProject(user, versionModel.projectId));
                ServiceOutcome releaseDate = VersionResource.this.parseDate(versionModel.releaseDate, "releaseDate");
                ServiceOutcome versionStartDate = VersionResource.this.parseDate(versionModel.startDate, "startDate");
                ErrorCollection errors = new ErrorCollection();
                VersionResource.this.check(VersionResource.this.validate(releaseDate, versionStartDate, errors, versionModel));
                String versionName = versionModel.name.trim();
                String versionDescription = versionModel.description;
                Pair<Project, Version> createdVersion = VersionResource.this.check(VersionResource.this.versionService.createVersion(user, project, versionName, versionDescription, (Date)((Option)releaseDate.getValue()).getOrNull(), (Date)((Option)versionStartDate.getValue()).getOrNull()));
                Version version = (Version)createdVersion.second();
                VersionMetaData versionMetaData = VersionResource.this.versionService.getMetaData(version);
                return VersionResource.this.createOkResponse(VersionResource.this.toModel(user, (Project)createdVersion.first(), version, versionMetaData));
            }
        });
    }

    @POST
    @Path(value="{versionId}")
    public Response update(final @PathParam(value="versionId") Long versionId, final VersionModel versionModel) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = VersionResource.this.getUser();
                VersionResource.this.check(VersionResource.this.versionService.get(user, versionId));
                Option startDate = (Option)VersionResource.this.check(VersionResource.this.parseDate(versionModel.startDate, "startDate"));
                Option releaseDate = (Option)VersionResource.this.check(VersionResource.this.parseDate(versionModel.releaseDate, "releaseDate"));
                if (versionModel.name == null || Strings.isNullOrEmpty((String)versionModel.name.trim())) {
                    VersionResource.this.check(ServiceOutcomeImpl.error("name", ErrorCollection.Reason.VALIDATION_FAILED, "gh.version.error.specify.name", new Object[0]));
                }
                String versionName = versionModel.name.trim();
                String versionDescription = versionModel.description;
                VersionResource.this.check(VersionResource.this.versionService.updateVersion(user, versionId, versionName, versionDescription, (Date)releaseDate.getOrNull(), (Date)startDate.getOrNull()));
                return VersionResource.this.createNoContentResponse();
            }
        });
    }

    private ServiceOutcome validate(ServiceOutcome<Option<Date>> releaseDate, ServiceOutcome<Option<Date>> versionStartDate, ErrorCollection errors, VersionModel versionModel) {
        if (releaseDate.isInvalid()) {
            errors.addAllErrors(releaseDate.getErrors());
        }
        if (versionStartDate.isInvalid()) {
            errors.addAllErrors(versionStartDate.getErrors());
        }
        if (versionModel.name == null || Strings.isNullOrEmpty((String)versionModel.name.trim())) {
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, "name", "gh.version.error.specify.name", new Object[0]);
        }
        if (errors.hasErrors()) {
            this.check(ServiceOutcomeImpl.from(errors));
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<Option<Date>> parseDate(String dateString, String contextId) {
        if (StringUtils.isBlank((String)dateString)) {
            return ServiceOutcomeImpl.ok(Option.none());
        }
        try {
            return ServiceOutcomeImpl.ok(Option.some((Object)this.dateFieldFormat.parseDatePicker(dateString)));
        }
        catch (IllegalArgumentException e) {
            return ServiceOutcomeImpl.error(contextId, ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.version.error.date.incorrect.format", this.dateFieldFormat.getFormatHint());
        }
    }

    private VersionModel toModel(ApplicationUser user, Project project, Version version, VersionMetaData versionMetaData) {
        VersionModel model = new VersionModel();
        model.id = version.getId();
        model.projectId = project.getId();
        model.name = version.getName();
        model.description = version.getDescription();
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.DATE_PICKER);
        if (version.getReleaseDate() != null) {
            model.releaseDate = dateTimeFormatter.format(version.getReleaseDate());
        }
        if (versionMetaData.getStartDate() != null) {
            model.startDate = dateTimeFormatter.format(versionMetaData.getStartDate());
        }
        return model;
    }

    private ServiceOutcome<Project> validateProject(ApplicationUser user, Long projectId) {
        Project project;
        if (projectId != null && (project = this.projectManager.getProjectObj(projectId)) != null) {
            ServiceOutcome<Void> permission = this.versionPermissionService.canCreateAnyVersion(user, Collections.singleton(project));
            if (permission.isInvalid()) {
                return ServiceOutcomeImpl.error(permission);
            }
            return ServiceOutcomeImpl.ok(project);
        }
        return ServiceOutcomeImpl.error("projectId", ErrorCollection.Reason.VALIDATION_FAILED, "gh.version.error.specify.project", new Object[0]);
    }

    @XmlRootElement
    public static class VersionModel
    extends RestTemplate {
        @XmlElement
        Long id;
        @XmlElement
        Long projectId;
        @XmlElement
        String name;
        @XmlElement
        String description;
        @XmlElement
        String releaseDate;
        @XmlElement
        String startDate;
    }
}

