/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.tools;

import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonValue;

@JsonAutoDetect
public final class RapidBoardToolsElement
extends RestTemplate {
    private final String id;
    private final String label;
    private final List<RapidBoardToolsElement> subItems;
    private final String url;
    private final String html;
    private final Type type;
    private final String cssClass;

    private RapidBoardToolsElement() {
        this("", "", Collections.emptyList(), "", "", "");
    }

    private RapidBoardToolsElement(String id, String label, Iterable<RapidBoardToolsElement> subItems, String url, String html, String cssClass) {
        this.id = id;
        this.label = label;
        this.subItems = ImmutableList.copyOf(subItems);
        this.url = url;
        this.html = html;
        this.type = url == null && html == null ? Type.SECTION : (html != null ? Type.WEB_PANEL : Type.WEB_ITEM);
        this.cssClass = Strings.nullToEmpty((String)cssClass);
    }

    public static RapidBoardToolsElement section(String id, String title, Iterable<RapidBoardToolsElement> items) {
        return new RapidBoardToolsElement(id, title, items, null, null, null);
    }

    public static RapidBoardToolsElement webPanel(String id, String html) {
        return new RapidBoardToolsElement(id, null, Collections.emptyList(), null, html, null);
    }

    public static RapidBoardToolsElement webItem(String id, String title, String url) {
        return new RapidBoardToolsElement(id, title, Collections.emptyList(), url, null, null);
    }

    public RapidBoardToolsElement withCssClass(String css) {
        return new RapidBoardToolsElement(this.id, this.label, this.subItems, this.url, this.html, css);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public List<RapidBoardToolsElement> getSubItems() {
        return this.subItems;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getHtml() {
        return this.html;
    }

    public Type getType() {
        return this.type;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public RapidBoardToolsElement withSubItems(Iterable<RapidBoardToolsElement> subItems) {
        return new RapidBoardToolsElement(this.id, this.label, subItems, this.url, this.html, this.cssClass);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.id, this.label, this.subItems, this.url, this.html, this.type, this.cssClass});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RapidBoardToolsElement other = (RapidBoardToolsElement)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.label, (Object)other.label) && Objects.equal(this.subItems, other.subItems) && Objects.equal((Object)this.url, (Object)other.url) && Objects.equal((Object)this.html, (Object)other.html) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.cssClass, (Object)other.cssClass);
    }

    public static enum Type {
        SECTION("section"),
        WEB_ITEM("webItem"),
        WEB_PANEL("webPanel");

        private final String name;

        private Type(String frontEndName) {
            this.name = frontEndName;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }
}

