/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.tools;

import com.atlassian.greenhopper.web.rapid.tools.BoardToolSectionContext;
import com.atlassian.greenhopper.web.rapid.tools.ElementUtils;
import com.atlassian.greenhopper.web.rapid.tools.RapidBoardToolsElement;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class BoardToolSectionsResolver {
    private static final String RAPID_BOARD_TOOLS_LOCATION = "jira.agile.board.tools";
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;

    @Autowired
    public BoardToolSectionsResolver(DynamicWebInterfaceManager dynamicWebInterfaceManager) {
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
    }

    public List<RapidBoardToolsElement> getSections(BoardToolSectionContext context) {
        return new ResolverInContext(context).getElements(RAPID_BOARD_TOOLS_LOCATION).map(ElementUtils::addTopLevelSectionIfNotPresent).collect(Collectors.toList());
    }

    private static class WeightedElement {
        public final RapidBoardToolsElement element;
        public final int weight;

        public WeightedElement(RapidBoardToolsElement element, int weight) {
            this.element = element;
            this.weight = weight;
        }

        public RapidBoardToolsElement getElement() {
            return this.element;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    private class ResolverInContext {
        private final BoardToolSectionContext context;
        private final Map<String, Object> contextMap;

        public ResolverInContext(BoardToolSectionContext context) {
            this.context = context;
            this.contextMap = context.toMap();
        }

        public Stream<RapidBoardToolsElement> getElements(String location) {
            Stream<WeightedElement> webSections = BoardToolSectionsResolver.this.dynamicWebInterfaceManager.getDisplayableSections(location, this.contextMap).stream().map(SafePluginPointAccess.safe(input -> {
                List<RapidBoardToolsElement> elements = this.getElements(input.getKey()).collect(Collectors.toList());
                return new WeightedElement(RapidBoardToolsElement.section(input.getKey(), this.getLabel(input.getWebLabel()), elements).withCssClass((String)input.getParams().get("styleClass")), input.getWeight());
            })::apply);
            Stream<WeightedElement> webItems = BoardToolSectionsResolver.this.dynamicWebInterfaceManager.getDisplayableItems(location, this.contextMap).stream().map(SafePluginPointAccess.safe(input -> {
                String url = this.getUrl((WebItemModuleDescriptor)input);
                return new WeightedElement(RapidBoardToolsElement.webItem(input.getLink().getId(), this.getLabel(input.getWebLabel()), url).withCssClass(input.getStyleClass()), input.getWeight());
            })::apply);
            Stream<WeightedElement> webPanels = BoardToolSectionsResolver.this.dynamicWebInterfaceManager.getDisplayableWebPanelDescriptors(location, this.contextMap).stream().map(SafePluginPointAccess.safe(input -> {
                WebPanel webPanel = (WebPanel)input.getModule();
                return new WeightedElement(RapidBoardToolsElement.webPanel(input.getKey(), webPanel.getHtml(this.contextMap)), input.getWeight());
            })::apply);
            return Stream.of(webItems, webPanels, webSections).flatMap(x -> x).sorted(Ordering.natural().onResultOf(WeightedElement::getWeight)).map(WeightedElement::getElement);
        }

        private String getLabel(WebLabel webLabel) {
            return webLabel != null ? webLabel.getDisplayableLabel(this.context.getRequest(), this.contextMap) : null;
        }

        private String getUrl(WebItemModuleDescriptor input) {
            WebLink link = input.getLink();
            return link == null || Strings.nullToEmpty((String)link.getRenderedUrl(this.contextMap)).isEmpty() ? "#" : link.getDisplayableUrl(this.context.getRequest(), this.contextMap);
        }
    }
}

