/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.tools;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.annotate.JsonValue;

public final class BoardToolSectionContext {
    static final String AGILE_BOARD_ID = "agileBoard.id";
    static final String AGILE_BOARD_MODE = "agileBoard.mode";
    private static final String REQUEST = "request";
    private final Mode mode;
    private final HttpServletRequest request;
    private final RapidView rapidView;

    public BoardToolSectionContext(RapidView rapidView, Mode mode, HttpServletRequest request) {
        this.rapidView = rapidView;
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.request = (HttpServletRequest)Preconditions.checkNotNull((Object)request);
    }

    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)AGILE_BOARD_ID, (Object)this.rapidView.getId()).put((Object)AGILE_BOARD_MODE, (Object)this.mode).put((Object)"board", (Object)this.rapidView).put((Object)"board.screen", (Object)this.mode.toString()).put((Object)"agileBoard", (Object)ImmutableMap.of((Object)"id", (Object)this.rapidView.getId(), (Object)"mode", (Object)((Object)this.mode), (Object)"modeName", (Object)this.mode.toString())).put((Object)REQUEST, (Object)this.request).build();
    }

    public Mode getMode() {
        return this.mode;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public RapidView getRapidView() {
        return this.rapidView;
    }

    public static enum Mode {
        PLAN("plan"),
        WORK("work"),
        REPORT("report");

        private final String name;

        private Mode(String frontEndName) {
            this.name = frontEndName;
        }

        public static Mode fromName(String name) {
            for (Mode mode : Mode.values()) {
                if (!mode.toString().equals(name)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unrecognized mode: " + name);
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }
}

