/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint.model;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.jira.issue.Issue;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RemoveFromSprintModel
extends RestTemplate {
    @XmlElement
    public Collection<RemoveFromSprintEntryModel> changes = Lists.newArrayList();
    @XmlElement
    public Long rapidViewId;

    public static RemoveFromSprintModel toResult(RapidView rapidView, Map<Sprint, List<Issue>> sprintToIssues, Set<Issue> doneIssues, SprintHelper.FutureSprintMapping futureSprintMapping, SprintEditEntryTransformer sprintEditEntryTransformer) {
        RemoveFromSprintModel result = new RemoveFromSprintModel();
        result.rapidViewId = rapidView.getId();
        for (Map.Entry<Sprint, List<Issue>> e : sprintToIssues.entrySet()) {
            RemoveFromSprintEntryModel data = new RemoveFromSprintEntryModel();
            data.currentSprint = (SprintEditEntry)sprintEditEntryTransformer.apply(e.getKey());
            Sprint newSprint = futureSprintMapping.getNextSprint(e.getKey());
            if (newSprint != null) {
                data.targetSprint = (SprintEditEntry)sprintEditEntryTransformer.apply(newSprint);
            }
            for (Issue issue : e.getValue()) {
                if (doneIssues.contains(issue)) {
                    data.doneIssueKeys.add(issue.getKey());
                    continue;
                }
                data.issueKeys.add(issue.getKey());
            }
            result.changes.add(data);
        }
        return result;
    }

    @XmlRootElement
    public static class RemoveFromSprintEntryModel
    extends RestTemplate {
        @XmlElement
        SprintEditEntry currentSprint;
        @XmlElement
        SprintEditEntry targetSprint;
        @XmlElement
        public Collection<String> issueKeys = Lists.newArrayList();
        @XmlElement
        public Collection<String> doneIssueKeys = Lists.newArrayList();
    }
}

