/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.StartSprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.model.StartSprintModel;
import com.atlassian.greenhopper.web.rapid.sprint.model.StartSprintRequest;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import io.atlassian.fugue.Option;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

@Path(value="sprint/{sprintId}/start")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StartSprintResource
extends AbstractResource {
    private static final Duration SPRINT_INITIAL_SCOPE_WINDOW = Duration.standardMinutes((long)5L);
    private static final int DEFAULT_SPRINT_DURATION = 2;
    private final RapidViewService rapidViewService;
    private final SprintService sprintService;
    private final StartSprintHelper startSprintHelper;
    private final DateTimeFormatter dateTimeFormatterFactory;
    private final SprintEntryFactory sprintEntryFactory;
    private final SprintHelper sprintHelper;

    public StartSprintResource(RapidViewService rapidViewService, SprintService sprintService, StartSprintHelper startSprintHelper, DateTimeFormatter dateTimeFormatterFactory, SprintEntryFactory sprintEntryFactory, SprintHelper sprintHelper) {
        this.rapidViewService = rapidViewService;
        this.sprintService = sprintService;
        this.startSprintHelper = startSprintHelper;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintHelper = sprintHelper;
    }

    @GET
    public Response getModel(final @QueryParam(value="rapidViewId") Long rapidViewId, final @PathParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = StartSprintResource.this.getUser();
                RapidView rapidView = StartSprintResource.this.check(StartSprintResource.this.rapidViewService.getRapidView(user, rapidViewId));
                Sprint sprint = StartSprintResource.this.check(StartSprintResource.this.sprintService.getSprint(user, sprintId));
                StartSprintHelper.IssuesForSprint issuesForSprint = StartSprintResource.this.check(StartSprintResource.this.startSprintHelper.loadIssuesInSprint(user, rapidView, sprint));
                DateTimeFormatter dateTimeFormatter = StartSprintResource.this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.DATE_TIME_PICKER);
                Pair sprintDates = StartSprintResource.this.getSprintDates(sprint);
                ServiceOutcome<Option<Sprint>> result = StartSprintResource.this.sprintService.getLastCompletedSprint(user, rapidView);
                if (result.isValid() && result.getValue().isDefined()) {
                    sprintDates = StartSprintResource.this.adjustedSprintDates((Pair<DateTime, DateTime>)sprintDates, (Sprint)result.getValue().get());
                }
                StartSprintModel model = new StartSprintModel();
                model.rapidViewId = rapidView.getId();
                model.sprintId = sprint.getId();
                model.issuesForSprint = issuesForSprint.getIssueKeys();
                model.numIssues = model.issuesForSprint.size();
                model.countNotEstimatedIssues = issuesForSprint.getCountNotEstimatedIssues();
                model.issuesNotEstimated = issuesForSprint.getNotEstimatedIssueKeys();
                model.noTrackingEstimateIssueCount = issuesForSprint.getNoTrackingEstimateIssueCount();
                model.noTrackingEstimateIssues = issuesForSprint.getNoTrackingEstimateIssueKeys();
                model.totalStatistic = issuesForSprint.getStatsValue();
                model.defaultName = sprint.getName();
                model.defaultStartDate = dateTimeFormatter.format(((DateTime)sprintDates.first()).toDate());
                model.defaultEndDate = dateTimeFormatter.format(((DateTime)sprintDates.second()).toDate());
                model.dateTimePickerFormat = CustomFieldUtils.getDateTimeFormat();
                model.hasNoSubtaskDoneStatus = issuesForSprint.hasNoSubtaskDoneStatus();
                model.goal = sprint.getGoal();
                return StartSprintResource.this.createOkResponse(model);
            }
        });
    }

    @PUT
    public Response startSprint(final StartSprintRequest request) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = StartSprintResource.this.getUser();
                StartSprintResource.this.check(StartSprintResource.this.rapidViewService.getRapidView(user, request.rapidViewId));
                Sprint sprint = StartSprintResource.this.check(StartSprintResource.this.sprintService.getSprint(user, request.sprintId));
                Pair dates = (Pair)StartSprintResource.this.check(StartSprintResource.this.parseDatesForStartSprint(user, request));
                DateTime startDate = (DateTime)dates.first();
                DateTime now = DateTime.now();
                if (startDate.isBefore((ReadableInstant)now.plus((ReadableDuration)SPRINT_INITIAL_SCOPE_WINDOW))) {
                    startDate = startDate.withSecondOfMinute(now.getSecondOfMinute()).withMillisOfSecond(now.getMillisOfSecond());
                }
                Sprint updatedSprint = Sprint.builder(sprint).name(StringUtils.trimToEmpty((String)request.name)).state(Sprint.State.ACTIVE).startDate(startDate).endDate((DateTime)dates.second()).goal(StringUtils.trimToEmpty((String)request.goal)).build();
                Sprint resultSprint = StartSprintResource.this.check(StartSprintResource.this.sprintService.updateSprint(user, updatedSprint));
                return StartSprintResource.this.createOkResponse((RestTemplate)StartSprintResource.this.sprintEntryFactory.newBaseTransformer(user).apply(resultSprint));
            }
        });
    }

    private ServiceOutcome<Pair<DateTime, DateTime>> parseDatesForStartSprint(ApplicationUser user, StartSprintRequest request) {
        Pair<DateTime, DateTime> dates = this.check(this.sprintHelper.parseDates(user, request.startDate, request.endDate));
        if (dates.first() == null || dates.second() == null) {
            ErrorCollection errors = new ErrorCollection();
            if (dates.first() == null) {
                errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.start.date.required", new Object[0]);
            }
            if (dates.second() == null) {
                errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.end.date.required", new Object[0]);
            }
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok(dates);
    }

    private Pair<DateTime, DateTime> getSprintDates(Sprint sprint) {
        DateTime endDate;
        DateTime startDate = sprint.getStartDate();
        if (startDate == null) {
            startDate = new DateTime();
        }
        if ((endDate = sprint.getEndDate()) == null) {
            endDate = startDate.plusWeeks(2);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    private Pair<DateTime, DateTime> adjustedSprintDates(Pair<DateTime, DateTime> defaultSprint, Sprint prevSprint) {
        Pair<DateTime, DateTime> lastSprintDates = this.getSprintDates(prevSprint);
        Period prevLength = new Period((ReadableInstant)((DateTime)lastSprintDates.first()).minuteOfDay().roundFloorCopy(), (ReadableInstant)((DateTime)lastSprintDates.second()).minuteOfDay().roundFloorCopy());
        return Pair.of((Object)defaultSprint.first(), (Object)((DateTime)defaultSprint.first()).plus((ReadablePeriod)prevLength));
    }
}

