/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartSprintHelper {
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private RapidViewClauseService rapidViewClauseService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private TimeTrackingService timeTrackingService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private WorkflowService workflowService;

    @Nonnull
    public ServiceOutcome<IssuesForSprint> loadIssuesInSprint(ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ServiceOutcome<Boolean> hasNoSubtaskDoneStatus;
        StatisticsField estimateStatistic;
        DocumentStatisticValueResolver estimateDocumentStatisticValueResolver;
        IssueKeysAndStatisticsCallback callback;
        ServiceOutcome<ClauseToAdd> definitionOfNotDoneClause = this.rapidViewClauseService.getDefinitionOfNotDoneClause(user, rapidView);
        if (definitionOfNotDoneClause.isInvalid()) {
            return ServiceOutcomeImpl.error(definitionOfNotDoneClause);
        }
        Query query = JqlQueryBuilder.newBuilder().where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).addClause(definitionOfNotDoneClause.get().getClause()).buildQuery();
        ServiceOutcome<Void> outcome = this.issueDataService.findAndSort(user, query, callback = new IssueKeysAndStatisticsCallback(sprint, estimateDocumentStatisticValueResolver = this.statisticValueResolverFactory.forEstimationStatisticInDocument(estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView)), this.estimateStatisticService));
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        ErrorCollection errors = new ErrorCollection();
        LinkedHashSet<Issue> issueObjectsForSprint = new LinkedHashSet<Issue>();
        ArrayList<String> issueKeysForSprint = new ArrayList<String>();
        LinkedHashSet<Issue> subtasks = new LinkedHashSet<Issue>();
        for (String key : callback.getIssueKeys()) {
            IssueService.IssueResult issueResult = this.issueService.getIssue(user, key);
            if (!issueResult.isValid()) {
                errors.addError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.issue.by.key.not.found", key);
                continue;
            }
            if (!issueResult.getIssue().isSubTask()) {
                issueKeysForSprint.add(key);
                issueObjectsForSprint.add((Issue)issueResult.getIssue());
                continue;
            }
            subtasks.add((Issue)issueResult.getIssue());
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome<List<String>> issuesWithoutTrackingEstimate = this.getIssueWithoutTrackingEstimate(user, rapidView, sprint, issueObjectsForSprint);
        if (!issuesWithoutTrackingEstimate.isValid()) {
            return ServiceOutcomeImpl.from(issuesWithoutTrackingEstimate.getErrors());
        }
        List<String> noTrackingEstimateIssueKeys = issuesWithoutTrackingEstimate.get();
        int noTrackingEstimateIssueCount = noTrackingEstimateIssueKeys.size();
        if (noTrackingEstimateIssueCount > 4) {
            noTrackingEstimateIssueKeys = noTrackingEstimateIssueKeys.subList(0, 4);
        }
        if ((hasNoSubtaskDoneStatus = this.hasNoSubtaskDoneStatus(rapidView, subtasks)).isInvalid()) {
            return ServiceOutcomeImpl.error(hasNoSubtaskDoneStatus);
        }
        IssuesForSprint issuesForSprint = new IssuesForSprint();
        issuesForSprint.issueKeys = issueKeysForSprint;
        issuesForSprint.issues = issueObjectsForSprint;
        issuesForSprint.statsValue = callback.getStatsValue();
        issuesForSprint.countNotEstimatedIssues = callback.getCountNotEstimatedIssues();
        issuesForSprint.notEstimatedIssueKeys = callback.getIssuesNotEstimated();
        issuesForSprint.noTrackingEstimateIssueKeys = noTrackingEstimateIssueKeys;
        issuesForSprint.noTrackingEstimateIssueCount = noTrackingEstimateIssueCount;
        issuesForSprint.hasNoSubtaskDoneStatus = hasNoSubtaskDoneStatus.getValue();
        return ServiceOutcomeImpl.ok(issuesForSprint);
    }

    @VisibleForTesting
    ServiceOutcome<Boolean> hasNoSubtaskDoneStatus(@Nonnull RapidView rapidView, @Nonnull Set<Issue> subtasks) {
        Preconditions.checkNotNull((Object)rapidView);
        Preconditions.checkNotNull(subtasks);
        if (subtasks.isEmpty()) {
            return ServiceOutcomeImpl.ok(false);
        }
        final Set<Status> doneColumnStatuses = this.columnService.getProgressStatuses(rapidView).getDone();
        Set<JiraWorkflow> workflows = this.workflowService.getJiraWorkflows(subtasks);
        if (!subtasks.isEmpty() && workflows.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Error while retrieving Jira workflows", new Object[0]);
        }
        HashSet subtaskStatuses = new HashSet();
        for (JiraWorkflow workflow : workflows) {
            subtaskStatuses.addAll(workflow.getLinkedStatusObjects());
        }
        boolean result = !Iterables.any(subtaskStatuses, (Predicate)new Predicate<Status>(){

            public boolean apply(Status status) {
                return doneColumnStatuses.contains(status);
            }
        });
        return ServiceOutcomeImpl.ok(result);
    }

    private ServiceOutcome<List<String>> getIssueWithoutTrackingEstimate(ApplicationUser user, RapidView rapidView, Sprint sprint, Set<Issue> parentIssues) {
        StatisticsField trackingStatistic = this.trackingStatisticService.getTrackingStatistic(rapidView);
        if (!this.trackingStatisticService.isRemainingEstimateStatisticsField(trackingStatistic)) {
            List none = Collections.emptyList();
            return ServiceOutcomeImpl.ok(none);
        }
        ServiceOutcome<Map<Issue, Set<Issue>>> parentsAndChildren = this.getParentsWithChildren(user, rapidView, sprint, parentIssues);
        if (!parentsAndChildren.isValid()) {
            return ServiceOutcomeImpl.error(parentsAndChildren);
        }
        ArrayList<String> withoutEstimate = new ArrayList<String>();
        for (Issue parentIssue : parentIssues) {
            Set<Issue> childIssues;
            AggregateTimeTrackingBean aggregates = this.timeTrackingService.getAggregates(parentIssue, childIssues = parentsAndChildren.getValue().get(parentIssue));
            Long remainingEstimate = aggregates.getRemainingEstimate();
            if (remainingEstimate != null && remainingEstimate != 0L) continue;
            withoutEstimate.add(parentIssue.getKey());
        }
        return ServiceOutcomeImpl.ok(withoutEstimate);
    }

    private ServiceOutcome<Map<Issue, Set<Issue>>> getParentsWithChildren(ApplicationUser user, RapidView rapidView, Sprint sprint, Set<Issue> parentIssues) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        ServiceOutcome<ClauseToAdd> definitionOfNotDoneClause = this.rapidViewClauseService.getDefinitionOfNotDoneClause(user, rapidView);
        if (definitionOfNotDoneClause.isInvalid()) {
            return ServiceOutcomeImpl.error(definitionOfNotDoneClause);
        }
        HashSet<String> parentKeys = new HashSet<String>();
        for (Issue issue : parentIssues) {
            parentKeys.add(issue.getKey());
        }
        Query subsQuery = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).addClause(definitionOfNotDoneClause.get().getClause()).issueTypeIsSubtask().issueParent(parentKeys.toArray(new String[0])).buildQuery();
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, subsQuery);
        if (!search.isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        HashMap<Long, HashSet<Issue>> parentIdToSubtasks = new HashMap<Long, HashSet<Issue>>();
        for (Issue subtask : search.getValue().getResults()) {
            HashSet<Issue> issues = (HashSet<Issue>)parentIdToSubtasks.get(subtask.getParentId());
            if (issues == null) {
                issues = new HashSet<Issue>();
                parentIdToSubtasks.put(subtask.getParentId(), issues);
            }
            issues.add(subtask);
        }
        HashMap parentsToSubs = new HashMap();
        for (Issue parentIssue : parentIssues) {
            HashSet subtasks = (HashSet)parentIdToSubtasks.get(parentIssue.getId());
            if (subtasks == null) {
                subtasks = new HashSet();
            }
            parentsToSubs.put(parentIssue, subtasks);
        }
        return ServiceOutcomeImpl.ok(parentsToSubs);
    }

    public static class IssueKeysAndStatisticsCallback
    extends AbstractCompoundDataCallback {
        private List<String> issueKeys;
        private List<String> issuesNotEstimated;
        private final Sprint sprint;
        private final DocumentStatisticValueResolver documentStatisticValueResolver;
        private final EstimateStatisticService estimateStatisticService;
        private double statsValue;
        private int countNotEstimatedIssues;
        private final String statisticDocumentId;
        private static final int MAX_ISSUES_NOT_ESTIMATED_COLLECTED = 4;

        public IssueKeysAndStatisticsCallback(Sprint sprint, DocumentStatisticValueResolver documentStatisticValueResolver, EstimateStatisticService estimateStatisticService) {
            this.sprint = sprint;
            this.documentStatisticValueResolver = documentStatisticValueResolver;
            this.estimateStatisticService = estimateStatisticService;
            this.statisticDocumentId = this.documentStatisticValueResolver.getDocumentId();
            this.issueKeys = new ArrayList<String>();
            this.issuesNotEstimated = new ArrayList<String>(4);
            this.statsValue = 0.0;
            this.countNotEstimatedIssues = 0;
        }

        @Override
        protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
            this.issueKeys.add(issueKey);
            Double value = this.documentStatisticValueResolver.getValue(data.get(this.statisticDocumentId));
            if (value != null) {
                this.statsValue += value.doubleValue();
            } else if (!this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(this.documentStatisticValueResolver.getStatisticsField(), Long.valueOf(data.get("projid")), data.get("type"))) {
                ++this.countNotEstimatedIssues;
                if (this.issuesNotEstimated.size() < 4) {
                    this.issuesNotEstimated.add(issueKey);
                }
            }
        }

        @Override
        public Set<String> getFields() {
            return CollectionBuilder.newBuilder((Object[])new String[]{"key", "projid", "type", this.statisticDocumentId}).asSet();
        }

        public double getStatsValue() {
            return this.statsValue;
        }

        public int getCountNotEstimatedIssues() {
            return this.countNotEstimatedIssues;
        }

        public List<String> getIssuesNotEstimated() {
            return this.issuesNotEstimated;
        }

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }
    }

    public static class IssuesForSprint {
        List<String> issueKeys;
        Set<Issue> issues;
        boolean hasNoSubtaskDoneStatus;
        double statsValue;
        int countNotEstimatedIssues;
        int noTrackingEstimateIssueCount;
        List<String> notEstimatedIssueKeys;
        List<String> noTrackingEstimateIssueKeys;

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }

        public Set<Issue> getIssues() {
            return this.issues;
        }

        public double getStatsValue() {
            return this.statsValue;
        }

        public int getCountNotEstimatedIssues() {
            return this.countNotEstimatedIssues;
        }

        public List<String> getNotEstimatedIssueKeys() {
            return this.notEstimatedIssueKeys;
        }

        public int getNoTrackingEstimateIssueCount() {
            return this.noTrackingEstimateIssueCount;
        }

        public List<String> getNoTrackingEstimateIssueKeys() {
            return this.noTrackingEstimateIssueKeys;
        }

        public boolean hasNoSubtaskDoneStatus() {
            return this.hasNoSubtaskDoneStatus;
        }
    }
}

