/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.greenhopper.web.rapid.sprint.CompleteSprintStats;
import com.atlassian.greenhopper.web.rapid.sprint.ReopenSprintStats;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintStatusChangeHelper {
    private static final Function<Issue, Long> ISSUE_TO_ID_FUNCTION = new Function<Issue, Long>(){

        public Long apply(@Nullable Issue input) {
            if (input != null) {
                return input.getId();
            }
            return null;
        }
    };
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private RapidViewClauseService rapidViewClauseService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;

    @Nonnull
    public ServiceOutcome<CompleteSprintStats> getCompleteSprintStatistics(ApplicationUser user, Sprint sprint, RapidView rapidView) {
        ServiceOutcome<SearchResults<Issue>> unfinishedIssuesSearchResult;
        Query baseQuery = JqlQueryBuilder.newBuilder().where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).buildQuery();
        Query storyCountQuery = JqlQueryBuilder.newBuilder((Query)baseQuery).where().and().addClause(JqlQueryBuilder.newClauseBuilder().issueTypeIsStandard().buildClause()).buildQuery();
        ServiceOutcome<Long> totalCount = this.searchService.searchCount(user, storyCountQuery);
        if (totalCount.isInvalid()) {
            return ServiceOutcomeImpl.error(totalCount);
        }
        ServiceOutcome<ClauseToAdd> definitionOfNotDone = this.rapidViewClauseService.getDefinitionOfNotDoneClause(user, rapidView);
        if (!definitionOfNotDone.isValid()) {
            return ServiceOutcomeImpl.error(definitionOfNotDone);
        }
        JqlQueryBuilder unfinishedIssuesQueryBuilder = JqlQueryBuilder.newBuilder((Query)baseQuery);
        if (definitionOfNotDone.getValue().hasClause()) {
            definitionOfNotDone.getValue().appendWithDefaultAnd(unfinishedIssuesQueryBuilder);
        }
        if (!(unfinishedIssuesSearchResult = this.searchService.searchOverrideSecurity(user, unfinishedIssuesQueryBuilder.buildQuery())).isValid()) {
            return ServiceOutcomeImpl.error(unfinishedIssuesSearchResult);
        }
        List unfinishedIssues = unfinishedIssuesSearchResult.getValue().getResults();
        Set<Issue> unfinishedParents = this.getParentTasks(unfinishedIssues);
        Set<Issue> unfinishedSubtasks = this.getSubTasks(unfinishedIssues);
        Set<Issue> parentsWithUnfinishedSubtasks = this.getParentsWithUnfinishedSubtasks(unfinishedParents, unfinishedSubtasks);
        Set<Issue> unfinishedParentsOfFinishedSubtasks = this.getUnfinishedParentsOfFinishedSubtasks(unfinishedParents, unfinishedSubtasks);
        Set<Issue> partiallyCompleteParents = this.getPartiallyCompleteParents(unfinishedParents, unfinishedSubtasks);
        LinkedList<String> parentKeysOfUnfinishedSubtasks = new LinkedList<String>();
        for (Issue issue : parentsWithUnfinishedSubtasks) {
            parentKeysOfUnfinishedSubtasks.add(issue.getKey());
        }
        LinkedList<String> unfinishedParentKeysOfFinishedSubtasks = new LinkedList<String>();
        for (Issue issue : unfinishedParentsOfFinishedSubtasks) {
            unfinishedParentKeysOfFinishedSubtasks.add(issue.getKey());
        }
        CompleteSprintStats completeSprintStats = new CompleteSprintStats();
        completeSprintStats.setIncompleteIssueCount(unfinishedParents.size() - partiallyCompleteParents.size());
        completeSprintStats.setCompleteIssueCount(totalCount.get() - completeSprintStats.getIncompleteIssueCount() - (long)parentKeysOfUnfinishedSubtasks.size() - (long)partiallyCompleteParents.size());
        completeSprintStats.setPartiallyCompleteIssueCount(partiallyCompleteParents.size());
        completeSprintStats.setFinishedParentsWithUnfinishedSubtasks(parentKeysOfUnfinishedSubtasks);
        completeSprintStats.setUnfinishedParentKeysOfFinishedSubtasks(unfinishedParentKeysOfFinishedSubtasks);
        return ServiceOutcomeImpl.ok(completeSprintStats);
    }

    @Nonnull
    public ServiceOutcome<ReopenSprintStats> getReopenSprintStatistics(ApplicationUser user, Sprint sprint, RapidView rapidView) {
        ServiceOutcome<List<Issue>> unfinishedIssuesOutcome = this.getIncompleteParentIssuesFromSprint(user, sprint, rapidView);
        if (unfinishedIssuesOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(unfinishedIssuesOutcome);
        }
        List<Issue> unfinishedIssues = unfinishedIssuesOutcome.getValue();
        ArrayList unfinishedIssuesThatArePartOfAnotherActiveSprint = Lists.newArrayList((Iterable)Iterables.filter(unfinishedIssues, this.areIssuesPartOfAnotherActiveSprint(sprint)));
        ServiceOutcome<List<Issue>> finishedIssuesOutcome = this.getCompletedIssuesFromSprint(user, sprint, rapidView);
        if (finishedIssuesOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(finishedIssuesOutcome);
        }
        ArrayList finishedIssues = Lists.newArrayList((Iterable)Iterables.filter((Iterable)finishedIssuesOutcome.getValue(), (Predicate)StandardIssueType.issueTypeIsStandard()));
        int originalNumberOfFinishedIssues = finishedIssues.size();
        ArrayList finishedIssuesThatArePartOfAnotherActiveSprint = Lists.newArrayList((Iterable)Iterables.filter((Iterable)finishedIssues, this.areIssuesPartOfAnotherActiveSprint(sprint)));
        finishedIssues.removeAll(finishedIssuesThatArePartOfAnotherActiveSprint);
        ArrayList finishedIssuesThatWereDoneInAnotherSprint = Lists.newArrayList((Iterable)Iterables.filter((Iterable)finishedIssues, this.wereIssuesCompletedInAnotherSprint(sprint)));
        ReopenSprintStats stats = new ReopenSprintStats();
        stats.setIncompleteIssuesNotMovedBack(unfinishedIssuesThatArePartOfAnotherActiveSprint.size() + finishedIssuesThatArePartOfAnotherActiveSprint.size());
        stats.setCompletedIssuesNotMovedBack(finishedIssuesThatWereDoneInAnotherSprint.size());
        stats.setIssuesMovedBack(originalNumberOfFinishedIssues + unfinishedIssues.size() - (unfinishedIssuesThatArePartOfAnotherActiveSprint.size() + finishedIssuesThatWereDoneInAnotherSprint.size() + finishedIssuesThatArePartOfAnotherActiveSprint.size()));
        return ServiceOutcomeImpl.ok(stats);
    }

    ServiceOutcome<List<Issue>> getCompletedIssuesFromSprint(ApplicationUser user, Sprint sprint, RapidView rapidView) {
        ServiceOutcome<SearchResults<Issue>> finishedIssuesSearchResult;
        Query baseQuery = JqlQueryBuilder.newBuilder().where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).buildQuery();
        ServiceOutcome<ClauseToAdd> definitionOfDone = this.rapidViewClauseService.getClauseForBuilder(user, rapidView, RapidViewClauseService.ClauseType.DEFINITION_OF_DONE);
        if (!definitionOfDone.isValid()) {
            return ServiceOutcomeImpl.error(definitionOfDone);
        }
        JqlQueryBuilder finishedIssuesQueryBuilder = JqlQueryBuilder.newBuilder((Query)baseQuery);
        if (definitionOfDone.getValue().hasClause()) {
            definitionOfDone.getValue().appendWithDefaultAnd(finishedIssuesQueryBuilder);
        }
        if (!(finishedIssuesSearchResult = this.searchService.searchOverrideSecurity(user, finishedIssuesQueryBuilder.buildQuery())).isValid()) {
            return ServiceOutcomeImpl.error(finishedIssuesSearchResult);
        }
        List finishedIssues = finishedIssuesSearchResult.getValue().getResults();
        return ServiceOutcomeImpl.ok(finishedIssues);
    }

    private Set<Issue> getParentTasks(Collection<Issue> issues) {
        HashSet<Issue> parents = new HashSet<Issue>();
        for (Issue issue : issues) {
            if (issue.isSubTask()) continue;
            parents.add(issue);
        }
        return parents;
    }

    private Set<Issue> getSubTasks(Collection<Issue> issues) {
        HashSet<Issue> subtasks = new HashSet<Issue>();
        for (Issue issue : issues) {
            if (!issue.isSubTask()) continue;
            subtasks.add(issue);
        }
        return subtasks;
    }

    private Set<Issue> getParentsWithUnfinishedSubtasks(Set<Issue> unfinishedParents, Set<Issue> unfinishedSubtasks) {
        HashSet<Issue> finishedParentsOfUnfinishedSubTasks = new HashSet<Issue>();
        HashSet<Long> finishedParentsOfUnfinishedSubTasks_ids = new HashSet<Long>();
        HashSet unfinishedParents_ids = Sets.newHashSet((Iterable)Iterables.transform(unfinishedParents, ISSUE_TO_ID_FUNCTION));
        for (Issue unfinishedSubtask : unfinishedSubtasks) {
            Issue parentIssue = unfinishedSubtask.getParentObject();
            if (unfinishedParents_ids.contains(parentIssue.getId())) continue;
            finishedParentsOfUnfinishedSubTasks_ids.add(parentIssue.getId());
        }
        for (Long id : finishedParentsOfUnfinishedSubTasks_ids) {
            finishedParentsOfUnfinishedSubTasks.add((Issue)this.issueManager.getIssueObject(id));
        }
        return finishedParentsOfUnfinishedSubTasks;
    }

    private Set<Issue> getUnfinishedParentsOfFinishedSubtasks(Set<Issue> unfinishedParents, Set<Issue> unfinishedSubtasks) {
        HashSet<Issue> unfinishedParentsOfFinishedSubtasks = new HashSet<Issue>();
        HashSet<Long> unfinishedParentsOfFinishedSubtasks_ids = new HashSet<Long>();
        HashSet unfinishedSubtasks_ids = Sets.newHashSet((Iterable)Iterables.transform(unfinishedSubtasks, ISSUE_TO_ID_FUNCTION));
        for (Issue unfinishedParent : unfinishedParents) {
            Collection subtasks = unfinishedParent.getSubTaskObjects();
            if (subtasks.isEmpty()) continue;
            boolean unfinishedSubtaskFound = false;
            for (Issue subtask : subtasks) {
                if (!unfinishedSubtasks_ids.contains(subtask.getId())) continue;
                unfinishedSubtaskFound = true;
            }
            if (unfinishedSubtaskFound) continue;
            unfinishedParentsOfFinishedSubtasks_ids.add(unfinishedParent.getId());
        }
        for (Long id : unfinishedParentsOfFinishedSubtasks_ids) {
            unfinishedParentsOfFinishedSubtasks.add((Issue)this.issueManager.getIssueObject(id));
        }
        return unfinishedParentsOfFinishedSubtasks;
    }

    private Set<Issue> getPartiallyCompleteParents(Set<Issue> unfinishedParents, Set<Issue> unfinishedSubtasks) {
        HashSet<Issue> partiallyCompleteParents = new HashSet<Issue>();
        HashSet<Long> partiallyCompleteParents_ids = new HashSet<Long>();
        HashSet unfinishedSubtasks_ids = Sets.newHashSet((Iterable)Iterables.transform(unfinishedSubtasks, ISSUE_TO_ID_FUNCTION));
        for (Issue unfinishedParent : unfinishedParents) {
            Collection subtasks = unfinishedParent.getSubTaskObjects();
            if (subtasks.isEmpty()) continue;
            boolean unfinishedSubtaskFound = false;
            boolean finishedSubtaskFound = false;
            for (Issue subtask : subtasks) {
                if (unfinishedSubtasks_ids.contains(subtask.getId())) {
                    unfinishedSubtaskFound = true;
                    continue;
                }
                finishedSubtaskFound = true;
            }
            if (!unfinishedSubtaskFound || !finishedSubtaskFound) continue;
            partiallyCompleteParents_ids.add(unfinishedParent.getId());
        }
        for (Long id : partiallyCompleteParents_ids) {
            partiallyCompleteParents.add((Issue)this.issueManager.getIssueObject(id));
        }
        return partiallyCompleteParents;
    }

    @Nonnull
    public ServiceOutcome<List<Issue>> getIncompleteParentIssuesFromSprint(ApplicationUser user, Sprint sprint, RapidView rapidView) {
        ServiceOutcome<SearchResults<Issue>> search;
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue());
        queryBuilder.where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint)).issueTypeIsStandard();
        ServiceOutcome<ClauseToAdd> addClauseOutcome = this.rapidViewClauseService.getDefinitionOfNotDoneClause(user, rapidView);
        if (!addClauseOutcome.isValid()) {
            return ServiceOutcomeImpl.error(addClauseOutcome);
        }
        if (addClauseOutcome.getValue().hasClause()) {
            addClauseOutcome.getValue().appendWithDefaultAnd(queryBuilder);
        }
        if (!(search = this.searchService.search(user, queryBuilder.buildQuery())).isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        return ServiceOutcomeImpl.ok(search.getValue().getResults());
    }

    private Predicate<Issue> areIssuesPartOfAnotherActiveSprint(Sprint sprint) {
        return input -> {
            Collection sprints = (Collection)input.getCustomFieldValue(this.sprintCustomFieldService.getDefaultSprintField());
            Boolean activeSprints = Iterables.any((Iterable)sprints, (Predicate)Predicates.and(SprintUtils.SPRINT_ACTIVE, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)sprint))));
            return activeSprints;
        };
    }

    public boolean wasIssueCompletedInAnotherSprint(Sprint sprint, Issue issue) {
        return this.wereIssuesCompletedInAnotherSprint(sprint).apply((Object)issue);
    }

    private Predicate<Issue> wereIssuesCompletedInAnotherSprint(Sprint sprint) {
        return issue -> {
            long sprintCompleteTime;
            if (issue.getResolutionDate() == null) {
                return false;
            }
            long issueResolutionTime = DateUtils.truncateMilliseconds(issue.getResolutionDate());
            boolean isIssueClosedAfterSprintComplete = issueResolutionTime >= (sprintCompleteTime = DateUtils.truncateMilliseconds(sprint.getCompleteDate().getMillis()));
            return isIssueClosedAfterSprintComplete && this.currentSprintIsNotTheMostRecentSprintOfIssues(sprint, (Issue)issue);
        };
    }

    private boolean currentSprintIsNotTheMostRecentSprintOfIssues(Sprint currentSprint, Issue input) {
        Collection sprints = (Collection)input.getCustomFieldValue(this.sprintCustomFieldService.getDefaultSprintField());
        return !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)sprints, SprintUtils.getAllClosedSprintsAfterTheGivenOne(currentSprint)));
    }

    static final class StandardIssueType
    implements Predicate<Issue> {
        private static final StandardIssueType INSTANCE = new StandardIssueType();

        private StandardIssueType() {
        }

        static StandardIssueType issueTypeIsStandard() {
            return INSTANCE;
        }

        public boolean apply(Issue issue) {
            return !issue.isSubTask();
        }
    }
}

