/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RecentSprintHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.SprintListEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintNameSuggester;
import com.atlassian.greenhopper.web.rapid.sprint.model.EditSprintModel;
import com.atlassian.greenhopper.web.rapid.sprint.model.SprintPickerModel;
import com.atlassian.greenhopper.web.rapid.sprint.model.SwapSprintRequest;
import com.atlassian.greenhopper.web.rapid.sprint.model.UpdateSprintRequest;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="sprint")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SprintResource
extends AbstractResource {
    private final RapidViewService rapidViewService;
    private final SprintService sprintService;
    private final SprintPermissionService sprintPermissionService;
    private final SprintEntryFactory sprintEntryFactory;
    private final SprintIssueService sprintIssueService;
    private final I18nFactoryService i18nFactoryService;
    private final RapidViewSprintQueryService rapidViewSprintQueryService;
    private final SprintHelper sprintHelper;
    private final RecentSprintHistoryService recentSprintHistoryService;
    @Autowired
    private final DateTimeFormatter dateTimeFormatterFactory;

    public SprintResource(RapidViewService rapidViewService, SprintService sprintService, SprintPermissionService sprintPermissionService, SprintEntryFactory sprintEntryFactory, SprintIssueService sprintIssueService, SprintHelper sprintHelper, I18nFactoryService i18nFactoryService, RapidViewSprintQueryService rapidViewSprintQueryService, RecentSprintHistoryService recentSprintHistoryService, DateTimeFormatter dateTimeFormatterFactory) {
        this.rapidViewService = rapidViewService;
        this.rapidViewSprintQueryService = rapidViewSprintQueryService;
        this.sprintService = sprintService;
        this.sprintPermissionService = sprintPermissionService;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintIssueService = sprintIssueService;
        this.sprintHelper = sprintHelper;
        this.i18nFactoryService = i18nFactoryService;
        this.recentSprintHistoryService = recentSprintHistoryService;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @GET
    @Path(value="/picker")
    public Response listSprints(final @DefaultValue(value="") @QueryParam(value="query") String searchQuery, final @DefaultValue(value="50") @QueryParam(value="maxResults") int maxResults, final @DefaultValue(value="true") @QueryParam(value="excludeCompleted") boolean excludeCompleted) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                SprintListEntryTransformer sprintListEntryTransformer = SprintResource.this.sprintEntryFactory.newSprintListTransformer(user);
                HashSet suggestions = Sets.newHashSet(SprintResource.this.sprintHelper.findSprintsByNameInHistory(user, searchQuery, maxResults, excludeCompleted));
                Set<Sprint> allMatches = SprintResource.this.check(SprintResource.this.sprintHelper.findSprintPickerAllMatches(user, suggestions, searchQuery, maxResults, excludeCompleted));
                SprintPickerModel model = new SprintPickerModel();
                model.suggestions = sprintListEntryTransformer.apply(Lists.newArrayList((Iterable)suggestions));
                model.allMatches = sprintListEntryTransformer.apply(Lists.newArrayList(allMatches));
                return SprintResource.this.createOkResponse(model);
            }
        });
    }

    @GET
    @Path(value="{sprintId}/edit/model")
    public Response getEditModel(final @PathParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                Sprint sprint = SprintResource.this.check(SprintResource.this.sprintService.getSprint(user, sprintId));
                SprintResource.this.checkResult(SprintResource.this.sprintPermissionService.canUpdateSprint(user, sprint));
                EditSprintModel model = new EditSprintModel();
                model.sprint = (SprintEditEntry)SprintResource.this.sprintEntryFactory.newEditTransformer(user).apply(sprint);
                model.dateTimePickerFormat = CustomFieldUtils.getDateTimeFormat();
                return SprintResource.this.createOkResponse(model);
            }
        });
    }

    @POST
    @Path(value="{rapidViewId}")
    public Response createSprint(final @PathParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                RapidView rapidView = SprintResource.this.check(SprintResource.this.rapidViewService.getRapidView(user, rapidViewId));
                List<Sprint> sprints = SprintResource.this.check(SprintResource.this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.allOf(Sprint.State.class), false));
                String sprintName = SprintNameSuggester.suggestSprintName(sprints, SprintResource.this.i18nFactoryService.getI18n(user), rapidView);
                Sprint sprint = Sprint.builder().rapidViewId(rapidViewId).state(Sprint.State.FUTURE).name(sprintName).build();
                sprint = SprintResource.this.check(SprintResource.this.sprintService.createSprint(user, sprint));
                SprintResource.this.recentSprintHistoryService.storeSprint(user, sprint);
                return SprintResource.this.createOkResponse((RestTemplate)SprintResource.this.sprintEntryFactory.newEditTransformer(user).apply(sprint));
            }
        });
    }

    @PUT
    @Path(value="{sprintId}")
    public Response updateSprint(final @PathParam(value="sprintId") Long sprintId, final UpdateSprintRequest updateSprintRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                Sprint sprint = SprintResource.this.check(SprintResource.this.sprintService.getSprint(user, sprintId));
                SprintResource.this.checkResult(SprintResource.this.sprintPermissionService.canUpdateSprint(user, sprint));
                Sprint updatedSprint = SprintResource.this.check(SprintResource.this.sprintHelper.createUpdatedSprint(user, sprint, updateSprintRequest));
                Sprint updatedSprintOutcome = SprintResource.this.check(SprintResource.this.sprintService.updateSprint(user, updatedSprint));
                return SprintResource.this.createOkResponse((RestTemplate)SprintResource.this.sprintEntryFactory.newEditTransformer(user).apply(updatedSprintOutcome));
            }
        });
    }

    @PUT
    @Path(value="{sprintId}/swap")
    public Response moveSprint(final @PathParam(value="sprintId") Long sprintId, final SwapSprintRequest swapSprintRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                if (swapSprintRequest.otherSprintId == null) {
                    SprintResource.this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.sprint.error.no.swap.specified", new Object[0]));
                }
                Sprint sprintA = SprintResource.this.check(SprintResource.this.sprintService.getSprint(user, sprintId));
                Sprint sprintB = SprintResource.this.check(SprintResource.this.sprintService.getSprint(user, swapSprintRequest.otherSprintId));
                SprintResource.this.checkResult(SprintResource.this.sprintService.swapSprints(user, sprintA, sprintB));
                sprintA = SprintResource.this.check(SprintResource.this.sprintService.getSprint(user, sprintId));
                return SprintResource.this.createOkResponse((RestTemplate)SprintResource.this.sprintEntryFactory.newEditTransformer(user).apply(sprintA));
            }
        });
    }

    @DELETE
    @Path(value="{sprintId}")
    public Response deleteSprint(final @PathParam(value="sprintId") Long sprintId, final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintResource.this.getUser();
                Sprint sprint = SprintResource.this.check(SprintResource.this.sprintService.getSprint(SprintResource.this.getUser(), sprintId));
                SprintResource.this.checkResult(SprintResource.this.sprintService.deleteSprint(user, sprint, rapidViewId));
                return SprintResource.this.createNoContentResponse();
            }
        });
    }
}

