/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.util.Transformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintReportEntry;
import org.joda.time.DateTime;

public class SprintReportEntryTransformer
extends Transformer<Sprint, SprintReportEntry> {
    private final SprintBaseEntryTransformer sprintBaseEntryTransformer;

    public SprintReportEntryTransformer(SprintBaseEntryTransformer sprintBaseEntryTransformer) {
        this.sprintBaseEntryTransformer = sprintBaseEntryTransformer;
    }

    @Override
    protected SprintReportEntry make() {
        return new SprintReportEntry();
    }

    @Override
    protected void transform(Sprint sprint, SprintReportEntry sprintReportEntry) {
        this.sprintBaseEntryTransformer.transform(sprint, sprintReportEntry);
        sprintReportEntry.startTime = sprint.getStartDate().getMillis();
        sprintReportEntry.endTime = this.getApplicableSprintEndDate(sprint).getMillis();
    }

    private DateTime getApplicableSprintEndDate(Sprint sprint) {
        return sprint.isClosed() ? sprint.getCompleteDate() : sprint.getEndDate();
    }
}

