/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.api.rank.web.RankResponse;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.rank.RankChangesOutcomeImpl;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.api.RankHelper;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.model.RemoveFromSprintModel;
import com.atlassian.greenhopper.web.rapid.sprint.model.RemoveFromSprintRequest;
import com.atlassian.greenhopper.web.rapid.sprint.model.SprintRankRequest;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="sprint/rank")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SprintRankResource
extends AbstractResource {
    private final IssueHelper issueHelper;
    private final SprintService sprintService;
    private final RankService rankService;
    private final SprintIssueService sprintIssueService;
    private final RankableFactory rankableFactory;
    private final RapidViewService rapidViewService;
    private final SprintHelper sprintHelper;
    private final SprintEntryFactory sprintEntryFactory;
    private final SprintPermissionService sprintPermissionService;
    private final RankHelper rankHelper;
    private final RapidIssueEntryQueryService rapidIssueEntryQueryService;

    public SprintRankResource(RankHelper rankHelper, IssueHelper issueHelper, SprintService sprintService, RankService rankService, SprintIssueService sprintIssueService, RankableFactory rankableFactory, RapidViewService rapidViewService, SprintHelper sprintHelper, SprintEntryFactory sprintEntryFactory, SprintPermissionService sprintPermissionService, RapidIssueEntryQueryService rapidIssueEntryQueryService) {
        this.rankHelper = rankHelper;
        this.issueHelper = issueHelper;
        this.sprintService = sprintService;
        this.rankService = rankService;
        this.sprintIssueService = sprintIssueService;
        this.rankableFactory = rankableFactory;
        this.rapidViewService = rapidViewService;
        this.sprintHelper = sprintHelper;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintPermissionService = sprintPermissionService;
        this.rapidIssueEntryQueryService = rapidIssueEntryQueryService;
    }

    @PUT
    public Response updateSprintAndRank(SprintRankRequest request) {
        return this.response(() -> {
            if (!(request.sprintId != null || request.addToBacklog != null && request.addToBacklog.booleanValue())) {
                throw new IllegalArgumentException("Invalid combination of sprintId and addToBacklog. Issues must either be added to the backlog or to a sprint.");
            }
            if (request.sprintId != null && request.addToBacklog != null && request.addToBacklog.booleanValue()) {
                throw new IllegalArgumentException("Invalid combination of sprintId and addToBacklog. Cannot add to sprint and backlog at the same time.");
            }
            Sprint sprint = null;
            if (request.sprintId != null) {
                sprint = this.check(this.getNonClosedSprintOutcome(request.sprintId));
            }
            List<Issue> issues = this.check(this.issueHelper.findIssuesList(request.idOrKeys));
            if (sprint != null) {
                this.checkResult(this.sprintIssueService.moveIssuesToSprint(this.getUser(), sprint, issues));
            } else {
                this.checkResult(this.sprintIssueService.moveIssuesToBacklog(this.getUser(), issues));
            }
            if (request.calculateNewIssuesOrder) {
                RankResponse rankResponse = new RankResponse();
                RapidView rapidView = this.check(this.rapidViewService.getRapidView(this.getUser(), request.rapidViewId));
                boolean rankable = request.customFieldId != null;
                boolean movedToSprint = sprint != null;
                rankResponse.newIssuesOrder = this.check(this.rapidIssueEntryQueryService.collectScrumPlanModeIssueKeys(this.getUser(), rapidView, rankable, movedToSprint, issues.size()));
                return Response.ok((Object)rankResponse).build();
            }
            List<Rankable> rankablesToMove = this.rankableFactory.fromIssues(issues);
            return this.rankHelper.createRankResponse(this.getRankChanges(request, rankablesToMove));
        });
    }

    @GET
    @Path(value="{rapidViewId}/remove")
    public Response getRemoveFromSprintData(@PathParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="issues") List<String> issueKeys) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            List<Issue> issues = this.check(this.issueHelper.findIssuesList(issueKeys));
            this.checkResult(this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues));
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
            Map<Sprint, List<Issue>> sprintToIssues = this.check(this.sprintHelper.calculateCurrentSprintAssignment(user, issues));
            Set<Issue> doneIssues = this.sprintHelper.findDoneIssues(rapidView, issues);
            SprintHelper.FutureSprintMapping futureSprintMapping = this.check(this.sprintHelper.getFutureSprintMapping(user, rapidView));
            SprintEditEntryTransformer sprintEditEntryTransformer = this.sprintEntryFactory.newEditTransformer(user);
            RemoveFromSprintModel result = RemoveFromSprintModel.toResult(rapidView, sprintToIssues, doneIssues, futureSprintMapping, sprintEditEntryTransformer);
            return this.createOkResponse(result);
        });
    }

    @PUT
    @Path(value="{rapidViewId}/remove")
    public Response removeFromSprint(RemoveFromSprintRequest request) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            List<Issue> issues = this.check(this.issueHelper.findIssuesList(request.idOrKeys));
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, request.rapidViewId));
            Map<Sprint, List<Issue>> sprintToIssues = this.check(this.sprintHelper.calculateCurrentSprintAssignment(user, issues));
            Set<Issue> doneIssues = this.sprintHelper.findDoneIssues(rapidView, issues);
            SprintHelper.FutureSprintMapping futureSprintMapping = this.check(this.sprintHelper.getFutureSprintMapping(user, rapidView));
            this.check(this.sprintHelper.removeFromCurrentSprints(user, sprintToIssues));
            this.sprintHelper.addToNextFutureSprint(user, rapidView, sprintToIssues, doneIssues, futureSprintMapping);
            SprintEditEntryTransformer sprintEditEntryTransformer = this.sprintEntryFactory.newEditTransformer(user);
            RemoveFromSprintModel result = RemoveFromSprintModel.toResult(rapidView, sprintToIssues, doneIssues, futureSprintMapping, sprintEditEntryTransformer);
            return Response.ok((Object)result).build();
        });
    }

    private RankChangesOutcome getRankChanges(SprintRankRequest request, List<Rankable> rankablesToMove) {
        Option<Rankable> beforeRankable = this.resolveRankable(request.idOrKeyBefore);
        Option<Rankable> afterRankable = this.resolveRankable(request.idOrKeyAfter);
        if (beforeRankable.isDefined()) {
            ServiceOutcome<RankChangesOutcome> outcome = this.rankService.rankBefore(this.getUser(), (long)request.customFieldId, rankablesToMove, (Rankable)beforeRankable.get());
            return this.check(outcome);
        }
        if (afterRankable.isDefined()) {
            ServiceOutcome<RankChangesOutcome> outcome = this.rankService.rankAfter(this.getUser(), (long)request.customFieldId, rankablesToMove, (Rankable)afterRankable.get());
            return this.check(outcome);
        }
        return RankChangesOutcomeImpl.buildNoop();
    }

    private ServiceOutcome<Sprint> getNonClosedSprintOutcome(Long sprintId) {
        return ServiceOutcomes.flatMap(this.sprintService.getSprint(this.getUser(), sprintId), sprint -> {
            if (sprint.isClosed()) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.sprint.closed", new Object[0]);
            }
            return ServiceOutcomeImpl.ok(sprint);
        });
    }

    private Option<Rankable> resolveRankable(String idOrKey) {
        if (StringUtils.isEmpty((CharSequence)idOrKey)) {
            return Option.none();
        }
        Issue issue = this.check(this.issueHelper.findIssue(idOrKey));
        Rankable rankable = this.rankableFactory.fromIssue(issue);
        return Option.some((Object)rankable);
    }
}

