/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.model.SprintsEntry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="sprintquery/{rapidViewId}")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SprintQueryResource
extends AbstractResource {
    private final RapidViewService rapidViewService;
    private final RapidViewSprintQueryService rapidViewSprintQueryService;
    private final SprintEntryFactory sprintEntryFactory;

    public SprintQueryResource(RapidViewService rapidViewService, SprintEntryFactory sprintEntryFactory, RapidViewSprintQueryService rapidViewSprintQueryService) {
        this.rapidViewService = rapidViewService;
        this.sprintEntryFactory = sprintEntryFactory;
        this.rapidViewSprintQueryService = rapidViewSprintQueryService;
    }

    @GET
    public Response getAllSprintsForRapidView(final @PathParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="includeHistoricSprints") boolean includeHistoricSprints, final @QueryParam(value="includeFutureSprints") boolean includeFutureSprints) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintQueryResource.this.getUser();
                RapidView rapidView = SprintQueryResource.this.check(SprintQueryResource.this.rapidViewService.getRapidView(user, rapidViewId));
                EnumSet<Sprint.State> states = EnumSet.of(Sprint.State.ACTIVE, Sprint.State.CLOSED);
                if (includeFutureSprints) {
                    states.add(Sprint.State.FUTURE);
                }
                List<Sprint> sprints = SprintQueryResource.this.check(SprintQueryResource.this.rapidViewSprintQueryService.getSprints(user, rapidView, states, includeHistoricSprints));
                SprintsEntry entry = new SprintsEntry();
                entry.rapidViewId = rapidViewId;
                entry.sprints = SprintQueryResource.this.sprintEntryFactory.newBaseTransformer(user).apply(sprints);
                return Response.ok((Object)entry).build();
            }
        });
    }
}

