/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.util.TimeRemainingFormatter;
import com.atlassian.greenhopper.util.Transformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPlanEntry;
import com.atlassian.jira.user.ApplicationUser;
import org.joda.time.DateTime;

public class SprintPlanEntryTransformer
extends Transformer<Sprint, SprintPlanEntry> {
    protected final ApplicationUser user;
    protected final SprintEditEntryTransformer entryTransformer;
    protected final TimeRemainingFormatter timeRemainingFormatter;
    protected final SprintPermissionService sprintPermissionService;

    public SprintPlanEntryTransformer(ApplicationUser user, SprintEditEntryTransformer entryTransformer, TimeRemainingFormatter timeRemainingFormatter, SprintPermissionService sprintPermissionService) {
        this.entryTransformer = entryTransformer;
        this.timeRemainingFormatter = timeRemainingFormatter;
        this.sprintPermissionService = sprintPermissionService;
        this.user = user;
    }

    @Override
    protected SprintPlanEntry make() {
        return new SprintPlanEntry();
    }

    @Override
    protected void transform(Sprint sprint, SprintPlanEntry sprintPlanEntry) {
        this.entryTransformer.transform(sprint, sprintPlanEntry);
        sprintPlanEntry.timeRemaining = this.getTimeRemainingOrNull(sprint.getEndDate());
        sprintPlanEntry.canUpdateSprint = this.sprintPermissionService.canUpdateSprint(this.user, sprint).isValid();
    }

    private SprintPlanEntry.TimeRemaining getTimeRemainingOrNull(DateTime date) {
        if (date == null) {
            return null;
        }
        TimeRemainingFormatter.TimeRemaining timeRemaining = this.timeRemainingFormatter.format(date, this.entryTransformer.i18n);
        return SprintPlanEntry.TimeRemaining.from(timeRemaining);
    }
}

