/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.entity.common.LinkedPagesModel;
import com.atlassian.greenhopper.web.rapid.entity.common.RemoteEntityLinkModel;
import com.atlassian.greenhopper.web.rapid.entity.sprint.SprintLinkedPagesModelFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="sprint/{sprintId}/pages")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SprintPagesResource
extends AbstractResource {
    private SprintService sprintService;
    private SprintPermissionService sprintPermissionService;
    private SprintLinkedPagesModelFactory sprintLinkedPagesModelFactory;
    private JiraBaseUrls jiraBaseUrls;
    private InternalHostApplication internalHostApplication;

    public SprintPagesResource(SprintService sprintService, SprintPermissionService sprintPermissionService, SprintLinkedPagesModelFactory sprintLinkedPagesModelFactory, JiraBaseUrls jiraBaseUrls, InternalHostApplication internalHostApplication) {
        this.sprintService = sprintService;
        this.sprintPermissionService = sprintPermissionService;
        this.sprintLinkedPagesModelFactory = sprintLinkedPagesModelFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.internalHostApplication = internalHostApplication;
    }

    @DELETE
    public Response removePage(final @PathParam(value="sprintId") Long sprintId, final LinkPageToSprintModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintPagesResource.this.getUser();
                Sprint sprint = SprintPagesResource.this.check(SprintPagesResource.this.sprintService.getSprint(user, sprintId));
                RemoteEntityLinkModel remoteIssueLinkModel = SprintPagesResource.this.check(SprintPagesResource.this.sprintLinkedPagesModelFactory.linkPageToSprint(user, sprint, model.pageId, model.pageTitle));
                return SprintPagesResource.this.createOkResponse(remoteIssueLinkModel);
            }
        });
    }

    @POST
    public Response linkPage(final @PathParam(value="sprintId") Long sprintId, final LinkPageToSprintModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintPagesResource.this.getUser();
                Sprint sprint = SprintPagesResource.this.check(SprintPagesResource.this.sprintService.getSprint(user, sprintId));
                RemoteEntityLinkModel remoteIssueLinkModel = SprintPagesResource.this.check(SprintPagesResource.this.sprintLinkedPagesModelFactory.linkPageToSprint(user, sprint, model.pageId, model.pageTitle));
                return SprintPagesResource.this.createOkResponse(remoteIssueLinkModel);
            }
        });
    }

    @GET
    public Response getPages(final @PathParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintPagesResource.this.getUser();
                Sprint sprint = SprintPagesResource.this.check(SprintPagesResource.this.sprintService.getSprint(user, sprintId));
                LinkedPagesModel response = new LinkedPagesModel();
                response.jiraBaseUrl = SprintPagesResource.this.jiraBaseUrls.baseUrl();
                response.jiraApplicationId = SprintPagesResource.this.internalHostApplication.getId().get();
                response.applicationLinks = SprintPagesResource.this.sprintLinkedPagesModelFactory.findSupportedConfluenceApplicationLinks();
                response.pages = SprintPagesResource.this.sprintLinkedPagesModelFactory.getPagesForSprint(user, sprint, response.applicationLinks);
                response.canModifyPages = SprintPagesResource.this.sprintPermissionService.canUpdateSprint(user, sprint).isValid();
                return SprintPagesResource.this.createOkResponse(response);
            }
        });
    }

    @XmlRootElement
    public static class LinkPageToSprintModel
    extends RestTemplate {
        @XmlElement
        public String pageId;
        @XmlElement
        public String pageTitle;
    }
}

