/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SprintNameSuggester {
    private static final Pattern SPRINT = Pattern.compile("(^.*[\\p{Punct}\\p{Alpha}\\s])([0-9]+)$");
    private static final Pattern RAPID_VIEW_NAME_PREFIX = Pattern.compile("^\\s*(\\S{1,8}).*$");
    private static final int RAPID_VIEW_NAME_PREFIX_GROUP = 1;

    public static String suggestSprintName(List<Sprint> sprints, I18n2 i18n, RapidView rapidView) {
        if (sprints.isEmpty()) {
            return SprintNameSuggester.getFirstSprintName(i18n, rapidView);
        }
        Collections.sort(sprints, SprintUtils.SPRINT_NATURAL_COMPARATOR);
        Sprint lastSprint = sprints.get(sprints.size() - 1);
        return SprintNameSuggester.generateNextSprintName(lastSprint.getName());
    }

    public static String generateNextSprintName(String lastSprintName) {
        String defaultName = SprintNameSuggester.concatEnforceMaxLength(lastSprintName.trim() + " ", 2);
        Matcher matcher = SPRINT.matcher(lastSprintName);
        if (matcher.matches()) {
            String preName = matcher.group(1);
            String numberPart = matcher.group(2);
            try {
                int nextNumber = Integer.parseInt(numberPart) + 1;
                return SprintNameSuggester.concatEnforceMaxLength(preName, nextNumber);
            }
            catch (NumberFormatException e) {
                return defaultName;
            }
        }
        return defaultName;
    }

    private static String concatEnforceMaxLength(String prefix, int number) {
        String numberString = String.valueOf(number);
        int charactersLeft = 30 - numberString.length();
        if (prefix.length() > charactersLeft) {
            prefix = prefix.substring(0, charactersLeft - 1) + " ";
        }
        return prefix + number;
    }

    private static String getFirstSprintName(I18n2 i18n, RapidView rapidView) {
        Matcher matcher = RAPID_VIEW_NAME_PREFIX.matcher(rapidView.getName());
        String i18nSprint = i18n.getText("gh.sprint.default.name", (Object)1);
        if (matcher.matches()) {
            return String.format("%s %s", matcher.group(1), i18nSprint);
        }
        return i18nSprint;
    }
}

